/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.api.java.source.ui.snippet;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.netbeans.api.java.source.ui.snippet.MarkupTag;
import org.netbeans.api.java.source.ui.snippet.MarkupTagAttribute;

public final class SnippetMarkupTagExtractor {
    private int bufferPointer;
    private int bufferLength;
    private char currentChar;
    private char[] charBuffer;
    private static final char MARKUP_TAG_START_CHAR = '@';

    public List<MarkupTag> extract(String tagLine) {
        int tagLineLength = tagLine.length();
        this.charBuffer = new char[tagLineLength + 1];
        tagLine.getChars(0, tagLineLength, this.charBuffer, 0);
        this.bufferLength = tagLineLength;
        this.bufferPointer = -1;
        this.nextChar();
        return this.extractTag();
    }

    private List<MarkupTag> extractTag() {
        ArrayList<MarkupTag> markUpTags = new ArrayList<MarkupTag>();
        while (this.bufferPointer < this.bufferLength) {
            if (this.currentChar == '@') {
                markUpTags.add(this.readMarkUpTag());
                continue;
            }
            this.nextChar();
        }
        return markUpTags;
    }

    private MarkupTag readMarkUpTag() {
        this.nextChar();
        int nameBufferPointer = this.bufferPointer;
        String tagName = this.readMarkUpTagName();
        this.skipWhitespace();
        boolean isTagApplicableToNextLine = false;
        ArrayList<MarkupTagAttribute> markUpTagAttributes = new ArrayList();
        if (this.currentChar == ':') {
            isTagApplicableToNextLine = true;
            this.nextChar();
        } else {
            markUpTagAttributes = this.getAllMarkUpTagAttributes();
            this.skipWhitespace();
            if (this.currentChar == ':') {
                isTagApplicableToNextLine = true;
                this.nextChar();
            }
        }
        return new MarkupTag(tagName, markUpTagAttributes, isTagApplicableToNextLine);
    }

    private List<MarkupTagAttribute> getAllMarkUpTagAttributes() {
        ArrayList<MarkupTagAttribute> attrs = new ArrayList<MarkupTagAttribute>();
        this.skipWhitespace();
        while (this.bufferPointer < this.bufferLength && Character.isUnicodeIdentifierStart(this.currentChar)) {
            StringBuilder value = new StringBuilder();
            int nameStartPos = this.bufferPointer;
            String attributeName = this.readAttributeName();
            this.skipWhitespace();
            int valueStartPos = -1;
            if (this.currentChar == '=') {
                this.nextChar();
                this.skipWhitespace();
                if (this.currentChar == '\'' || this.currentChar == '\"') {
                    char charQuote = this.currentChar;
                    this.nextChar();
                    valueStartPos = this.bufferPointer;
                    while (this.bufferPointer < this.bufferLength && this.currentChar != charQuote) {
                        this.nextChar();
                    }
                    if (this.bufferPointer >= this.bufferLength) {
                        return null;
                    }
                    this.addRemainingText(value, valueStartPos, this.bufferPointer - 1);
                    this.nextChar();
                } else {
                    valueStartPos = this.bufferPointer;
                    while (this.bufferPointer < this.bufferLength && !SnippetMarkupTagExtractor.isValueTerminateWithoutQuote(this.currentChar)) {
                        this.nextChar();
                    }
                    this.addRemainingText(value, valueStartPos, this.bufferPointer - 1);
                }
                this.skipWhitespace();
            }
            MarkupTagAttribute markUpTagAttribute = new MarkupTagAttribute(attributeName, nameStartPos, value.toString(), valueStartPos);
            attrs.add(markUpTagAttribute);
        }
        return attrs;
    }

    private void addRemainingText(StringBuilder b, int textStart, int textEnd) {
        if (textStart != -1 && textStart <= textEnd) {
            b.append(this.charBuffer, textStart, textEnd - textStart + 1);
        }
    }

    private String readAttributeName() {
        return this.readName();
    }

    private String readMarkUpTagName() {
        return this.readName();
    }

    private String readName() {
        int start = this.bufferPointer;
        this.nextChar();
        while (this.bufferPointer < this.bufferLength && (Character.isUnicodeIdentifierPart(this.currentChar) || this.currentChar == '-')) {
            this.nextChar();
        }
        return new String(this.charBuffer, start, this.bufferPointer - start);
    }

    private static boolean isValueTerminateWithoutQuote(char ch) {
        return Arrays.asList(Character.valueOf(':'), Character.valueOf('\t'), Character.valueOf(' '), Character.valueOf('\"'), Character.valueOf('`'), Character.valueOf('\''), Character.valueOf('='), Character.valueOf('>'), Character.valueOf('<')).contains(Character.valueOf(ch));
    }

    private void skipWhitespace() {
        while (this.bufferPointer < this.bufferLength && Character.isWhitespace(this.currentChar)) {
            this.nextChar();
        }
    }

    private void nextChar() {
        this.currentChar = this.charBuffer[this.bufferPointer < this.bufferLength ? (this.bufferPointer = this.bufferPointer + 1) : this.bufferLength];
    }
}

