/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.beans;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.beans.VetoableChangeListener;
import java.beans.VetoableChangeSupport;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.EventListener;
import org.jdesktop.beans.AbstractBean;

public abstract class AbstractSerializableBean
extends AbstractBean
implements Serializable {
    protected AbstractSerializableBean() {
    }

    protected AbstractSerializableBean(PropertyChangeSupport pcs, VetoableChangeSupport vcs) {
        super(pcs, vcs);
    }

    private void writeObject(ObjectOutputStream s2) throws IOException {
        s2.defaultWriteObject();
        for (PropertyChangeListener propertyChangeListener : this.getPropertyChangeListeners()) {
            if (!(propertyChangeListener instanceof Serializable)) continue;
            s2.writeObject(propertyChangeListener);
        }
        for (EventListener eventListener : this.getVetoableChangeListeners()) {
            if (!(eventListener instanceof Serializable)) continue;
            s2.writeObject(eventListener);
        }
        s2.writeObject(null);
    }

    private void readObject(ObjectInputStream s2) throws ClassNotFoundException, IOException {
        Object listenerOrNull;
        s2.defaultReadObject();
        while (null != (listenerOrNull = s2.readObject())) {
            if (listenerOrNull instanceof PropertyChangeListener) {
                this.addPropertyChangeListener((PropertyChangeListener)listenerOrNull);
                continue;
            }
            if (!(listenerOrNull instanceof VetoableChangeListener)) continue;
            this.addVetoableChangeListener((VetoableChangeListener)listenerOrNull);
        }
    }
}

