/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.boot.models.annotations.internal;

import java.lang.annotation.Annotation;
import java.util.Map;
import org.hibernate.annotations.FilterJoinTable;
import org.hibernate.annotations.SqlFragmentAlias;
import org.hibernate.boot.jaxb.mapping.spi.JaxbFilterImpl;
import org.hibernate.boot.models.HibernateAnnotations;
import org.hibernate.boot.models.annotations.spi.FilterDetails;
import org.hibernate.boot.models.internal.OrmAnnotationHelper;
import org.hibernate.boot.models.xml.internal.FilterProcessing;
import org.hibernate.boot.models.xml.spi.XmlDocumentContext;
import org.hibernate.internal.util.StringHelper;
import org.hibernate.models.spi.ModelsContext;

public class FilterJoinTableAnnotation
implements FilterJoinTable,
FilterDetails {
    private String name;
    private String condition;
    private boolean deduceAliasInjectionPoints;
    private SqlFragmentAlias[] aliases;

    public FilterJoinTableAnnotation(ModelsContext modelContext) {
        this.condition = "";
        this.deduceAliasInjectionPoints = true;
        this.aliases = new SqlFragmentAlias[0];
    }

    public FilterJoinTableAnnotation(FilterJoinTable annotation, ModelsContext modelContext) {
        this.name = annotation.name();
        this.condition = annotation.condition();
        this.deduceAliasInjectionPoints = annotation.deduceAliasInjectionPoints();
        this.aliases = (SqlFragmentAlias[])OrmAnnotationHelper.extractJdkValue(annotation, HibernateAnnotations.FILTER_JOIN_TABLE, "aliases", modelContext);
    }

    public FilterJoinTableAnnotation(Map<String, Object> attributeValues, ModelsContext modelContext) {
        this.name = (String)attributeValues.get("name");
        this.condition = (String)attributeValues.get("condition");
        this.deduceAliasInjectionPoints = (Boolean)attributeValues.get("deduceAliasInjectionPoints");
        this.aliases = (SqlFragmentAlias[])attributeValues.get("aliases");
    }

    @Override
    public Class<? extends Annotation> annotationType() {
        return FilterJoinTable.class;
    }

    @Override
    public String name() {
        return this.name;
    }

    public void name(String value) {
        this.name = value;
    }

    @Override
    public String condition() {
        return this.condition;
    }

    public void condition(String value) {
        this.condition = value;
    }

    @Override
    public boolean deduceAliasInjectionPoints() {
        return this.deduceAliasInjectionPoints;
    }

    public void deduceAliasInjectionPoints(boolean value) {
        this.deduceAliasInjectionPoints = value;
    }

    @Override
    public SqlFragmentAlias[] aliases() {
        return this.aliases;
    }

    public void aliases(SqlFragmentAlias[] value) {
        this.aliases = value;
    }

    @Override
    public void apply(JaxbFilterImpl jaxbFilter, XmlDocumentContext xmlDocumentContext) {
        this.name(jaxbFilter.getName());
        if (StringHelper.isNotEmpty(jaxbFilter.getCondition())) {
            this.condition(jaxbFilter.getCondition());
        }
        if (jaxbFilter.isAutoAliasInjection() != null) {
            this.deduceAliasInjectionPoints(jaxbFilter.isAutoAliasInjection());
        }
        this.aliases(FilterProcessing.collectSqlFragmentAliases(jaxbFilter.getAliases(), xmlDocumentContext));
    }
}

