/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.resteasy.common.spi;

import io.quarkus.deployment.builditem.nativeimage.ReflectiveHierarchyBuildItem;
import jakarta.inject.Inject;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Predicate;
import org.jboss.jandex.DotName;
import org.jboss.jandex.FieldInfo;
import org.jboss.jandex.MethodInfo;

public final class ResteasyDotNames {
    public static final DotName APPLICATION = DotName.createSimple((String)"jakarta.ws.rs.core.Application");
    public static final DotName CONSUMES = DotName.createSimple((String)"jakarta.ws.rs.Consumes");
    public static final DotName PRODUCES = DotName.createSimple((String)"jakarta.ws.rs.Produces");
    public static final DotName PROVIDER = DotName.createSimple((String)"jakarta.ws.rs.ext.Provider");
    public static final DotName GET = DotName.createSimple((String)"jakarta.ws.rs.GET");
    public static final DotName HEAD = DotName.createSimple((String)"jakarta.ws.rs.HEAD");
    public static final DotName DELETE = DotName.createSimple((String)"jakarta.ws.rs.DELETE");
    public static final DotName OPTIONS = DotName.createSimple((String)"jakarta.ws.rs.OPTIONS");
    public static final DotName PATCH = DotName.createSimple((String)"jakarta.ws.rs.PATCH");
    public static final DotName POST = DotName.createSimple((String)"jakarta.ws.rs.POST");
    public static final DotName PUT = DotName.createSimple((String)"jakarta.ws.rs.PUT");
    public static final DotName APPLICATION_PATH = DotName.createSimple((String)"jakarta.ws.rs.ApplicationPath");
    public static final DotName PATH = DotName.createSimple((String)"jakarta.ws.rs.Path");
    public static final DotName DYNAMIC_FEATURE = DotName.createSimple((String)"jakarta.ws.rs.container.DynamicFeature");
    public static final DotName CONTEXT = DotName.createSimple((String)"jakarta.ws.rs.core.Context");
    public static final DotName PATH_PARAM = DotName.createSimple((String)"jakarta.ws.rs.PathParam");
    public static final DotName QUERY_PARAM = DotName.createSimple((String)"jakarta.ws.rs.QueryParam");
    public static final DotName HEADER_PARAM = DotName.createSimple((String)"jakarta.ws.rs.HeaderParam");
    public static final DotName FORM_PARAM = DotName.createSimple((String)"jakarta.ws.rs.FormParam");
    public static final DotName MATRIX_PARAM = DotName.createSimple((String)"jakarta.ws.rs.MatrixParam");
    public static final DotName COOKIE_PARAM = DotName.createSimple((String)"jakarta.ws.rs.CookieParam");
    public static final DotName RESTEASY_QUERY_PARAM = DotName.createSimple((String)"org.jboss.resteasy.annotations.jaxrs.QueryParam");
    public static final DotName RESTEASY_FORM_PARAM = DotName.createSimple((String)"org.jboss.resteasy.annotations.jaxrs.FormParam");
    public static final DotName RESTEASY_COOKIE_PARAM = DotName.createSimple((String)"org.jboss.resteasy.annotations.jaxrs.CookieParam");
    public static final DotName RESTEASY_PATH_PARAM = DotName.createSimple((String)"org.jboss.resteasy.annotations.jaxrs.PathParam");
    public static final DotName RESTEASY_HEADER_PARAM = DotName.createSimple((String)"org.jboss.resteasy.annotations.jaxrs.HeaderParam");
    public static final DotName RESTEASY_MATRIX_PARAM = DotName.createSimple((String)"org.jboss.resteasy.annotations.jaxrs.MatrixParam");
    public static final DotName RESTEASY_SSE_ELEMENT_TYPE = DotName.createSimple((String)"org.jboss.resteasy.annotations.SseElementType");
    public static final DotName RESTEASY_PART_TYPE = DotName.createSimple((String)"org.jboss.resteasy.annotations.providers.multipart.PartType");
    public static final DotName CDI_INJECT = DotName.createSimple((String)Inject.class.getName());
    public static final DotName JSON_IGNORE = DotName.createSimple((String)"com.fasterxml.jackson.annotation.JsonIgnore");
    public static final DotName JSONB_TRANSIENT = DotName.createSimple((String)"jakarta.json.bind.annotation.JsonbTransient");
    public static final DotName XML_TRANSIENT = DotName.createSimple((String)"jakarta.xml.bind.annotation.XmlTransient");
    public static final List<DotName> JAXRS_METHOD_ANNOTATIONS = List.of(GET, POST, HEAD, DELETE, PUT, PATCH, OPTIONS);
    public static final IgnoreTypeForReflectionPredicate IGNORE_TYPE_FOR_REFLECTION_PREDICATE = new IgnoreTypeForReflectionPredicate();
    public static final IgnoreFieldForReflectionPredicate IGNORE_FIELD_FOR_REFLECTION_PREDICATE = new IgnoreFieldForReflectionPredicate();
    public static final IgnoreMethodForReflectionPredicate IGNORE_METHOD_FOR_REFLECTION_PREDICATE = new IgnoreMethodForReflectionPredicate();
    private static final Set<DotName> TYPES_IGNORED_FOR_REFLECTION = new HashSet<DotName>(List.of());
    private static final String[] PACKAGES_IGNORED_FOR_REFLECTION = new String[]{"jakarta.json.", "jakarta.json.", "com.fasterxml.jackson.databind.", "jakarta.ws.rs.", "org.jboss.resteasy.", "io.vertx.core.json.", "io.smallrye.mutiny."};

    private static class IgnoreTypeForReflectionPredicate
    implements Predicate<DotName> {
        private IgnoreTypeForReflectionPredicate() {
        }

        @Override
        public boolean test(DotName dotName) {
            if (TYPES_IGNORED_FOR_REFLECTION.contains(dotName) || ReflectiveHierarchyBuildItem.DefaultIgnoreTypePredicate.INSTANCE.test(dotName)) {
                return true;
            }
            String name = dotName.toString();
            for (String packageName : PACKAGES_IGNORED_FOR_REFLECTION) {
                if (!name.startsWith(packageName)) continue;
                return true;
            }
            return false;
        }
    }

    private static class IgnoreFieldForReflectionPredicate
    implements Predicate<FieldInfo> {
        private IgnoreFieldForReflectionPredicate() {
        }

        @Override
        public boolean test(FieldInfo fieldInfo) {
            return fieldInfo.hasAnnotation(JSON_IGNORE) || fieldInfo.hasAnnotation(JSONB_TRANSIENT) || fieldInfo.hasAnnotation(XML_TRANSIENT);
        }
    }

    private static class IgnoreMethodForReflectionPredicate
    implements Predicate<MethodInfo> {
        private IgnoreMethodForReflectionPredicate() {
        }

        @Override
        public boolean test(MethodInfo methodInfo) {
            return methodInfo.hasAnnotation(JSON_IGNORE) || methodInfo.hasAnnotation(JSONB_TRANSIENT) || methodInfo.hasAnnotation(XML_TRANSIENT);
        }
    }
}

