/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.runtime.configuration;

import io.quarkus.runtime.configuration.QuarkusConfigBuilderCustomizer;
import io.smallrye.config.SmallRyeConfig;
import io.smallrye.config.SmallRyeConfigBuilder;
import io.smallrye.config.SmallRyeConfigBuilderCustomizer;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import org.eclipse.microprofile.config.Config;
import org.eclipse.microprofile.config.ConfigProvider;
import org.eclipse.microprofile.config.ConfigValue;

public final class ConfigUtils {
    private ConfigUtils() {
    }

    public static SmallRyeConfigBuilder configBuilder() {
        return ConfigUtils.emptyConfigBuilder().addDiscoveredCustomizers().addDiscoveredSources();
    }

    public static SmallRyeConfigBuilder emptyConfigBuilder() {
        return new SmallRyeConfigBuilder().forClassLoader(Thread.currentThread().getContextClassLoader()).withCustomizers(new SmallRyeConfigBuilderCustomizer[]{new QuarkusConfigBuilderCustomizer()}).addDiscoveredConverters().addDefaultInterceptors().addDiscoveredInterceptors().addDiscoveredSecretKeysHandlers().addDefaultSources();
    }

    public static List<String> getProfiles() {
        return ((SmallRyeConfig)ConfigProvider.getConfig().unwrap(SmallRyeConfig.class)).getProfiles();
    }

    public static boolean isProfileActive(String profile) {
        return ConfigUtils.getProfiles().contains(profile);
    }

    public static boolean isPropertyPresent(String propertyName) {
        return ((SmallRyeConfig)ConfigProvider.getConfig().unwrap(SmallRyeConfig.class)).isPropertyPresent(propertyName);
    }

    public static boolean isPropertyNonEmpty(String propertyName) {
        ConfigValue configValue = ConfigProvider.getConfig().getConfigValue(propertyName);
        return configValue.getValue() != null && !configValue.getValue().isEmpty();
    }

    public static boolean isAnyPropertyPresent(Collection<String> propertyNames) {
        for (String propertyName : propertyNames) {
            if (!ConfigUtils.isPropertyPresent(propertyName)) continue;
            return true;
        }
        return false;
    }

    public static <T> Optional<T> getFirstOptionalValue(List<String> propertyNames, Class<T> propertyType) {
        Config config = ConfigProvider.getConfig();
        for (String propertyName : propertyNames) {
            Optional value = config.getOptionalValue(propertyName, propertyType);
            if (!value.isPresent()) continue;
            return value;
        }
        return Optional.empty();
    }
}

