/*
 * Decompiled with CFR 0.152.
 */
package io.github.dan2097.jnarinchi.cheminfo;

import io.github.dan2097.jnainchi.InchiAtom;
import io.github.dan2097.jnainchi.InchiBond;
import io.github.dan2097.jnainchi.InchiBondStereo;
import io.github.dan2097.jnainchi.InchiBondType;
import io.github.dan2097.jnainchi.InchiRadical;
import io.github.dan2097.jnainchi.InchiStereo;
import io.github.dan2097.jnainchi.InchiStereoParity;
import io.github.dan2097.jnarinchi.ReactionComponentRole;
import io.github.dan2097.jnarinchi.ReactionFileFormat;
import io.github.dan2097.jnarinchi.RinchiInput;
import io.github.dan2097.jnarinchi.RinchiInputComponent;
import io.github.dan2097.jnarinchi.cheminfo.MdlReactionReaderException;
import io.github.dan2097.jnarinchi.cheminfo.MoleculeUtils;
import io.github.dan2097.jnarinchi.cheminfo.PeriodicTable;
import io.github.dan2097.jnarinchi.cheminfo.StereoUtils;
import java.io.BufferedReader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class MdlReactionReader {
    private final boolean guessTetrahedralChiralityFromBondsInfo;
    private final ReactionFileFormat expectedFormat;

    public MdlReactionReader() {
        this(ReactionFileFormat.AUTO, false);
    }

    public MdlReactionReader(ReactionFileFormat expectedFormat, boolean guessTetrahedralChiralityFromBondsInfo) {
        this.expectedFormat = expectedFormat;
        this.guessTetrahedralChiralityFromBondsInfo = guessTetrahedralChiralityFromBondsInfo;
    }

    public ReactionFileFormat getExpectedFormat() {
        return this.expectedFormat;
    }

    public boolean isGuessTetrahedralChiralityFromBondsInfo() {
        return this.guessTetrahedralChiralityFromBondsInfo;
    }

    public RinchiInput fileTextToRinchiInput(String inputString) throws MdlReactionReaderException {
        BufferedReader reader = new BufferedReader(new StringReader(inputString));
        return this.fileTextToRinchiInput(reader);
    }

    public RinchiInput fileTextToRinchiInput(BufferedReader inputReader) throws MdlReactionReaderException {
        return new MdlReactionReaderInstance(inputReader).toRinchiInput();
    }

    private class MdlReactionReaderInstance {
        private final List<String> errors = new ArrayList<String>();
        private final RinchiInput rInput = new RinchiInput();
        private final BufferedReader inputReader;
        private int curLineNum = 0;
        private int numOfReagentsToRead = 0;
        private int numOfProductsToRead = 0;
        private int numOfAtomsToRead = 0;
        private int numOfBondsToRead = 0;
        private String errorComponentContext = "";

        MdlReactionReaderInstance(BufferedReader inputReader) {
            this.inputReader = inputReader;
        }

        RinchiInput toRinchiInput() throws MdlReactionReaderException {
            try {
                this.iterateInputLines();
                this.inputReader.close();
            }
            catch (Exception x) {
                this.errors.add("Error on reading or closing input reader: " + x.getMessage());
            }
            if (!this.errors.isEmpty()) {
                throw new MdlReactionReaderException(this.errors);
            }
            return this.rInput;
        }

        private String readLine() {
            String line = null;
            ++this.curLineNum;
            try {
                line = this.inputReader.readLine();
            }
            catch (Exception x) {
                this.errors.add("Unable to read line " + this.curLineNum + ": " + x.getMessage());
            }
            return line;
        }

        private int iterateInputLines() {
            RinchiInputComponent ric;
            int i;
            ReactionFileFormat format;
            switch (MdlReactionReader.this.expectedFormat) {
                case AUTO: {
                    format = this.readAutoFileHeader();
                    break;
                }
                case RXN: {
                    this.readRxnFileHeader(true);
                    format = ReactionFileFormat.RXN;
                    break;
                }
                case RD: {
                    this.readRdFileHeader(true);
                    this.readRxnFileHeader(true);
                    format = ReactionFileFormat.RD;
                    break;
                }
                default: {
                    throw new IllegalStateException("Unexpected reaction format for expectedFormat");
                }
            }
            if (!this.errors.isEmpty()) {
                return this.errors.size();
            }
            this.readRxnCountLine();
            if (!this.errors.isEmpty()) {
                return this.errors.size();
            }
            for (i = 0; i < this.numOfReagentsToRead; ++i) {
                ric = this.readMdlMolecule(true);
                this.errorComponentContext = "Reading reagent #" + (i + 1) + " ";
                if (ric == null) {
                    return this.errors.size();
                }
                MoleculeUtils.setImplicitHydrogenAtoms(ric);
                ric.setRole(ReactionComponentRole.REAGENT);
                this.rInput.addComponent(ric);
            }
            for (i = 0; i < this.numOfProductsToRead; ++i) {
                ric = this.readMdlMolecule(true);
                this.errorComponentContext = "Reading product #" + (i + 1) + " ";
                if (ric == null) {
                    return this.errors.size();
                }
                MoleculeUtils.setImplicitHydrogenAtoms(ric);
                ric.setRole(ReactionComponentRole.PRODUCT);
                this.rInput.addComponent(ric);
            }
            if (format == ReactionFileFormat.RD) {
                this.iterateAgentsDataLines();
            }
            return 0;
        }

        private void iterateAgentsDataLines() {
            String line;
            int nAgents = 0;
            while ((line = this.readLine()) != null) {
                String line1;
                if (!line.startsWith("$DATUM ") || !(line1 = line.substring(7).trim()).startsWith("$MFMT")) continue;
                this.errorComponentContext = "Reading agent #" + (nAgents + 1) + " ";
                RinchiInputComponent ric = this.readMdlMolecule(false);
                if (ric != null) {
                    MoleculeUtils.setImplicitHydrogenAtoms(ric);
                    ric.setRole(ReactionComponentRole.AGENT);
                    this.rInput.addComponent(ric);
                }
                ++nAgents;
            }
        }

        private ReactionFileFormat readAutoFileHeader() {
            String line = this.readLine();
            if (line == null || !line.startsWith("$RDFILE") && !line.startsWith("$RXN")) {
                this.errors.add("RXN/RDFile Header: Line " + this.curLineNum + " is missing or does not start with $RXN or $RDFILE");
                return ReactionFileFormat.AUTO;
            }
            if (line.startsWith("$RDFILE")) {
                this.readRdFileHeader(false);
                this.readRxnFileHeader(true);
                return ReactionFileFormat.RD;
            }
            this.readRxnFileHeader(false);
            return ReactionFileFormat.RXN;
        }

        private void readRdFileHeader(boolean readRdFileLine) {
            String line = this.readLine();
            if (readRdFileLine) {
                if (line == null || !line.startsWith("$RDFILE")) {
                    this.errors.add("RDFile Header: Line " + this.curLineNum + " is missing or does not start with $RDFILE");
                    return;
                }
                line = this.readLine();
            }
            if (line == null || !line.startsWith("$DATM")) {
                this.errors.add("RDFile Header: Line " + this.curLineNum + " is missing or does not start with $DATM");
                return;
            }
            line = this.readLine();
            if (line == null || !line.startsWith("$RFMT")) {
                this.errors.add("RDFile Header: Line " + this.curLineNum + " is missing or does not start with $RFMT");
            }
        }

        private void readRxnFileHeader(boolean readRxnLine) {
            String line = this.readLine();
            if (readRxnLine) {
                if (line == null || !line.startsWith("$RXN")) {
                    this.errors.add("RXN Header: Line " + this.curLineNum + " is missing or does not start with $RXN");
                    return;
                }
                line = this.readLine();
            }
            if (line == null) {
                this.errors.add("RXN Header (reaction name): Line " + this.curLineNum + " is missing");
                return;
            }
            line = this.readLine();
            if (line == null) {
                this.errors.add("RXN Header (user name, progra, date,...): Line " + this.curLineNum + " is missing");
                return;
            }
            line = this.readLine();
            if (line == null) {
                this.errors.add("RXN Header (comment or blank): Line " + this.curLineNum + " is missing");
            }
        }

        private void readRxnCountLine() {
            String line = this.readLine();
            if (line == null) {
                this.errors.add("RXN counts Line " + this.curLineNum + " is missing !");
                return;
            }
            Integer rrr = this.readInteger(line, 0, 3);
            if (rrr == null || rrr < 0) {
                this.errors.add("RXN counts (rrrppp) Line  " + this.curLineNum + " : incorrect number of reagents (rrr part): " + line);
                return;
            }
            this.numOfReagentsToRead = rrr;
            Integer ppp = this.readInteger(line, 3, 3);
            if (ppp == null || ppp < 0) {
                this.errors.add("RXN counts (rrrppp) Line  " + this.curLineNum + " : incorrect number of reagents (ppp part): " + line);
            } else {
                this.numOfProductsToRead = ppp;
            }
        }

        private void readMolHeader(boolean readMolLine) {
            String line;
            if (readMolLine && ((line = this.readLine()) == null || !line.startsWith("$MOL"))) {
                this.errors.add(this.errorComponentContext + "MOL Start section in Line " + this.curLineNum + " is missing or does not start with $MOL --> " + line);
                return;
            }
            line = this.readLine();
            if (line == null) {
                this.errors.add(this.errorComponentContext + "MOL Header (line 1) in Line" + this.curLineNum + " is missing");
                return;
            }
            line = this.readLine();
            if (line == null) {
                this.errors.add(this.errorComponentContext + "MOL Header (line 2) in Line" + this.curLineNum + " is missing");
                return;
            }
            line = this.readLine();
            if (line == null) {
                this.errors.add(this.errorComponentContext + "MOL Header (line 3) in Line" + this.curLineNum + " is missing");
            }
        }

        private void readMolCountsLine() {
            String line = this.readLine();
            if (line == null) {
                this.errors.add("MOL counts Line " + this.curLineNum + " is missing !");
                return;
            }
            Integer aaa = this.readInteger(line, 0, 3);
            if (aaa == null || aaa < 0) {
                this.errors.add("MOL counts (aaabbblll...) Line  " + this.curLineNum + " : incorrect number of atoms (aaa part): " + line);
                return;
            }
            this.numOfAtomsToRead = aaa;
            Integer bbb = this.readInteger(line, 3, 3);
            if (bbb == null || bbb < 0) {
                this.errors.add("MOL counts (aaabbblll...) Line  " + this.curLineNum + " : incorrect number of bonds (bbb part): " + line);
            } else {
                this.numOfBondsToRead = bbb;
            }
        }

        private void readMolCtabBlock(RinchiInputComponent ric) {
            int i;
            HashMap<InchiAtom, InchiStereoParity> parities = new HashMap<InchiAtom, InchiStereoParity>();
            for (i = 0; i < this.numOfAtomsToRead; ++i) {
                this.readMolAtomLine(i, ric, parities);
                if (this.errors.isEmpty()) continue;
                return;
            }
            for (i = 0; i < this.numOfBondsToRead; ++i) {
                this.readMolBondLine(i, ric);
                if (this.errors.isEmpty()) continue;
                return;
            }
            if (!parities.isEmpty()) {
                for (Map.Entry e : parities.entrySet()) {
                    InchiStereo stereo = StereoUtils.createTetrahedralStereo(ric, (InchiAtom)e.getKey(), (InchiStereoParity)((Object)e.getValue()));
                    if (stereo == null) continue;
                    ric.addStereo(stereo);
                }
            }
            if (MdlReactionReader.this.guessTetrahedralChiralityFromBondsInfo) {
                StereoUtils.guessUndefinedTetrahedralStereosBasedOnBondInfo(ric, parities.keySet());
            }
        }

        private void readMolAtomLine(int atomIndex, RinchiInputComponent ric, Map<InchiAtom, InchiStereoParity> parities) {
            Integer parityCode;
            String atSymbol;
            String line = this.readLine();
            if (line == null) {
                this.errors.add(this.errorComponentContext + "MOL atom # " + (atomIndex + 1) + " in Line " + this.curLineNum + " is missing !");
                return;
            }
            Double coordX = this.readMdlCoordinate(line, 0);
            if (coordX == null) {
                this.errors.add(this.errorComponentContext + "MOL atom # " + (atomIndex + 1) + " in Line " + this.curLineNum + " coordinate x error --> " + line);
                return;
            }
            Double coordY = this.readMdlCoordinate(line, 10);
            if (coordY == null) {
                this.errors.add(this.errorComponentContext + "MOL atom # " + (atomIndex + 1) + " in Line " + this.curLineNum + " coordinate y error --> " + line);
                return;
            }
            Double coordZ = this.readMdlCoordinate(line, 20);
            if (coordZ == null) {
                this.errors.add(this.errorComponentContext + "MOL atom # " + (atomIndex + 1) + " in Line " + this.curLineNum + " coordinate z error --> " + line);
                return;
            }
            String string = atSymbol = 34 > line.length() ? null : line.substring(30, 34).trim();
            if (atSymbol == null) {
                this.errors.add(this.errorComponentContext + "MOL atom # " + (atomIndex + 1) + " in Line " + this.curLineNum + " atom symbol error --> " + line);
                return;
            }
            int atNum = PeriodicTable.getAtomicNumberFromElementSymbol(atSymbol);
            if (atNum == -1) {
                this.errors.add(this.errorComponentContext + "MOL atom # " + (atomIndex + 1) + " in Line " + this.curLineNum + " atom symbol error --> " + line);
                return;
            }
            Integer chCode = this.readInteger(line, 36, 3);
            if (chCode == null || chCode < 0 || chCode > 7) {
                this.errors.add(this.errorComponentContext + "MOL atom # " + (atomIndex + 1) + " in Line " + this.curLineNum + " atom charge coding error --> " + line);
                return;
            }
            int charge = this.getChargeFromOldCtabCoding(chCode);
            InchiAtom atom = new InchiAtom(atSymbol, coordX, coordY, coordZ);
            ric.addAtom(atom);
            if (charge != 0) {
                atom.setCharge(charge);
            }
            if (chCode == 4) {
                atom.setRadical(InchiRadical.DOUBLET);
            }
            if ((parityCode = this.readInteger(line, 39, 3)) == null || parityCode < 0 || parityCode > 3) {
                this.errors.add(this.errorComponentContext + "MOL atom # " + (atomIndex + 1) + " in Line " + this.curLineNum + " atom parity coding error --> " + line);
                return;
            }
            InchiStereoParity parity = this.getParity(parityCode);
            if (parity != null) {
                parities.put(atom, parity);
            }
        }

        private InchiStereoParity getParity(int parityCode) {
            switch (parityCode) {
                case 1: {
                    return InchiStereoParity.ODD;
                }
                case 2: {
                    return InchiStereoParity.EVEN;
                }
                case 3: {
                    return InchiStereoParity.UNKNOWN;
                }
            }
            return null;
        }

        private void readMolBondLine(int bondIndex, RinchiInputComponent ric) {
            String line = this.readLine();
            if (line == null) {
                this.errors.add(this.errorComponentContext + "MOL bond # " + (bondIndex + 1) + " in Line " + this.curLineNum + " is missing !");
                return;
            }
            Integer a1 = this.readInteger(line, 0, 3);
            if (a1 == null || a1 < 0 || a1 > this.numOfAtomsToRead) {
                this.errors.add("MOL counts (111222ttt...) Line  " + this.curLineNum + " : incorrect atom number (111 part): " + line);
                return;
            }
            Integer a2 = this.readInteger(line, 3, 3);
            if (a2 == null || a2 < 0 || a2 > this.numOfAtomsToRead) {
                this.errors.add("MOL counts (111222ttt...) Line  " + this.curLineNum + " : incorrect atom number (222 part): " + line);
                return;
            }
            Integer ttt = this.readInteger(line, 6, 3);
            if (ttt == null || ttt < 0 || ttt > 3) {
                this.errors.add("MOL counts (111222ttt...) Line  " + this.curLineNum + " : incorrect bond typer (ttt part): " + line);
                return;
            }
            Integer sss = this.readInteger(line, 9, 3);
            if (sss == null) {
                this.errors.add("MOL counts (111222ttt...) Line  " + this.curLineNum + " : incorrect bond stereo (sss part): " + line);
                return;
            }
            InchiBondStereo ibs = this.getBondStereoFromMdlCode(sss);
            if (ibs == null) {
                this.errors.add("MOL counts (111222ttt...) Line  " + this.curLineNum + " : incorrect bond stereo (sss part): " + line);
                return;
            }
            InchiBond bond = new InchiBond(ric.getAtom(a1 - 1), ric.getAtom(a2 - 1), InchiBondType.of((byte)ttt.intValue()), ibs);
            ric.addBond(bond);
        }

        private void readMolPropertiesBlock(RinchiInputComponent ric) {
            String line = this.readLine();
            while (this.processPropertyLine(line, ric) == 0) {
                line = this.readLine();
            }
        }

        private int processPropertyLine(String line, RinchiInputComponent ric) {
            if (line == null || line.startsWith("M  END")) {
                return -1;
            }
            if (line.startsWith("M  ISO")) {
                this.readIsotopePropertyLine(line, ric);
            }
            if (line.startsWith("M  CHG")) {
                this.readChargePropertyLine(line, ric);
            }
            if (line.startsWith("M  RAD")) {
                this.readRadicalPropertyLine(line, ric);
            }
            return 0;
        }

        private int readIsotopePropertyLine(String line, RinchiInputComponent ric) {
            Integer n = this.readInteger(line, 6, 3);
            if (n == null || n < 1 || n > 8) {
                this.errors.add("M ISO molecule property Line (M  ISOnn8 aaa vvv ...) " + this.curLineNum + " : incorrect number of atoms (nn8 part): " + line);
                return -1;
            }
            int pos = 9;
            for (int i = 0; i < n; ++i) {
                Integer atomIndex = this.readInteger(line, pos, 4);
                if (atomIndex == null || atomIndex < 1 || atomIndex > ric.getAtoms().size()) {
                    this.errors.add("M ISO molecule property Line (M  ISOnn8 aaa vvv ...) " + this.curLineNum + " : incorrect atom index for (aaa vvv) pair #" + (i + 1) + " in line: " + line);
                    return -2;
                }
                Integer mass = this.readInteger(line, pos += 4, 4);
                if (mass == null || mass < 1) {
                    this.errors.add("M ISO molecule property Line (M  ISOnn8 aaa vvv ...) " + this.curLineNum + " : incorrect mass for (aaa vvv) pair #" + (i + 1) + " in line: " + line);
                    return -3;
                }
                pos += 4;
                ric.getAtom(atomIndex - 1).setIsotopicMass(mass);
            }
            return 0;
        }

        private int readChargePropertyLine(String line, RinchiInputComponent ric) {
            Integer n = this.readInteger(line, 6, 3);
            if (n == null || n < 1 || n > 8) {
                this.errors.add("M CHG molecule property Line (M  CHGnn8 aaa vvv ...) " + this.curLineNum + " : incorrect number of atoms (nn8 part): " + line);
                return -1;
            }
            int pos = 9;
            for (int i = 0; i < n; ++i) {
                Integer atomIndex = this.readInteger(line, pos, 4);
                if (atomIndex == null || atomIndex < 1 || atomIndex > ric.getAtoms().size()) {
                    this.errors.add("M CHG molecule property Line (M  CHGnn8 aaa vvv ...) " + this.curLineNum + " : incorrect atom index for (aaa vvv) pair #" + (i + 1) + " in line: " + line);
                    return -2;
                }
                Integer charge = this.readInteger(line, pos += 4, 4);
                if (charge == null || charge < -15 || charge > 15) {
                    this.errors.add("M CHG molecule property Line (M  ISOnn8 aaa vvv ...) " + this.curLineNum + " : incorrect charge for (aaa vvv) pair #" + (i + 1) + " in line: " + line);
                    return -3;
                }
                pos += 4;
                ric.getAtom(atomIndex - 1).setCharge(charge);
            }
            return 0;
        }

        private int readRadicalPropertyLine(String line, RinchiInputComponent ric) {
            Integer n = this.readInteger(line, 6, 3);
            if (n == null || n < 1 || n > 8) {
                this.errors.add("M RAD molecule property Line (M  RADnn8 aaa vvv ...) " + this.curLineNum + " : incorrect number of atoms (nn8 part): " + line);
                return -1;
            }
            int pos = 9;
            for (int i = 0; i < n; ++i) {
                Integer atomIndex = this.readInteger(line, pos, 4);
                if (atomIndex == null || atomIndex < 1 || atomIndex > ric.getAtoms().size()) {
                    this.errors.add("M RAD molecule property Line (M  RADnn8 aaa vvv ...) " + this.curLineNum + " : incorrect atom index for (aaa vvv) pair #" + (i + 1) + " in line: " + line);
                    return -2;
                }
                Integer radCode = this.readInteger(line, pos += 4, 4);
                if (radCode == null || radCode < 0 || radCode > 3) {
                    this.errors.add("M RAD molecule property Line (M  RADnn8 aaa vvv ...) " + this.curLineNum + " : incorrect radical value for (aaa vvv) pair #" + (i + 1) + " in line: " + line);
                    return -3;
                }
                pos += 4;
                InchiRadical radical = this.getInchiRadical(radCode);
                ric.getAtom(atomIndex - 1).setRadical(radical);
            }
            return 0;
        }

        private RinchiInputComponent readMdlMolecule(boolean readMolLine) {
            RinchiInputComponent ric = new RinchiInputComponent();
            this.readMolHeader(readMolLine);
            if (!this.errors.isEmpty()) {
                return null;
            }
            this.readMolCountsLine();
            if (!this.errors.isEmpty()) {
                return null;
            }
            this.readMolCtabBlock(ric);
            if (!this.errors.isEmpty()) {
                return null;
            }
            this.readMolPropertiesBlock(ric);
            if (!this.errors.isEmpty()) {
                return null;
            }
            return ric;
        }

        private Integer readInteger(String line, int startPos, int length) {
            int endPos = startPos + length;
            if (startPos > line.length() || endPos > line.length()) {
                return null;
            }
            String s = line.substring(startPos, endPos).trim();
            try {
                return Integer.parseInt(s);
            }
            catch (Exception x) {
                this.errors.add(this.errorPrefix() + "Error on parsing integer: " + s);
                return null;
            }
        }

        private Double readMdlCoordinate(String line, int startPos) {
            int endPos = startPos + 10;
            if (startPos > line.length() || endPos > line.length()) {
                return null;
            }
            String s = line.substring(startPos, endPos).trim();
            if (line.charAt(startPos + 5) != '.') {
                this.errors.add(this.errorPrefix() + "Incorrect coordinate format: " + s);
                return null;
            }
            try {
                return Double.parseDouble(s);
            }
            catch (Exception x) {
                this.errors.add(this.errorPrefix() + "Error on parsing float: " + s);
                return null;
            }
        }

        private int getChargeFromOldCtabCoding(int code) {
            switch (code) {
                case 1: {
                    return 3;
                }
                case 2: {
                    return 2;
                }
                case 3: {
                    return 1;
                }
                case 5: {
                    return -1;
                }
                case 6: {
                    return -2;
                }
                case 7: {
                    return -3;
                }
            }
            return 0;
        }

        private InchiBondStereo getBondStereoFromMdlCode(int code) {
            switch (code) {
                case 0: {
                    return InchiBondStereo.NONE;
                }
                case 1: {
                    return InchiBondStereo.SINGLE_1UP;
                }
                case 4: {
                    return InchiBondStereo.SINGLE_1EITHER;
                }
                case 6: {
                    return InchiBondStereo.SINGLE_1DOWN;
                }
                case 3: {
                    return InchiBondStereo.DOUBLE_EITHER;
                }
            }
            return null;
        }

        private InchiRadical getInchiRadical(int mdlRadicalCode) {
            switch (mdlRadicalCode) {
                case 1: {
                    return InchiRadical.SINGLET;
                }
                case 2: {
                    return InchiRadical.DOUBLET;
                }
                case 3: {
                    return InchiRadical.TRIPLET;
                }
            }
            return InchiRadical.NONE;
        }

        private String errorPrefix() {
            return "Line " + this.curLineNum + ": ";
        }
    }
}

