/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.shape;

import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import javajs.util.BS;
import javajs.util.P3;
import javajs.util.PT;
import org.jmol.modelset.Text;
import org.jmol.shape.Shape;
import org.jmol.util.C;
import org.jmol.util.Font;
import org.jmol.util.Logger;

public abstract class TextShape
extends Shape {
    public Map<String, Text> objects = new Hashtable<String, Text>();
    Text currentObject;
    Font currentFont;
    Object currentColor;
    Object currentBgColor;
    float currentTranslucentLevel;
    float currentBgTranslucentLevel;
    protected String thisID;
    boolean isHover;
    boolean isAll;

    protected void setPropTS(String propertyName, Object value, BS bsSelected) {
        Iterator<Text> e;
        if ("text" == propertyName) {
            String text = (String)value;
            if (this.currentObject != null) {
                this.currentObject.setText(text);
            } else if (this.isAll) {
                for (Text t : this.objects.values()) {
                    t.setText(text);
                }
            }
            return;
        }
        if ("font" == propertyName) {
            this.currentFont = (Font)value;
            if (this.currentObject != null) {
                this.currentObject.setFont(this.currentFont, true);
                this.currentObject.setFontScale(0.0f);
            } else if (this.isAll) {
                for (Text text : this.objects.values()) {
                    text.setFont(this.currentFont, true);
                }
            }
            return;
        }
        if ("allOff" == propertyName) {
            this.currentObject = null;
            this.isAll = true;
            this.objects = new Hashtable<String, Text>();
            return;
        }
        if ("delete" == propertyName) {
            if (value instanceof Text) {
                this.currentObject = (Text)value;
            }
            if (this.currentObject != null) {
                this.objects.remove(this.currentObject.target);
                this.currentObject = null;
            } else if (this.isAll || this.thisID != null) {
                Iterator<Text> e2 = this.objects.values().iterator();
                while (e2.hasNext()) {
                    Text text = e2.next();
                    if (!this.isAll && !PT.isMatch(text.target.toUpperCase(), this.thisID, true, true)) continue;
                    e2.remove();
                }
            }
            return;
        }
        if ("off" == propertyName) {
            if (this.isAll) {
                this.objects = new Hashtable<String, Text>();
                this.isAll = false;
                this.currentObject = null;
                return;
            }
            if (this.currentObject != null) {
                this.objects.remove(this.currentObject.target);
                this.currentObject = null;
            } else if (this.thisID != null) {
                e = this.objects.values().iterator();
                while (e.hasNext()) {
                    Text text = e.next();
                    if (!this.isAll && !PT.isMatch(text.target.toUpperCase(), this.thisID, true, true)) continue;
                    e.remove();
                }
            }
        }
        if ("model" == propertyName) {
            int modelIndex = (Integer)value;
            if (this.currentObject != null) {
                this.currentObject.modelIndex = modelIndex;
            } else if (this.isAll) {
                for (Text t : this.objects.values()) {
                    t.modelIndex = modelIndex;
                }
            }
            return;
        }
        if ("align" == propertyName) {
            String align = (String)value;
            if (this.currentObject != null) {
                if (!this.currentObject.setAlignmentLCR(align)) {
                    Logger.error("unrecognized align:" + align);
                }
            } else if (this.isAll) {
                for (Text obj : this.objects.values()) {
                    obj.setAlignmentLCR(align);
                }
            }
            return;
        }
        if ("bgcolor" == propertyName) {
            this.currentBgColor = value;
            if (this.currentObject != null) {
                this.currentObject.bgcolix = C.getColixO(value);
            } else if (this.isAll) {
                e = this.objects.values().iterator();
                while (e.hasNext()) {
                    e.next().bgcolix = C.getColixO(value);
                }
            }
            return;
        }
        if ("color" == propertyName) {
            this.currentColor = value;
            if (this.currentObject != null) {
                this.currentObject.colix = C.getColixO(value);
            } else if (this.isAll || this.thisID != null) {
                for (Text text : this.objects.values()) {
                    if (!this.isAll && !PT.isMatch(text.target.toUpperCase(), this.thisID, true, true)) continue;
                    text.colix = C.getColixO(value);
                }
            }
            return;
        }
        if ("target" == propertyName) {
            String target = (String)value;
            this.isAll = target.equals("all");
            if (this.isAll || target.equals("none")) {
                this.currentObject = null;
            }
            return;
        }
        boolean isBackground = "bgtranslucency" == propertyName;
        if (isBackground || "translucency" == propertyName) {
            boolean bl;
            boolean bl2 = bl = "translucent" == value;
            if (isBackground) {
                this.currentBgTranslucentLevel = bl ? this.translucentLevel : 0.0f;
            } else {
                float f = this.currentTranslucentLevel = bl ? this.translucentLevel : 0.0f;
            }
            if (this.currentObject != null) {
                this.currentObject.setTranslucent(this.translucentLevel, isBackground);
            } else if (this.isAll) {
                Iterator<Text> e3 = this.objects.values().iterator();
                while (e3.hasNext()) {
                    e3.next().setTranslucent(this.translucentLevel, isBackground);
                }
            }
            return;
        }
        if (propertyName == "deleteModelAtoms") {
            int n = ((int[])((Object[])value)[2])[0];
            Iterator<Text> e4 = this.objects.values().iterator();
            while (e4.hasNext()) {
                Text text = e4.next();
                if (text.modelIndex == n) {
                    e4.remove();
                    continue;
                }
                if (text.modelIndex <= n) continue;
                --text.modelIndex;
            }
            return;
        }
        this.setPropS(propertyName, value, bsSelected);
    }

    @Override
    public String getShapeState() {
        return null;
    }

    @Override
    protected void initModelSet() {
        this.currentObject = null;
        this.isAll = false;
    }

    @Override
    public void setModelVisibilityFlags(BS bsModels) {
        if (!this.isHover) {
            for (Text t : this.objects.values()) {
                t.visible = t.modelIndex < 0 || bsModels.get(t.modelIndex) && (!t.thisModelOnly || bsModels.cardinality() == 1 && t.modelIndex == this.vwr.am.cmi);
            }
        }
    }

    @Override
    public Map<String, Object> checkObjectClicked(int x, int y, int modifiers, BS bsVisible, boolean drawPicking) {
        if (this.isHover || modifiers == 0) {
            return null;
        }
        boolean isAntialiased = this.vwr.antialiased;
        for (Text obj : this.objects.values()) {
            if (!obj.checkObjectClicked(isAntialiased, x, y, bsVisible)) continue;
            if (obj.script != null) {
                this.vwr.evalStringQuiet(obj.script);
            }
            Hashtable<String, Object> map = new Hashtable<String, Object>();
            map.put("pt", obj.xyz == null ? new P3() : obj.xyz);
            int modelIndex = obj.modelIndex;
            if (modelIndex < 0) {
                modelIndex = 0;
            }
            map.put("modelIndex", modelIndex);
            map.put("model", this.vwr.getModelNumberDotted(modelIndex));
            map.put("id", obj.target);
            map.put("type", "echo");
            return map;
        }
        return null;
    }

    @Override
    public boolean checkObjectHovered(int x, int y, BS bsVisible) {
        if (this.isHover) {
            return false;
        }
        boolean haveScripts = false;
        boolean isAntialiased = this.vwr.antialiased;
        for (Text obj : this.objects.values()) {
            if (obj.script == null) continue;
            haveScripts = true;
            if (!obj.checkObjectClicked(isAntialiased, x, y, bsVisible)) continue;
            this.vwr.setCursor(12);
            return true;
        }
        if (haveScripts) {
            this.vwr.setCursor(0);
        }
        return false;
    }
}

