/* ----------------------------------------------------------------------------
 * This file was automatically generated by SWIG (https://www.swig.org).
 * Version 4.3.0
 *
 * Do not make changes to this file unless you know what you are doing - modify
 * the SWIG interface file instead.
 * ----------------------------------------------------------------------------- */

package org.itk.simple;
/**

Set image values to a user-specified value if they are below, above,
or outside threshold values.


ThresholdImageFilter sets image values to a user-specified "outside" value (by default,
zero) if the image values are below, above, or outside threshold
values.

The available methods are:

ThresholdAbove() : The values greater than the threshold value are set to OutsideValue

ThresholdBelow() : The values less than the threshold value are set to OutsideValue

ThresholdOutside() : The values outside the threshold range (less than lower or greater
than upper) are set to OutsideValue

Note that these definitions indicate that pixels equal to the
threshold value are not set to OutsideValue in any of these methods

The pixels must support the operators &gt;= and &lt;=.
See:
 itk::simple::Threshold for the procedural interface

 itk::ThresholdImageFilter for the Doxygen on the original ITK class.


C++ includes: sitkThresholdImageFilter.h
*/
public class ThresholdImageFilter extends ImageFilter {
  private transient long swigCPtr;

  protected ThresholdImageFilter(long cPtr, boolean cMemoryOwn) {
    super(SimpleITKJNI.ThresholdImageFilter_SWIGUpcast(cPtr), cMemoryOwn);
    swigCPtr = cPtr;
  }

  protected static long getCPtr(ThresholdImageFilter obj) {
    return (obj == null) ? 0 : obj.swigCPtr;
  }

  protected static long swigRelease(ThresholdImageFilter obj) {
    long ptr = 0;
    if (obj != null) {
      if (!obj.swigCMemOwn)
        throw new RuntimeException("Cannot release ownership as memory is not owned");
      ptr = obj.swigCPtr;
      obj.swigCMemOwn = false;
      obj.delete();
    }
    return ptr;
  }

  @SuppressWarnings({"deprecation", "removal"})
  protected void finalize() {
    delete();
  }

  /**
virtual itk::simple::ThresholdImageFilter::~ThresholdImageFilter()

Destructor

*/
public  void delete() {
    if (swigCPtr != 0) {
      if (swigCMemOwn) {
        swigCMemOwn = false;
        SimpleITKJNI.delete_ThresholdImageFilter(swigCPtr);
      }
      swigCPtr = 0;
    }
    super.delete();
  }

  /**
itk::simple::ThresholdImageFilter::ThresholdImageFilter()

Default Constructor that takes no arguments and initializes default
parameters

*/
public  ThresholdImageFilter() {
    this(SimpleITKJNI.new_ThresholdImageFilter(), true);
  }

  /**
Self&amp; itk::simple::ThresholdImageFilter::SetLower(double Lower)

Set/Get methods to set the lower threshold.

*/
public  void setLower(double Lower) {
    SimpleITKJNI.ThresholdImageFilter_setLower(swigCPtr, this, Lower);
  }

  /**
double itk::simple::ThresholdImageFilter::GetLower() const

Set/Get methods to set the lower threshold.

*/
public  double getLower() {
    return SimpleITKJNI.ThresholdImageFilter_getLower(swigCPtr, this);
  }

  /**
Self&amp; itk::simple::ThresholdImageFilter::SetUpper(double Upper)

Set/Get methods to set the upper threshold.

*/
public  void setUpper(double Upper) {
    SimpleITKJNI.ThresholdImageFilter_setUpper(swigCPtr, this, Upper);
  }

  /**
double itk::simple::ThresholdImageFilter::GetUpper() const

Set/Get methods to set the upper threshold.

*/
public  double getUpper() {
    return SimpleITKJNI.ThresholdImageFilter_getUpper(swigCPtr, this);
  }

  /**
Self&amp; itk::simple::ThresholdImageFilter::SetOutsideValue(double OutsideValue)

The pixel type must support comparison operators. Set the "outside"
pixel value. The default value NumericTraits&lt;PixelType&gt;::ZeroValue() .

*/
public  void setOutsideValue(double OutsideValue) {
    SimpleITKJNI.ThresholdImageFilter_setOutsideValue(swigCPtr, this, OutsideValue);
  }

  /**
double itk::simple::ThresholdImageFilter::GetOutsideValue() const

Get the "outside" pixel value.

*/
public  double getOutsideValue() {
    return SimpleITKJNI.ThresholdImageFilter_getOutsideValue(swigCPtr, this);
  }

  /**
std::string itk::simple::ThresholdImageFilter::GetName() const

Name of this class

*/
public  String getName() {
    return SimpleITKJNI.ThresholdImageFilter_getName(swigCPtr, this);
  }

  /**
std::string itk::simple::ThresholdImageFilter::ToString() const

Print ourselves out

*/
public  String toString() {
    return SimpleITKJNI.ThresholdImageFilter_toString(swigCPtr, this);
  }

  /**
Image itk::simple::ThresholdImageFilter::Execute(Image &amp;&amp;image1)

Execute the filter on the input image

*/
public  Image execute(Image image1) {
    return new Image(SimpleITKJNI.ThresholdImageFilter_execute(swigCPtr, this, Image.getCPtr(image1), image1), true);
  }

  /**
void itk::simple::ThresholdImageFilter::ThresholdAbove(double threshold)
*/
public  void thresholdAbove(double threshold) {
    SimpleITKJNI.ThresholdImageFilter_thresholdAbove(swigCPtr, this, threshold);
  }

  /**
void itk::simple::ThresholdImageFilter::ThresholdBelow(double threshold)
*/
public  void thresholdBelow(double threshold) {
    SimpleITKJNI.ThresholdImageFilter_thresholdBelow(swigCPtr, this, threshold);
  }

  /**
void itk::simple::ThresholdImageFilter::ThresholdOutside(double lower, double upper)
*/
public  void thresholdOutside(double lower, double upper) {
    SimpleITKJNI.ThresholdImageFilter_thresholdOutside(swigCPtr, this, lower, upper);
  }

}
