/* ----------------------------------------------------------------------------
 * This file was automatically generated by SWIG (https://www.swig.org).
 * Version 4.3.0
 *
 * Do not make changes to this file unless you know what you are doing - modify
 * the SWIG interface file instead.
 * ----------------------------------------------------------------------------- */

package org.itk.simple;
/**

Resample an image via a coordinate transform.


ResampleImageFilter resamples an existing image through some coordinate transform,
interpolating via some image function. The class is templated over the
types of the input and output images.

Note that the choice of interpolator function can be important. This
function is set via SetInterpolator() . The default is LinearInterpolateImageFunction &lt;InputImageType, TInterpolatorPrecisionType&gt;, which is
reasonable for ordinary medical images. However, some synthetic images
have pixels drawn from a finite prescribed set. An example would be a
mask indicating the segmentation of a brain into a small number of
tissue types. For such an image, one does not want to interpolate
between different pixel values, and so NearestNeighborInterpolateImageFunction &lt; InputImageType, TCoordRep &gt; would be a better choice.

If an sample is taken from outside the image domain, the default
behavior is to use a default pixel value. If different behavior is
desired, an extrapolator function can be set with SetExtrapolator() .

Output information (spacing, size and direction) for the output image
should be set. This information has the normal defaults of unit
spacing, zero origin and identity direction. Optionally, the output
information can be obtained from a reference image. If the reference
image is provided and UseReferenceImage is On, then the spacing,
origin and direction of the reference image will be used.

Since this filter produces an image which is a different size than its
input, it needs to override several of the methods defined in ProcessObject in order to properly manage the pipeline execution model. In
particular, this filter overrides ProcessObject::GenerateInputRequestedRegion() and ProcessObject::GenerateOutputInformation() .

This filter is implemented as a multithreaded filter. It provides a
DynamicThreadedGenerateData() method for its implementation.
WARNING:
For multithreading, the TransformPoint method of the user-designated
coordinate transform must be threadsafe.

See:
 itk::ResampleImageFilter for the Doxygen on the original ITK class.


C++ includes: sitkResampleImageFilter.h
*/
public class ResampleImageFilter extends ImageFilter {
  private transient long swigCPtr;

  protected ResampleImageFilter(long cPtr, boolean cMemoryOwn) {
    super(SimpleITKJNI.ResampleImageFilter_SWIGUpcast(cPtr), cMemoryOwn);
    swigCPtr = cPtr;
  }

  protected static long getCPtr(ResampleImageFilter obj) {
    return (obj == null) ? 0 : obj.swigCPtr;
  }

  protected static long swigRelease(ResampleImageFilter obj) {
    long ptr = 0;
    if (obj != null) {
      if (!obj.swigCMemOwn)
        throw new RuntimeException("Cannot release ownership as memory is not owned");
      ptr = obj.swigCPtr;
      obj.swigCMemOwn = false;
      obj.delete();
    }
    return ptr;
  }

  @SuppressWarnings({"deprecation", "removal"})
  protected void finalize() {
    delete();
  }

  /**
virtual itk::simple::ResampleImageFilter::~ResampleImageFilter()

Destructor

*/
public  void delete() {
    if (swigCPtr != 0) {
      if (swigCMemOwn) {
        swigCMemOwn = false;
        SimpleITKJNI.delete_ResampleImageFilter(swigCPtr);
      }
      swigCPtr = 0;
    }
    super.delete();
  }

  /**
itk::simple::ResampleImageFilter::ResampleImageFilter()

Default Constructor that takes no arguments and initializes default
parameters

*/
public  ResampleImageFilter() {
    this(SimpleITKJNI.new_ResampleImageFilter(), true);
  }

  /**
Self&amp; itk::simple::ResampleImageFilter::SetSize(std::vector&lt; uint32_t &gt; Size)

Get/Set the size of the output image.

*/
public  void setSize(VectorUInt32 Size) {
    SimpleITKJNI.ResampleImageFilter_setSize(swigCPtr, this, VectorUInt32.getCPtr(Size), Size);
  }

  /**
std::vector&lt;uint32_t&gt; itk::simple::ResampleImageFilter::GetSize() const

Get/Set the size of the output image.

*/
public  VectorUInt32 getSize() {
    return new VectorUInt32(SimpleITKJNI.ResampleImageFilter_getSize(swigCPtr, this), true);
  }

  /**
Self&amp; itk::simple::ResampleImageFilter::SetTransform(Transform Transform)
*/
public  void setTransform(Transform Transform) {
    SimpleITKJNI.ResampleImageFilter_setTransform(swigCPtr, this, Transform.getCPtr(Transform), Transform);
  }

  /**
Transform itk::simple::ResampleImageFilter::GetTransform() const
*/
public  Transform getTransform() {
    return new Transform(SimpleITKJNI.ResampleImageFilter_getTransform(swigCPtr, this), true);
  }

  /**
Self&amp; itk::simple::ResampleImageFilter::SetInterpolator(InterpolatorEnum Interpolator)

Get/Set the interpolator function. The default is LinearInterpolateImageFunction &lt;InputImageType, TInterpolatorPrecisionType&gt;. Some other
options are NearestNeighborInterpolateImageFunction (useful for binary masks and other images with a small number of
possible pixel values), and BSplineInterpolateImageFunction (which provides a higher order of interpolation).

*/
public  void setInterpolator(InterpolatorEnum Interpolator) {
    SimpleITKJNI.ResampleImageFilter_setInterpolator(swigCPtr, this, Interpolator.swigValue());
  }

  /**
InterpolatorEnum itk::simple::ResampleImageFilter::GetInterpolator() const

Get/Set the interpolator function. The default is LinearInterpolateImageFunction &lt;InputImageType, TInterpolatorPrecisionType&gt;. Some other
options are NearestNeighborInterpolateImageFunction (useful for binary masks and other images with a small number of
possible pixel values), and BSplineInterpolateImageFunction (which provides a higher order of interpolation).

*/
public  InterpolatorEnum getInterpolator() {
    return InterpolatorEnum.swigToEnum(SimpleITKJNI.ResampleImageFilter_getInterpolator(swigCPtr, this));
  }

  /**
Self&amp; itk::simple::ResampleImageFilter::SetOutputOrigin(std::vector&lt; double &gt; OutputOrigin)

Set the output image origin.

*/
public  void setOutputOrigin(VectorDouble OutputOrigin) {
    SimpleITKJNI.ResampleImageFilter_setOutputOrigin(swigCPtr, this, VectorDouble.getCPtr(OutputOrigin), OutputOrigin);
  }

  /**
std::vector&lt;double&gt; itk::simple::ResampleImageFilter::GetOutputOrigin() const

Get the output image origin.

*/
public  VectorDouble getOutputOrigin() {
    return new VectorDouble(SimpleITKJNI.ResampleImageFilter_getOutputOrigin(swigCPtr, this), true);
  }

  /**
Self&amp; itk::simple::ResampleImageFilter::SetOutputSpacing(std::vector&lt; double &gt; OutputSpacing)

Set the output image spacing.

*/
public  void setOutputSpacing(VectorDouble OutputSpacing) {
    SimpleITKJNI.ResampleImageFilter_setOutputSpacing(swigCPtr, this, VectorDouble.getCPtr(OutputSpacing), OutputSpacing);
  }

  /**
std::vector&lt;double&gt; itk::simple::ResampleImageFilter::GetOutputSpacing() const

Get the output image spacing.

*/
public  VectorDouble getOutputSpacing() {
    return new VectorDouble(SimpleITKJNI.ResampleImageFilter_getOutputSpacing(swigCPtr, this), true);
  }

  /**
Self&amp; itk::simple::ResampleImageFilter::SetOutputDirection(std::vector&lt; double &gt; OutputDirection)

Set the output direction cosine matrix.

*/
public  void setOutputDirection(VectorDouble OutputDirection) {
    SimpleITKJNI.ResampleImageFilter_setOutputDirection(swigCPtr, this, VectorDouble.getCPtr(OutputDirection), OutputDirection);
  }

  /**
std::vector&lt;double&gt; itk::simple::ResampleImageFilter::GetOutputDirection() const

Set the output direction cosine matrix.

*/
public  VectorDouble getOutputDirection() {
    return new VectorDouble(SimpleITKJNI.ResampleImageFilter_getOutputDirection(swigCPtr, this), true);
  }

  /**
Self&amp; itk::simple::ResampleImageFilter::SetDefaultPixelValue(double DefaultPixelValue)

Get/Set the pixel value when a transformed pixel is outside of the
image. The default default pixel value is 0.

*/
public  void setDefaultPixelValue(double DefaultPixelValue) {
    SimpleITKJNI.ResampleImageFilter_setDefaultPixelValue(swigCPtr, this, DefaultPixelValue);
  }

  /**
double itk::simple::ResampleImageFilter::GetDefaultPixelValue() const

Get/Set the pixel value when a transformed pixel is outside of the
image. The default default pixel value is 0.

*/
public  double getDefaultPixelValue() {
    return SimpleITKJNI.ResampleImageFilter_getDefaultPixelValue(swigCPtr, this);
  }

  /**
Self&amp; itk::simple::ResampleImageFilter::SetOutputPixelType(PixelIDValueEnum OutputPixelType)

Set the output pixel type, if sitkUnknown then the input type is used.

*/
public  void setOutputPixelType(PixelIDValueEnum OutputPixelType) {
    SimpleITKJNI.ResampleImageFilter_setOutputPixelType(swigCPtr, this, OutputPixelType.swigValue());
  }

  /**
PixelIDValueEnum itk::simple::ResampleImageFilter::GetOutputPixelType() const

Get the ouput pixel type.

*/
public  PixelIDValueEnum getOutputPixelType() {
    return PixelIDValueEnum.swigToEnum(SimpleITKJNI.ResampleImageFilter_getOutputPixelType(swigCPtr, this));
  }

  /**
Self&amp; itk::simple::ResampleImageFilter::SetUseNearestNeighborExtrapolator(bool UseNearestNeighborExtrapolator)

Enables the nearest neighbor extrapolator as opposed to the constant
pixel value.

*/
public  void setUseNearestNeighborExtrapolator(boolean UseNearestNeighborExtrapolator) {
    SimpleITKJNI.ResampleImageFilter_setUseNearestNeighborExtrapolator(swigCPtr, this, UseNearestNeighborExtrapolator);
  }

  /**
Self&amp; itk::simple::ResampleImageFilter::UseNearestNeighborExtrapolatorOn()

Set the value of UseNearestNeighborExtrapolator to true or false
respectfully.

*/
public  void useNearestNeighborExtrapolatorOn() {
    SimpleITKJNI.ResampleImageFilter_useNearestNeighborExtrapolatorOn(swigCPtr, this);
  }

  /**
Self&amp; itk::simple::ResampleImageFilter::UseNearestNeighborExtrapolatorOff()
*/
public  void useNearestNeighborExtrapolatorOff() {
    SimpleITKJNI.ResampleImageFilter_useNearestNeighborExtrapolatorOff(swigCPtr, this);
  }

  /**
bool itk::simple::ResampleImageFilter::GetUseNearestNeighborExtrapolator() const
*/
public  boolean getUseNearestNeighborExtrapolator() {
    return SimpleITKJNI.ResampleImageFilter_getUseNearestNeighborExtrapolator(swigCPtr, this);
  }

  /**
std::string itk::simple::ResampleImageFilter::GetName() const

Name of this class

*/
public  String getName() {
    return SimpleITKJNI.ResampleImageFilter_getName(swigCPtr, this);
  }

  /**
std::string itk::simple::ResampleImageFilter::ToString() const

Print ourselves out

*/
public  String toString() {
    return SimpleITKJNI.ResampleImageFilter_toString(swigCPtr, this);
  }

  /**
Image itk::simple::ResampleImageFilter::Execute(const Image &amp;image1)

Execute the filter on the input image

*/
public  Image execute(Image image1) {
    return new Image(SimpleITKJNI.ResampleImageFilter_execute(swigCPtr, this, Image.getCPtr(image1), image1), true);
  }

  /**
void itk::simple::ResampleImageFilter::SetReferenceImage(const Image &amp;refImage)

This methods sets the output size, origin, spacing and direction to
that of the provided image

*/
public  void setReferenceImage(Image refImage) {
    SimpleITKJNI.ResampleImageFilter_setReferenceImage(swigCPtr, this, Image.getCPtr(refImage), refImage);
  }

}
