/* ----------------------------------------------------------------------------
 * This file was automatically generated by SWIG (https://www.swig.org).
 * Version 4.3.0
 *
 * Do not make changes to this file unless you know what you are doing - modify
 * the SWIG interface file instead.
 * ----------------------------------------------------------------------------- */

package org.itk.simple;
/**

Read series of image files into a SimpleITK image.


For some image formats such as DICOM, images also contain associated
meta-data (e.g. imaging modality, patient name etc.). By default the
reader does not load this information (saves time). To load the meta-
data you will need to explicitly configure the reader,
MetaDataDictionaryArrayUpdateOn, and possibly specify that you also
want to load the private meta-data LoadPrivateTagsOn.

Once the image series is read the meta-data is directly accessible
from the reader.


DICOM tags are represented as strings in the meta-data dictionary(s),
therefore "0020|000D" and "0020|000d" are different when accessing
the tag value. This differs from the hexadecimal numbers they
represent, 0020|000D and 0020|000d are equivalent. The ITK meta-data
dictionary is string based and uses lower case to represent the
hexadecimal number read from disk, so 0020|000d will work as a key and
0020|000D will not be found in the dictionary (results in an exception
if attempting to access). It is recommended to use lower case when
setting and accessing DICOM tags.

If the pixel type for the returned image is not specified it is
deduced from the first image in the series. This approach is
computationally efficient and assumes that all images in a series have
the same pixel type. In rare situations this is not the case, not all
images have the same pixel type. If this leads to a narrowing
conversion (e.g. first image pixel type is unsigned int and others are
float) the returned image does not represent the data correctly. To
resolve such situations, explicitly specify the expected pixel type
via the SetOutputPixelType method before reading the series.

See:
 itk::simple::ReadImage for the procedural interface


C++ includes: sitkImageSeriesReader.h
*/
public class ImageSeriesReader extends ImageReaderBase {
  private transient long swigCPtr;

  protected ImageSeriesReader(long cPtr, boolean cMemoryOwn) {
    super(SimpleITKJNI.ImageSeriesReader_SWIGUpcast(cPtr), cMemoryOwn);
    swigCPtr = cPtr;
  }

  protected static long getCPtr(ImageSeriesReader obj) {
    return (obj == null) ? 0 : obj.swigCPtr;
  }

  protected static long swigRelease(ImageSeriesReader obj) {
    long ptr = 0;
    if (obj != null) {
      if (!obj.swigCMemOwn)
        throw new RuntimeException("Cannot release ownership as memory is not owned");
      ptr = obj.swigCPtr;
      obj.swigCMemOwn = false;
      obj.delete();
    }
    return ptr;
  }

  @SuppressWarnings({"deprecation", "removal"})
  protected void finalize() {
    delete();
  }

  /**
itk::simple::ImageSeriesReader::~ImageSeriesReader() override
*/
public  void delete() {
    if (swigCPtr != 0) {
      if (swigCMemOwn) {
        swigCMemOwn = false;
        SimpleITKJNI.delete_ImageSeriesReader(swigCPtr);
      }
      swigCPtr = 0;
    }
    super.delete();
  }

  /**
itk::simple::ImageSeriesReader::ImageSeriesReader()
*/
public  ImageSeriesReader() {
    this(SimpleITKJNI.new_ImageSeriesReader(), true);
  }

  /**
std::string itk::simple::ImageSeriesReader::ToString() const override

Print ourselves to string

*/
public  String toString() {
    return SimpleITKJNI.ImageSeriesReader_toString(swigCPtr, this);
  }

  /**
std::string itk::simple::ImageSeriesReader::GetName() const override

return user readable name of the filter

*/
public  String getName() {
    return SimpleITKJNI.ImageSeriesReader_getName(swigCPtr, this);
  }

  /**
Self&amp; itk::simple::ImageSeriesReader::SetMetaDataDictionaryArrayUpdate(bool metaDataDictionaryArrayUpdate)

Set/Get whether the meta-data dictionaries for the slices should be
read. Default value is false, because of the additional computation
time.

*/
public  void setMetaDataDictionaryArrayUpdate(boolean metaDataDictionaryArrayUpdate) {
    SimpleITKJNI.ImageSeriesReader_setMetaDataDictionaryArrayUpdate(swigCPtr, this, metaDataDictionaryArrayUpdate);
  }

  /**
bool itk::simple::ImageSeriesReader::GetMetaDataDictionaryArrayUpdate()
*/
public  boolean getMetaDataDictionaryArrayUpdate() {
    return SimpleITKJNI.ImageSeriesReader_getMetaDataDictionaryArrayUpdate(swigCPtr, this);
  }

  /**
Self&amp; itk::simple::ImageSeriesReader::MetaDataDictionaryArrayUpdateOn()

Set the value of MetaDataDictionaryArrayUpdate to true or false
respectively.

*/
public  void metaDataDictionaryArrayUpdateOn() {
    SimpleITKJNI.ImageSeriesReader_metaDataDictionaryArrayUpdateOn(swigCPtr, this);
  }

  /**
Self&amp; itk::simple::ImageSeriesReader::MetaDataDictionaryArrayUpdateOff()
*/
public  void metaDataDictionaryArrayUpdateOff() {
    SimpleITKJNI.ImageSeriesReader_metaDataDictionaryArrayUpdateOff(swigCPtr, this);
  }

  public static VectorString getGDCMSeriesFileNames(String directory, String seriesID, boolean useSeriesDetails, boolean recursive, boolean loadSequences) {
    return new VectorString(SimpleITKJNI.ImageSeriesReader_getGDCMSeriesFileNames__SWIG_0(directory, seriesID, useSeriesDetails, recursive, loadSequences), true);
  }

  public static VectorString getGDCMSeriesFileNames(String directory, String seriesID, boolean useSeriesDetails, boolean recursive) {
    return new VectorString(SimpleITKJNI.ImageSeriesReader_getGDCMSeriesFileNames__SWIG_1(directory, seriesID, useSeriesDetails, recursive), true);
  }

  public static VectorString getGDCMSeriesFileNames(String directory, String seriesID, boolean useSeriesDetails) {
    return new VectorString(SimpleITKJNI.ImageSeriesReader_getGDCMSeriesFileNames__SWIG_2(directory, seriesID, useSeriesDetails), true);
  }

  public static VectorString getGDCMSeriesFileNames(String directory, String seriesID) {
    return new VectorString(SimpleITKJNI.ImageSeriesReader_getGDCMSeriesFileNames__SWIG_3(directory, seriesID), true);
  }

  public static VectorString getGDCMSeriesFileNames(String directory) {
    return new VectorString(SimpleITKJNI.ImageSeriesReader_getGDCMSeriesFileNames__SWIG_4(directory), true);
  }

  public static VectorString getGDCMSeriesIDs(String directory, boolean useSeriesDetails) {
    return new VectorString(SimpleITKJNI.ImageSeriesReader_getGDCMSeriesIDs__SWIG_0(directory, useSeriesDetails), true);
  }

  public static VectorString getGDCMSeriesIDs(String directory) {
    return new VectorString(SimpleITKJNI.ImageSeriesReader_getGDCMSeriesIDs__SWIG_1(directory), true);
  }

  /**
Self&amp; itk::simple::ImageSeriesReader::SetFileNames(const std::vector&lt; PathType &gt; &amp;fileNames)
*/
public  void setFileNames(VectorString fileNames) {
    SimpleITKJNI.ImageSeriesReader_setFileNames(swigCPtr, this, VectorString.getCPtr(fileNames), fileNames);
  }

  /**
const std::vector&lt;PathType&gt;&amp; itk::simple::ImageSeriesReader::GetFileNames() const
*/
public  VectorString getFileNames() {
    return new VectorString(SimpleITKJNI.ImageSeriesReader_getFileNames(swigCPtr, this), false);
  }

  /**
Self&amp; itk::simple::ImageSeriesReader::SetSpacingWarningRelThreshold(double spacingWarningRelThreshold)

Set the relative threshold for issuing warnings about non-uniform
sampling.

*/
public  void setSpacingWarningRelThreshold(double spacingWarningRelThreshold) {
    SimpleITKJNI.ImageSeriesReader_setSpacingWarningRelThreshold(swigCPtr, this, spacingWarningRelThreshold);
  }

  /**
double itk::simple::ImageSeriesReader::GetSpacingWarningRelThreshold() const
*/
public  double getSpacingWarningRelThreshold() {
    return SimpleITKJNI.ImageSeriesReader_getSpacingWarningRelThreshold(swigCPtr, this);
  }

  public void setForceOrthogonalDirection(boolean forceOrthogonalDirection) {
    SimpleITKJNI.ImageSeriesReader_setForceOrthogonalDirection(swigCPtr, this, forceOrthogonalDirection);
  }

  public boolean getForceOrthogonalDirection() {
    return SimpleITKJNI.ImageSeriesReader_getForceOrthogonalDirection(swigCPtr, this);
  }

  public void forceOrthogonalDirectionOn() {
    SimpleITKJNI.ImageSeriesReader_forceOrthogonalDirectionOn(swigCPtr, this);
  }

  public void forceOrthogonalDirectionOff() {
    SimpleITKJNI.ImageSeriesReader_forceOrthogonalDirectionOff(swigCPtr, this);
  }

  public void setReverseOrder(boolean reverseOrder) {
    SimpleITKJNI.ImageSeriesReader_setReverseOrder(swigCPtr, this, reverseOrder);
  }

  public boolean getReverseOrder() {
    return SimpleITKJNI.ImageSeriesReader_getReverseOrder(swigCPtr, this);
  }

  public void reverseOrderOn() {
    SimpleITKJNI.ImageSeriesReader_reverseOrderOn(swigCPtr, this);
  }

  public void reverseOrderOff() {
    SimpleITKJNI.ImageSeriesReader_reverseOrderOff(swigCPtr, this);
  }

  /**
Image itk::simple::ImageSeriesReader::Execute() override

Set/Get The output PixelType of the image.


By default the value is sitkUnknown, which enable the output pixel
type to be same as the file. If the pixel type is specified then the itk::ConvertPixelBuffer will be used to convert the pixels.

*/
public  Image execute() {
    return new Image(SimpleITKJNI.ImageSeriesReader_execute(swigCPtr, this), true);
  }

  /**
std::vector&lt;std::string&gt; itk::simple::ImageSeriesReader::GetMetaDataKeys(unsigned int slice) const

Get the meta-data dictionary keys for a slice.


This is only valid after successful execution of this filter and when
MetaDataDictionaryArrayUpdate is true. Each element in the array
corresponds to a "slice" or filename read during execution.

If the slice index is out of range, an exception will be thrown.

Returns a vector of keys to the key/value entries in the file's meta-
data dictionary. Iterate through with these keys to get the values.

*/
public  VectorString getMetaDataKeys(long slice) {
    return new VectorString(SimpleITKJNI.ImageSeriesReader_getMetaDataKeys(swigCPtr, this, slice), true);
  }

  /**
bool itk::simple::ImageSeriesReader::HasMetaDataKey(unsigned int slice, const std::string &amp;key) const

Query a meta-data dictionary for the existence of a key.

*/
public  boolean hasMetaDataKey(long slice, String key) {
    return SimpleITKJNI.ImageSeriesReader_hasMetaDataKey(swigCPtr, this, slice, key);
  }

  /**
std::string itk::simple::ImageSeriesReader::GetMetaData(unsigned int slice, const std::string &amp;key) const

Get the value of a meta-data dictionary entry as a string.


If the key is not in the dictionary then an exception is thrown.

string types in the dictionary are returned as their native string.
Other types are printed to string before returning.

*/
public  String getMetaData(long slice, String key) {
    return SimpleITKJNI.ImageSeriesReader_getMetaData(swigCPtr, this, slice, key);
  }

}
