/*
 * Decompiled with CFR 0.152.
 */
package tim.prune.function;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import tim.prune.App;
import tim.prune.GenericFunction;
import tim.prune.I18nManager;
import tim.prune.cmd.InsertPointCmd;
import tim.prune.data.Altitude;
import tim.prune.data.Coordinate;
import tim.prune.data.DataPoint;
import tim.prune.data.Latitude;
import tim.prune.data.Longitude;
import tim.prune.data.Unit;
import tim.prune.data.UnitSetLibrary;
import tim.prune.gui.GuiGridLayout;

public class PasteCoordinates
extends GenericFunction {
    private JDialog _dialog = null;
    private JTextField _nameField = null;
    private JTextField _coordField = null;
    private JButton _okButton = null;
    private JComboBox<String> _altUnitsDropDown;

    public PasteCoordinates(App app) {
        super(app);
    }

    @Override
    public String getNameKey() {
        return "function.pastecoordinates";
    }

    @Override
    public void begin() {
        if (this._dialog == null) {
            this._dialog = new JDialog(this._parentFrame, this.getName(), true);
            this._dialog.setLocationRelativeTo(this._parentFrame);
            this._dialog.setDefaultCloseOperation(2);
            this._dialog.getContentPane().add(this.makeDialogComponents());
            this._dialog.pack();
        }
        this._coordField.setText("");
        this._nameField.setText("");
        boolean bl = this.getConfig().getUnitSet().getAltitudeUnit() == UnitSetLibrary.UNITS_METRES;
        this._altUnitsDropDown.setSelectedIndex(bl ? 0 : 1);
        this.enableOK();
        this._dialog.setVisible(true);
    }

    private Component makeDialogComponents() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout(0, 10));
        jPanel.add((Component)new JLabel(I18nManager.getText("dialog.pastecoordinates.desc")), "North");
        JPanel jPanel2 = new JPanel();
        GuiGridLayout guiGridLayout = new GuiGridLayout(jPanel2);
        this._coordField = new JTextField("", 25);
        KeyAdapter keyAdapter = new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent keyEvent) {
                PasteCoordinates.this.enableOK();
                if (keyEvent.getKeyCode() == 27) {
                    PasteCoordinates.this._dialog.dispose();
                }
            }
        };
        MouseAdapter mouseAdapter = new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent mouseEvent) {
                PasteCoordinates.this.enableOK();
            }
        };
        this._coordField.addKeyListener(keyAdapter);
        this._coordField.addMouseListener(mouseAdapter);
        JLabel jLabel = new JLabel(I18nManager.getText("dialog.pastecoordinates.coords"));
        jLabel.setHorizontalAlignment(4);
        guiGridLayout.add(jLabel);
        guiGridLayout.add(this._coordField);
        JLabel jLabel2 = new JLabel(I18nManager.getText("dialog.openoptions.altitudeunits"));
        jLabel2.setHorizontalAlignment(4);
        guiGridLayout.add(jLabel2);
        String[] stringArray = new String[]{I18nManager.getText("units.metres"), I18nManager.getText("units.feet")};
        this._altUnitsDropDown = new JComboBox<String>(stringArray);
        guiGridLayout.add(this._altUnitsDropDown);
        JLabel jLabel3 = new JLabel(I18nManager.getText("dialog.pointnameedit.name"));
        jLabel3.setHorizontalAlignment(4);
        guiGridLayout.add(jLabel3);
        this._nameField = new JTextField("", 12);
        guiGridLayout.add(this._nameField);
        jPanel.add((Component)jPanel2, "Center");
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout(new FlowLayout(2));
        this._okButton = new JButton(I18nManager.getText("button.ok"));
        ActionListener actionListener = actionEvent -> {
            if (this._okButton.isEnabled()) {
                this.finish();
            }
        };
        this._okButton.addActionListener(actionListener);
        this._okButton.setEnabled(false);
        this._coordField.addActionListener(actionListener);
        this._nameField.addActionListener(actionListener);
        jPanel3.add(this._okButton);
        JButton jButton = new JButton(I18nManager.getText("button.cancel"));
        jButton.addActionListener(actionEvent -> this._dialog.dispose());
        jPanel3.add(jButton);
        jPanel.add((Component)jPanel3, "South");
        jPanel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 15));
        return jPanel;
    }

    private void enableOK() {
        String string = this._coordField.getText();
        this._okButton.setEnabled(string != null && string.length() > 6 && (string.indexOf(32) > 0 || string.indexOf(44) > 0 || string.indexOf(59) > 0));
    }

    private void finish() {
        Unit unit = this._altUnitsDropDown.getSelectedIndex() == 0 ? UnitSetLibrary.UNITS_METRES : UnitSetLibrary.UNITS_FEET;
        DataPoint dataPoint = PasteCoordinates.makePoint(this._coordField.getText().trim(), unit);
        if (dataPoint == null) {
            JOptionPane.showMessageDialog(this._parentFrame, I18nManager.getText("dialog.pastecoordinates.nothingfound"), this.getName(), 0);
        } else {
            String string = this._nameField.getText();
            if (string != null && string.length() > 0) {
                dataPoint.setWaypointName(string);
            } else {
                dataPoint.setSegmentStart(true);
            }
            InsertPointCmd insertPointCmd = new InsertPointCmd(dataPoint, -1);
            insertPointCmd.setDescription(I18nManager.getText("undo.createpoint"));
            insertPointCmd.setConfirmText(I18nManager.getText("confirm.pointadded"));
            this._app.execute(insertPointCmd);
            this._dialog.dispose();
        }
    }

    private static DataPoint makePoint(String string, Unit unit) {
        if (string.length() < 3) {
            return null;
        }
        String[] stringArray = string.split(",");
        switch (stringArray.length) {
            case 2: {
                return PasteCoordinates.parseValues(stringArray[0].trim(), stringArray[1].trim(), null, unit);
            }
            case 3: {
                return PasteCoordinates.parseValues(stringArray[0].trim(), stringArray[1].trim(), stringArray[2].trim(), unit);
            }
        }
        stringArray = string.split(";");
        switch (stringArray.length) {
            case 2: {
                return PasteCoordinates.parseValues(stringArray[0].trim(), stringArray[1].trim(), null, unit);
            }
            case 3: {
                return PasteCoordinates.parseValues(stringArray[0].trim(), stringArray[1].trim(), stringArray[2].trim(), unit);
            }
        }
        stringArray = string.split(" ");
        switch (stringArray.length) {
            case 2: {
                return PasteCoordinates.parseValues(stringArray[0], stringArray[1], null, unit);
            }
            case 3: {
                if (stringArray[1].length() != 1) break;
                return PasteCoordinates.parseValues(stringArray[0], stringArray[2], null, unit);
            }
            case 4: {
                return PasteCoordinates.parseValues(String.valueOf(stringArray[0]) + " " + stringArray[1], String.valueOf(stringArray[2]) + " " + stringArray[3], null, unit);
            }
            case 6: {
                return PasteCoordinates.parseValues(String.valueOf(stringArray[0]) + " " + stringArray[1] + " " + stringArray[2], String.valueOf(stringArray[3]) + " " + stringArray[4] + " " + stringArray[5], null, unit);
            }
            case 8: {
                String string2 = String.valueOf(stringArray[0]) + " " + stringArray[1] + " " + stringArray[2] + " " + stringArray[3];
                String string3 = String.valueOf(stringArray[4]) + " " + stringArray[5] + " " + stringArray[6] + " " + stringArray[7];
                return PasteCoordinates.parseValues(string2, string3, null, unit);
            }
        }
        return null;
    }

    private static DataPoint parseValues(String string, String string2, String string3, Unit unit) {
        Altitude altitude = null;
        if (string3 != null && !(altitude = new Altitude(string3, unit)).isValid()) {
            altitude = null;
        }
        Coordinate coordinate = Latitude.make(string);
        Coordinate coordinate2 = Longitude.make(string2);
        if (coordinate != null && Latitude.hasCardinal(string) && coordinate2 != null && Longitude.hasCardinal(string2)) {
            return new DataPoint(coordinate, coordinate2, altitude);
        }
        Coordinate coordinate3 = Longitude.make(string);
        Coordinate coordinate4 = Latitude.make(string2);
        if (coordinate3 != null && Longitude.hasCardinal(string) && coordinate4 != null && Latitude.hasCardinal(string2)) {
            return new DataPoint(coordinate4, coordinate3, altitude);
        }
        if (coordinate != null && coordinate2 != null) {
            return new DataPoint(coordinate, coordinate2, altitude);
        }
        if (coordinate3 != null && coordinate4 != null) {
            return new DataPoint(coordinate4, coordinate3, altitude);
        }
        return null;
    }
}

