/*
 * Decompiled with CFR 0.152.
 */
package tim.prune.data;

import java.util.ArrayList;
import tim.prune.data.MediaObject;

public class MediaList<T extends MediaObject> {
    protected final ArrayList<T> _media = new ArrayList();

    public int getCount() {
        return this._media.size();
    }

    public void add(T t) {
        if (t != null) {
            this._media.add(t);
        }
    }

    public void add(T t, int n) {
        if (t != null) {
            this._media.add(n, t);
        }
    }

    public void delete(int n) {
        this._media.remove(n);
    }

    public void delete(T t) {
        int n = this.getIndexOf(t);
        if (n > -1) {
            this._media.remove(n);
        }
    }

    public boolean contains(T t) {
        return this.getIndexOf(t) > -1;
    }

    public int getIndexOf(T t) {
        int n = this.getCount();
        if (n <= 0 || t == null) {
            return -1;
        }
        int n2 = 0;
        while (n2 < n) {
            MediaObject mediaObject = (MediaObject)this._media.get(n2);
            if (mediaObject == t) {
                return n2;
            }
            ++n2;
        }
        return -1;
    }

    public boolean hasDuplicate(T t) {
        int n = this.getCount();
        if (n <= 0 || t == null) {
            return false;
        }
        int n2 = 0;
        while (n2 < n) {
            MediaObject mediaObject = (MediaObject)this._media.get(n2);
            if (((MediaObject)t).equals(mediaObject)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public T get(int n) {
        if (n < 0 || n >= this.getCount()) {
            return null;
        }
        return (T)((MediaObject)this._media.get(n));
    }

    public boolean hasAny() {
        return !this._media.isEmpty();
    }

    public boolean hasCorrelatedMedia() {
        for (MediaObject mediaObject : this._media) {
            if (mediaObject.getDataPoint() == null) continue;
            return true;
        }
        return false;
    }

    public boolean hasUncorrelatedMedia() {
        for (MediaObject mediaObject : this._media) {
            if (mediaObject.getDataPoint() != null || !mediaObject.hasTimestamp()) continue;
            return true;
        }
        return false;
    }

    public void removeCorrelatedMedia() {
        if (this.getCount() > 0) {
            ArrayList<MediaObject> arrayList = new ArrayList<MediaObject>();
            for (MediaObject mediaObject : this._media) {
                if (mediaObject == null || mediaObject.getDataPoint() != null) continue;
                arrayList.add(mediaObject);
            }
            this._media.clear();
            this._media.addAll(arrayList);
        }
    }

    public boolean hasMediaWithFile() {
        for (MediaObject mediaObject : this._media) {
            if (mediaObject.getFile() == null) continue;
            return true;
        }
        return false;
    }

    public boolean hasModifiedMedia() {
        for (MediaObject mediaObject : this._media) {
            if (!mediaObject.isModified()) continue;
            return true;
        }
        return false;
    }

    public void restore(MediaList<T> mediaList) {
        this._media.clear();
        if (mediaList != null && mediaList.getCount() > 0) {
            this._media.addAll(mediaList._media);
        }
    }
}

