/*
 * Decompiled with CFR 0.152.
 */
package tim.prune.load.babel;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridLayout;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import tim.prune.I18nManager;
import tim.prune.data.UnitSetLibrary;
import tim.prune.gui.DecimalNumberField;
import tim.prune.gui.WholeNumberField;
import tim.prune.load.babel.AddFilterDialog;
import tim.prune.load.babel.FilterDefinition;

public class SimplifyFilter
extends FilterDefinition {
    private WholeNumberField _maxPointsField = null;
    private DecimalNumberField _distField = null;
    private JComboBox<String> _distUnitsCombo = null;
    private JRadioButton _crossTrackRadio = null;
    private JRadioButton _lengthRadio = null;
    private JRadioButton _relativeRadio = null;

    public SimplifyFilter(AddFilterDialog addFilterDialog) {
        super(addFilterDialog);
        this.makePanelContents();
    }

    @Override
    protected String getFilterName() {
        return "simplify";
    }

    @Override
    protected void makePanelContents() {
        this.setLayout(new BorderLayout());
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 1));
        this.add((Component)jPanel, "North");
        JLabel jLabel = new JLabel(I18nManager.getText("dialog.gpsbabel.filter.simplify.intro"));
        jLabel.setAlignmentX(0.0f);
        jPanel.add(jLabel);
        jPanel.add(Box.createVerticalStrut(18));
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new GridLayout(0, 3, 4, 4));
        jPanel2.add(new JLabel(I18nManager.getText("dialog.gpsbabel.filter.simplify.maxpoints")));
        this._maxPointsField = new WholeNumberField(6);
        this._maxPointsField.addKeyListener(this._paramChangeListener);
        jPanel2.add(this._maxPointsField);
        jPanel2.add(new JLabel(" "));
        jPanel2.add(new JLabel(I18nManager.getText("dialog.gpsbabel.filter.simplify.maxerror")));
        this._distField = new DecimalNumberField();
        this._distField.addKeyListener(this._paramChangeListener);
        jPanel2.add(this._distField);
        this._distUnitsCombo = new JComboBox<String>(new String[]{I18nManager.getText(UnitSetLibrary.UNITS_KILOMETRES.getNameKey()), I18nManager.getText(UnitSetLibrary.UNITS_MILES.getNameKey())});
        jPanel2.add(this._distUnitsCombo);
        this._crossTrackRadio = new JRadioButton(I18nManager.getText("dialog.gpsbabel.filter.simplify.crosstrack"));
        this._crossTrackRadio.setSelected(true);
        this._lengthRadio = new JRadioButton(I18nManager.getText("dialog.gpsbabel.filter.simplify.length"));
        this._relativeRadio = new JRadioButton(I18nManager.getText("dialog.gpsbabel.filter.simplify.relative"));
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(this._crossTrackRadio);
        buttonGroup.add(this._lengthRadio);
        buttonGroup.add(this._relativeRadio);
        jPanel2.add(this._crossTrackRadio);
        jPanel2.add(this._lengthRadio);
        jPanel2.add(this._relativeRadio);
        jPanel2.setAlignmentX(0.0f);
        jPanel.add(jPanel2);
    }

    @Override
    public boolean isFilterValid() {
        boolean bl;
        boolean bl2 = !this._maxPointsField.isEmpty();
        boolean bl3 = bl = !this._distField.isEmpty();
        if (!bl2 && !bl || bl2 && bl) {
            return false;
        }
        if (bl2 && this._maxPointsField.getValue() <= 1) {
            return false;
        }
        return !bl || !(this._distField.getValue() <= 0.001);
    }

    @Override
    protected String getParameters() {
        boolean bl;
        if (!this.isFilterValid()) {
            return null;
        }
        StringBuilder stringBuilder = new StringBuilder();
        boolean bl2 = !this._maxPointsField.isEmpty();
        boolean bl3 = bl = !this._distField.isEmpty();
        if (bl2) {
            stringBuilder.append(",count=").append(this._maxPointsField.getValue());
        } else if (bl) {
            double d = this._distField.getValue();
            stringBuilder.append(",error=").append(d);
            if (this._distUnitsCombo.getSelectedIndex() == 0) {
                stringBuilder.append("k");
            }
        }
        if (this._crossTrackRadio.isSelected()) {
            stringBuilder.append(",crosstrack");
        } else if (this._lengthRadio.isSelected()) {
            stringBuilder.append(",length");
        } else if (this._relativeRadio.isSelected()) {
            stringBuilder.append(",relative");
        }
        return stringBuilder.toString();
    }
}

