/*
 * Decompiled with CFR 0.152.
 */
package net.infonode.docking;

import java.awt.Point;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import javax.swing.Icon;
import net.infonode.docking.DockingWindow;
import net.infonode.docking.RootWindow;
import net.infonode.docking.WindowDecoder;
import net.infonode.docking.drop.InteriorDropInfo;
import net.infonode.docking.drop.SplitDropInfo;
import net.infonode.docking.internal.ReadContext;
import net.infonode.docking.internal.WindowAncestors;
import net.infonode.docking.internal.WriteContext;
import net.infonode.docking.internalutil.DropAction;
import net.infonode.docking.model.SplitWindowItem;
import net.infonode.docking.model.ViewReader;
import net.infonode.docking.model.ViewWriter;
import net.infonode.docking.properties.SplitWindowProperties;
import net.infonode.gui.ComponentUtil;
import net.infonode.gui.SimpleSplitPane;
import net.infonode.gui.SimpleSplitPaneListener;
import net.infonode.gui.panel.BaseContainerUtil;
import net.infonode.properties.propertymap.PropertyMap;
import net.infonode.util.Direction;

public class SplitWindow
extends DockingWindow {
    private SimpleSplitPane splitPane;
    private DockingWindow leftWindow;
    private DockingWindow rightWindow;

    public SplitWindow(boolean horizontal) {
        this(horizontal, null, null);
    }

    public SplitWindow(boolean horizontal, DockingWindow leftWindow, DockingWindow rightWindow) {
        this(horizontal, 0.5f, leftWindow, rightWindow);
    }

    public SplitWindow(boolean horizontal, float dividerLocation, DockingWindow leftWindow, DockingWindow rightWindow) {
        this(horizontal, dividerLocation, leftWindow, rightWindow, null);
    }

    protected SplitWindow(boolean horizontal, float dividerLocation, DockingWindow leftWindow, DockingWindow rightWindow, SplitWindowItem windowItem) {
        super(windowItem == null ? new SplitWindowItem() : windowItem);
        this.splitPane = new SimpleSplitPane(horizontal);
        BaseContainerUtil.setForcedOpaque(this.splitPane, false);
        this.splitPane.addListener(new SimpleSplitPaneListener(){

            @Override
            public void dividerLocationChanged(SimpleSplitPane simpleSplitPane) {
                ((SplitWindowItem)SplitWindow.this.getWindowItem()).setDividerLocation(simpleSplitPane.getDividerLocation());
            }
        });
        this.setComponent(this.splitPane);
        this.setWindows(leftWindow, rightWindow);
        this.setHorizontal(horizontal);
        this.setDividerLocation(dividerLocation);
        this.splitPane.getDividerPanel().addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                if (e.isPopupTrigger()) {
                    SplitWindow.this.showPopupMenu(e);
                }
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                this.mousePressed(e);
            }
        });
        this.init();
    }

    public SplitWindowProperties getSplitWindowProperties() {
        return ((SplitWindowItem)this.getWindowItem()).getSplitWindowProperties();
    }

    public DockingWindow getLeftWindow() {
        return this.leftWindow;
    }

    public DockingWindow getRightWindow() {
        return this.rightWindow;
    }

    public void setDividerLocation(float dividerLocation) {
        this.splitPane.setDividerLocation(dividerLocation);
    }

    public float getDividerLocation() {
        return this.splitPane.getDividerLocation();
    }

    public void setWindows(final DockingWindow leftWindow, final DockingWindow rightWindow) {
        if (leftWindow == this.getLeftWindow() && rightWindow == this.getRightWindow()) {
            return;
        }
        SplitWindow.optimizeAfter(null, new Runnable(){

            @Override
            public void run() {
                WindowAncestors leftAncestors = leftWindow.storeAncestors();
                WindowAncestors rightAncestors = rightWindow.storeAncestors();
                DockingWindow lw = leftWindow.getContentWindow(SplitWindow.this);
                DockingWindow rw = rightWindow.getContentWindow(SplitWindow.this);
                lw.detach();
                rw.detach();
                if (SplitWindow.this.getLeftWindow() != null) {
                    SplitWindow.this.removeWindow(SplitWindow.this.getLeftWindow());
                }
                if (SplitWindow.this.getRightWindow() != null) {
                    SplitWindow.this.removeWindow(SplitWindow.this.getRightWindow());
                }
                SplitWindow.this.leftWindow = lw;
                SplitWindow.this.rightWindow = rw;
                SplitWindow.this.splitPane.setComponents(lw, rw);
                SplitWindow.this.addWindow(lw);
                SplitWindow.this.addWindow(rw);
                if (SplitWindow.this.getUpdateModel()) {
                    SplitWindow.this.addWindowItem(SplitWindow.this.getLeftWindow(), -1);
                    SplitWindow.this.addWindowItem(SplitWindow.this.getRightWindow(), -1);
                    SplitWindow.this.cleanUpModel();
                }
                leftWindow.notifyListeners(leftAncestors);
                rightWindow.notifyListeners(rightAncestors);
            }
        });
    }

    public boolean isHorizontal() {
        return this.splitPane.isHorizontal();
    }

    public void setHorizontal(boolean horizontal) {
        this.splitPane.setHorizontal(horizontal);
        ((SplitWindowItem)this.getWindowItem()).setHorizontal(horizontal);
    }

    @Override
    protected void update() {
        this.splitPane.setDividerSize(this.getSplitWindowProperties().getDividerSize());
        this.splitPane.setContinuousLayout(this.getSplitWindowProperties().getContinuousLayoutEnabled());
        this.splitPane.setDividerDraggable(this.getSplitWindowProperties().getDividerLocationDragEnabled());
        this.splitPane.setDragIndicatorColor(this.getSplitWindowProperties().getDragIndicatorColor());
    }

    @Override
    protected void optimizeWindowLayout() {
        DockingWindow parent = this.getWindowParent();
        if (parent != null && (this.getRightWindow() == null || this.getLeftWindow() == null)) {
            if (this.getRightWindow() == null && this.getLeftWindow() == null) {
                parent.removeChildWindow(this);
            } else {
                DockingWindow w = this.getRightWindow() == null ? this.getLeftWindow() : this.getRightWindow();
                parent.internalReplaceChildWindow(this, w.getBestFittedWindow(parent));
            }
        }
    }

    @Override
    public DockingWindow getChildWindow(int index) {
        return this.getWindows()[index];
    }

    @Override
    protected void rootChanged(RootWindow oldRoot, RootWindow newRoot) {
        super.rootChanged(oldRoot, newRoot);
        if (newRoot != null) {
            this.splitPane.setHeavyWeightDragIndicator(newRoot.isHeavyweightSupported());
        }
    }

    private DockingWindow[] getWindows() {
        DockingWindow[] dockingWindowArray;
        if (this.getLeftWindow() == null) {
            if (this.getRightWindow() == null) {
                dockingWindowArray = new DockingWindow[]{};
            } else {
                DockingWindow[] dockingWindowArray2 = new DockingWindow[1];
                dockingWindowArray = dockingWindowArray2;
                dockingWindowArray2[0] = this.getRightWindow();
            }
        } else if (this.getRightWindow() == null) {
            DockingWindow[] dockingWindowArray3 = new DockingWindow[1];
            dockingWindowArray = dockingWindowArray3;
            dockingWindowArray3[0] = this.getLeftWindow();
        } else {
            DockingWindow[] dockingWindowArray4 = new DockingWindow[2];
            dockingWindowArray4[0] = this.getLeftWindow();
            dockingWindowArray = dockingWindowArray4;
            dockingWindowArray4[1] = this.getRightWindow();
        }
        return dockingWindowArray;
    }

    @Override
    public int getChildWindowCount() {
        return this.getWindows().length;
    }

    @Override
    public Icon getIcon() {
        return this.getLeftWindow() == null ? (this.getRightWindow() == null ? null : this.getRightWindow().getIcon()) : this.getLeftWindow().getIcon();
    }

    @Override
    protected void doReplace(DockingWindow oldWindow, DockingWindow newWindow) {
        if (this.getLeftWindow() == oldWindow) {
            this.leftWindow = newWindow;
            this.splitPane.setLeftComponent(newWindow);
        } else {
            this.rightWindow = newWindow;
            this.splitPane.setRightComponent(newWindow);
        }
        ComponentUtil.validate(this.splitPane);
    }

    @Override
    protected void doRemoveWindow(DockingWindow window) {
        if (window == this.getLeftWindow()) {
            this.leftWindow = null;
            this.splitPane.setLeftComponent(null);
        } else {
            this.rightWindow = null;
            this.splitPane.setRightComponent(null);
        }
    }

    @Override
    protected DockingWindow oldRead(ObjectInputStream in, ReadContext context) throws IOException {
        this.splitPane.setHorizontal(in.readBoolean());
        this.splitPane.setDividerLocation(in.readFloat());
        DockingWindow leftWindow = WindowDecoder.decodeWindow(in, context);
        DockingWindow rightWindow = WindowDecoder.decodeWindow(in, context);
        super.oldRead(in, context);
        if (leftWindow != null && rightWindow != null) {
            this.setWindows(leftWindow, rightWindow);
            return this;
        }
        return leftWindow != null ? leftWindow : (rightWindow != null ? rightWindow : null);
    }

    @Override
    protected void updateWindowItem(RootWindow rootWindow) {
        super.updateWindowItem(rootWindow);
        ((SplitWindowItem)this.getWindowItem()).setParentSplitWindowProperties(rootWindow == null ? SplitWindowItem.emptyProperties : rootWindow.getRootWindowProperties().getSplitWindowProperties());
    }

    @Override
    protected PropertyMap getPropertyObject() {
        return this.getSplitWindowProperties().getMap();
    }

    @Override
    protected PropertyMap createPropertyObject() {
        return new SplitWindowProperties().getMap();
    }

    @Override
    void removeWindowComponent(DockingWindow window) {
        if (window == this.getLeftWindow()) {
            this.splitPane.setLeftComponent(null);
        } else {
            this.splitPane.setRightComponent(null);
        }
    }

    @Override
    void restoreWindowComponent(DockingWindow window) {
        if (window == this.getLeftWindow()) {
            this.splitPane.setLeftComponent(this.leftWindow);
        } else {
            this.splitPane.setRightComponent(this.rightWindow);
        }
    }

    @Override
    protected int getChildEdgeDepth(DockingWindow window, Direction dir) {
        return (window == this.leftWindow ? dir : dir.getOpposite()) == (this.isHorizontal() ? Direction.RIGHT : Direction.DOWN) ? 0 : super.getChildEdgeDepth(window, dir);
    }

    @Override
    protected DropAction doAcceptDrop(Point p, DockingWindow window) {
        float f;
        DropAction da = this.acceptChildDrop(p, window);
        if (da != null) {
            return da;
        }
        float f2 = f = this.isHorizontal() ? (float)p.y / (float)this.getHeight() : (float)p.x / (float)this.getWidth();
        if (f <= 0.33f) {
            Direction splitDir = this.isHorizontal() ? Direction.UP : Direction.LEFT;
            return this.getSplitDropFilter().acceptDrop(new SplitDropInfo(window, this, p, splitDir)) ? this.split(window, splitDir) : null;
        }
        if (f >= 0.66f) {
            Direction splitDir = this.isHorizontal() ? Direction.DOWN : Direction.RIGHT;
            return this.getSplitDropFilter().acceptDrop(new SplitDropInfo(window, this, p, splitDir)) ? this.split(window, splitDir) : null;
        }
        return this.getInteriorDropFilter().acceptDrop(new InteriorDropInfo(window, this, p)) ? this.createTabWindow(window) : null;
    }

    @Override
    protected void write(ObjectOutputStream out, WriteContext context, ViewWriter viewWriter) throws IOException {
        out.writeInt(2);
        viewWriter.writeWindowItem(this.getWindowItem(), out, context);
        this.getLeftWindow().write(out, context, viewWriter);
        this.getRightWindow().write(out, context, viewWriter);
    }

    protected DockingWindow newRead(ObjectInputStream in, ReadContext context, ViewReader viewReader) throws IOException {
        DockingWindow leftWindow = WindowDecoder.decodeWindow(in, context, viewReader);
        DockingWindow rightWindow = WindowDecoder.decodeWindow(in, context, viewReader);
        if (leftWindow != null && rightWindow != null) {
            this.setWindows(leftWindow, rightWindow);
            return this;
        }
        return leftWindow != null ? leftWindow : (rightWindow != null ? rightWindow : null);
    }
}

