## Source: https://twitter.com/lemiorhan/status/935578694541770752 & https://forums.developer.apple.com/thread/79235
"Dear @AppleSupport, we noticed a *HUGE* security issue at MacOS High Sierra. Anyone can login as "root" with empty password after clicking on login button several times. Are you aware of it @Apple?"


## Proof: https://twitter.com/patrickwardle/status/935608904377077761


## Mitigation/Detection/Forensic: https://news.ycombinator.com/item?id=15800676
- Can be mitigated by enabling the root user with a strong password
- Can be detected with `osquery` using `SELECT * FROM plist WHERE path = "/private/var/db/dslocal/nodes/Default/users/root.plist" AND key = "passwd" AND length(value) > 1;";`
- You can see what time the root account was enabled using `SELECT * FROM plist WHERE path = "/private/var/db/dslocal/nodes/Default/users/root.plist" WHERE key = "accountPolicyData";` then base 64 decoding that into a file and then running `plutil -convert xml1` and looking at the `passwordLastSetTime` field.
_Note: osquery needs to be running with `sudo` but if you have it deployed across a fleet of macs as a daemon then it will be running with `sudo` anyway._
_Note: You can get the same info with plutil(1): `$ sudo plutil -p /private/var/db/dslocal/nodes/Default/users/root.plist`_


## Security Advisory: https://support.apple.com/en-gb/HT208315