/*
 * Decompiled with CFR 0.152.
 */
package io.cucumber.messages.types;

import io.cucumber.messages.types.SourceReference;
import java.util.Objects;
import java.util.Optional;

public final class Hook {
    private final String id;
    private final String name;
    private final SourceReference sourceReference;
    private final String tagExpression;

    public Hook(String id, String name, SourceReference sourceReference, String tagExpression) {
        this.id = Objects.requireNonNull(id, "Hook.id cannot be null");
        this.name = name;
        this.sourceReference = Objects.requireNonNull(sourceReference, "Hook.sourceReference cannot be null");
        this.tagExpression = tagExpression;
    }

    public String getId() {
        return this.id;
    }

    public Optional<String> getName() {
        return Optional.ofNullable(this.name);
    }

    public SourceReference getSourceReference() {
        return this.sourceReference;
    }

    public Optional<String> getTagExpression() {
        return Optional.ofNullable(this.tagExpression);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Hook that = (Hook)o;
        return this.id.equals(that.id) && Objects.equals(this.name, that.name) && this.sourceReference.equals(that.sourceReference) && Objects.equals(this.tagExpression, that.tagExpression);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.name, this.sourceReference, this.tagExpression);
    }

    public String toString() {
        return "Hook{id=" + this.id + ", name=" + this.name + ", sourceReference=" + this.sourceReference + ", tagExpression=" + this.tagExpression + '}';
    }
}

