/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.filebuffers.manipulation;

import java.util.Map;
import org.eclipse.core.filebuffers.IFileBuffer;
import org.eclipse.core.filebuffers.ITextFileBuffer;
import org.eclipse.core.filebuffers.manipulation.IFileBufferOperation;
import org.eclipse.core.filebuffers.manipulation.MultiTextEditWithProgress;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.DocumentRewriteSession;
import org.eclipse.jface.text.DocumentRewriteSessionType;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentExtension4;
import org.eclipse.jface.text.IDocumentPartitioner;
import org.eclipse.jface.text.TextUtilities;

public abstract class TextFileBufferOperation
implements IFileBufferOperation {
    private final String fOperationName;
    private DocumentRewriteSession fDocumentRewriteSession;

    protected abstract MultiTextEditWithProgress computeTextEdit(ITextFileBuffer var1, IProgressMonitor var2) throws CoreException, OperationCanceledException;

    protected abstract DocumentRewriteSessionType getDocumentRewriteSessionType();

    protected TextFileBufferOperation(String operationName) {
        this.fOperationName = operationName;
    }

    @Override
    public String getOperationName() {
        return this.fOperationName;
    }

    @Override
    public void run(IFileBuffer fileBuffer, IProgressMonitor progressMonitor) throws CoreException, OperationCanceledException {
        IPath path;
        String taskName;
        SubMonitor subMonitor;
        ITextFileBuffer textFileBuffer;
        MultiTextEditWithProgress edit;
        if (fileBuffer instanceof ITextFileBuffer && (edit = this.computeTextEdit(textFileBuffer, (IProgressMonitor)(subMonitor = SubMonitor.convert((IProgressMonitor)progressMonitor, (String)(taskName = (path = (textFileBuffer = (ITextFileBuffer)fileBuffer).getLocation()) == null ? this.getOperationName() : path.lastSegment()), (int)100)).split(10))) != null) {
            Map<String, IDocumentPartitioner> stateData = this.startRewriteSession(textFileBuffer);
            try {
                this.applyTextEdit(textFileBuffer, edit, (IProgressMonitor)subMonitor.split(90));
            }
            finally {
                this.stopRewriteSession(textFileBuffer, stateData);
            }
        }
    }

    private Map<String, IDocumentPartitioner> startRewriteSession(ITextFileBuffer fileBuffer) {
        Map stateData = null;
        IDocument document = fileBuffer.getDocument();
        if (document instanceof IDocumentExtension4) {
            IDocumentExtension4 extension = (IDocumentExtension4)document;
            this.fDocumentRewriteSession = extension.startRewriteSession(this.getDocumentRewriteSessionType());
        } else {
            stateData = TextUtilities.removeDocumentPartitioners((IDocument)document);
        }
        return stateData;
    }

    private void stopRewriteSession(ITextFileBuffer fileBuffer, Map<String, IDocumentPartitioner> stateData) {
        IDocument document = fileBuffer.getDocument();
        if (document instanceof IDocumentExtension4) {
            IDocumentExtension4 extension = (IDocumentExtension4)document;
            extension.stopRewriteSession(this.fDocumentRewriteSession);
            this.fDocumentRewriteSession = null;
        } else if (stateData != null) {
            TextUtilities.addDocumentPartitioners((IDocument)document, stateData);
        }
    }

    private void applyTextEdit(ITextFileBuffer fileBuffer, MultiTextEditWithProgress textEdit, IProgressMonitor progressMonitor) throws CoreException, OperationCanceledException {
        try {
            textEdit.apply(fileBuffer.getDocument(), 0, progressMonitor);
        }
        catch (BadLocationException x) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.core.filebuffers", 1, "", (Throwable)x));
        }
    }
}

