/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.mssql.edit;

import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.ext.mssql.SQLServerConstants;
import org.jkiss.dbeaver.ext.mssql.model.SQLServerSchema;
import org.jkiss.dbeaver.ext.mssql.model.SQLServerTable;
import org.jkiss.dbeaver.ext.mssql.model.SQLServerTableBase;
import org.jkiss.dbeaver.ext.mssql.model.SQLServerTableIndex;
import org.jkiss.dbeaver.ext.mssql.model.SQLServerTableIndexColumn;
import org.jkiss.dbeaver.ext.mssql.model.SQLServerTableType;
import org.jkiss.dbeaver.model.DBPEvaluationContext;
import org.jkiss.dbeaver.model.DBPScriptObject;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.edit.DBECommandContext;
import org.jkiss.dbeaver.model.edit.DBEPersistAction;
import org.jkiss.dbeaver.model.exec.DBCExecutionContext;
import org.jkiss.dbeaver.model.impl.edit.SQLDatabasePersistAction;
import org.jkiss.dbeaver.model.impl.sql.edit.SQLObjectEditor;
import org.jkiss.dbeaver.model.impl.sql.edit.struct.SQLIndexManager;
import org.jkiss.dbeaver.model.messages.ModelMessages;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.model.struct.cache.DBSObjectCache;
import org.jkiss.dbeaver.model.struct.rdb.DBSIndexType;
import org.jkiss.utils.CommonUtils;

public class SQLServerIndexManager
extends SQLIndexManager<SQLServerTableIndex, SQLServerTableBase> {
    @Nullable
    public DBSObjectCache<? extends DBSObject, SQLServerTableIndex> getObjectsCache(SQLServerTableIndex object) {
        return ((SQLServerSchema)((SQLServerTableBase)object.getTable()).getContainer()).getIndexCache();
    }

    protected SQLServerTableIndex createDatabaseObject(@NotNull DBRProgressMonitor monitor, @NotNull DBECommandContext context, Object container, Object from, @NotNull Map<String, Object> options) {
        SQLServerTable table = (SQLServerTable)container;
        return new SQLServerTableIndex(table, true, false, null, DBSIndexType.UNKNOWN, null, false);
    }

    protected void addObjectCreateActions(@NotNull DBRProgressMonitor monitor, @NotNull DBCExecutionContext executionContext, @NotNull List<DBEPersistAction> actions, @NotNull SQLObjectEditor.ObjectCreateCommand command, @NotNull Map<String, Object> options) {
        SQLServerTableIndex index = (SQLServerTableIndex)command.getObject();
        SQLServerTableBase indexTable = (SQLServerTableBase)index.getTable();
        if (indexTable instanceof SQLServerTableType) {
            return;
        }
        if (index.isPersisted()) {
            try {
                String indexDDL = index.getObjectDefinitionText(monitor, DBPScriptObject.EMPTY_OPTIONS);
                if (!CommonUtils.isEmpty((String)indexDDL)) {
                    actions.add((DBEPersistAction)new SQLDatabasePersistAction(ModelMessages.model_jdbc_create_new_index, indexDDL));
                    return;
                }
            }
            catch (DBException e) {
                log.warn((Object)"Can't extract index DDL", (Throwable)e);
            }
        }
        DBSIndexType indexType = index.getIndexType();
        String sqlServerIndexType = null;
        if (indexType == DBSIndexType.CLUSTERED) {
            sqlServerIndexType = "CLUSTERED";
        } else if (indexType == SQLServerConstants.INDEX_TYPE_NON_CLUSTERED) {
            sqlServerIndexType = "NONCLUSTERED";
        }
        StringBuilder ddl = new StringBuilder();
        ddl.append("CREATE ");
        if (index.isUnique()) {
            ddl.append("UNIQUE ");
        }
        boolean columnStore = index.isColumnStore();
        if (sqlServerIndexType != null) {
            ddl.append(sqlServerIndexType).append(" ");
            if (columnStore) {
                ddl.append("COLUMNSTORE ");
            }
        }
        ddl.append("INDEX ").append(DBUtils.getQuotedIdentifier((DBSObject)index)).append(" ON ").append(indexTable.getFullyQualifiedName(DBPEvaluationContext.DDL));
        List<SQLServerTableIndexColumn> indexColumns = index.getAttributeReferences(monitor);
        if (!columnStore || index.getIndexType() != DBSIndexType.CLUSTERED) {
            if (indexColumns != null) {
                String includedColumns;
                ddl.append(indexColumns.stream().filter(x -> !x.isIncluded() || columnStore).map(DBUtils::getQuotedIdentifier).collect(Collectors.joining(", ", " (", ")")));
                if (!columnStore && !(includedColumns = indexColumns.stream().filter(SQLServerTableIndexColumn::isIncluded).map(DBUtils::getQuotedIdentifier).collect(Collectors.joining(", "))).isEmpty()) {
                    ddl.append(" INCLUDE (").append(includedColumns).append(")");
                }
            } else {
                super.addObjectCreateActions(monitor, executionContext, actions, command, options);
                return;
            }
        }
        actions.add((DBEPersistAction)new SQLDatabasePersistAction("Create new SQL Server index", ddl.toString()));
    }

    protected String getDropIndexPattern(SQLServerTableIndex index) {
        return "DROP INDEX " + DBUtils.getQuotedIdentifier((DBSObject)index) + " ON " + ((SQLServerTableBase)index.getTable()).getFullyQualifiedName(DBPEvaluationContext.DDL);
    }

    protected void addObjectModifyActions(@NotNull DBRProgressMonitor monitor, @NotNull DBCExecutionContext executionContext, @NotNull List<DBEPersistAction> actionList, @NotNull SQLObjectEditor.ObjectChangeCommand command, @NotNull Map<String, Object> options) throws DBException {
        this.addObjectDeleteActions(monitor, executionContext, actionList, new SQLObjectEditor.ObjectDeleteCommand((SQLObjectEditor)this, (DBSObject)((SQLServerTableIndex)command.getObject()), command.getTitle()), options);
        this.addObjectCreateActions(monitor, executionContext, actionList, this.makeCreateCommand((SQLServerTableIndex)command.getObject(), options), options);
    }
}

