/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.model.sql.semantics.model.expressions;

import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.model.sql.semantics.SQLQueryComplexName;
import org.jkiss.dbeaver.model.sql.semantics.SQLQueryRecognitionContext;
import org.jkiss.dbeaver.model.sql.semantics.SQLQuerySemanticUtils;
import org.jkiss.dbeaver.model.sql.semantics.SQLQuerySymbolClass;
import org.jkiss.dbeaver.model.sql.semantics.SQLQuerySymbolOrigin;
import org.jkiss.dbeaver.model.sql.semantics.context.SQLQueryExprType;
import org.jkiss.dbeaver.model.sql.semantics.context.SQLQueryRowsDataContext;
import org.jkiss.dbeaver.model.sql.semantics.context.SQLQueryRowsSourceContext;
import org.jkiss.dbeaver.model.sql.semantics.context.SourceResolutionResult;
import org.jkiss.dbeaver.model.sql.semantics.model.SQLQueryMemberAccessEntry;
import org.jkiss.dbeaver.model.sql.semantics.model.SQLQueryNodeModel;
import org.jkiss.dbeaver.model.sql.semantics.model.SQLQueryNodeModelVisitor;
import org.jkiss.dbeaver.model.sql.semantics.model.SQLQueryTupleRefEntry;
import org.jkiss.dbeaver.model.sql.semantics.model.expressions.SQLQueryValueExpression;
import org.jkiss.dbeaver.model.sql.semantics.model.select.SQLQueryRowsSourceModel;
import org.jkiss.dbeaver.model.stm.STMTreeNode;

public class SQLQueryValueTupleReferenceExpression
extends SQLQueryValueExpression {
    @NotNull
    private final SQLQueryComplexName tableName;
    @Nullable
    private final SQLQueryMemberAccessEntry memberAccessEntry;
    @Nullable
    private final SQLQueryTupleRefEntry tupleRefEntry;
    @Nullable
    private SQLQueryRowsSourceModel tupleSource = null;

    public SQLQueryValueTupleReferenceExpression(@NotNull STMTreeNode syntaxNode, @NotNull SQLQueryComplexName tableName, @Nullable SQLQueryMemberAccessEntry memberAccessEntry, @Nullable SQLQueryTupleRefEntry tupleRefEntry) {
        super(syntaxNode, new SQLQueryNodeModel[0]);
        this.tableName = tableName;
        this.memberAccessEntry = memberAccessEntry;
        this.tupleRefEntry = tupleRefEntry;
    }

    @Override
    @Nullable
    public SQLQuerySymbolClass getAssociatedSymbolClass() {
        return SQLQuerySemanticUtils.getIdentifierSymbolClass(this.tableName);
    }

    @NotNull
    public SQLQueryComplexName getTableName() {
        return this.tableName;
    }

    @Nullable
    public SQLQueryTupleRefEntry getTupleRefEntry() {
        return this.tupleRefEntry;
    }

    @Nullable
    public SQLQueryRowsSourceModel getTupleSource() {
        return this.tupleSource;
    }

    @Override
    protected void resolveRowSourcesImpl(@NotNull SQLQueryRowsSourceContext context, @NotNull SQLQueryRecognitionContext statistics) {
    }

    @Override
    @NotNull
    protected SQLQueryExprType resolveValueTypeImpl(@NotNull SQLQueryRowsDataContext context, @NotNull SQLQueryRecognitionContext statistics) {
        SQLQueryExprType result;
        if (this.tableName.isNotClassified()) {
            SQLQuerySymbolOrigin.RowsDataRef tableNameOrigin = new SQLQuerySymbolOrigin.RowsDataRef(context);
            if (this.tableName.invalidPartsCount == 0) {
                SourceResolutionResult rr = context.getRowsSources().findReferencedSourceExact(this.tableName);
                if (rr != null) {
                    this.tupleSource = rr.source;
                    SQLQuerySemanticUtils.setNamePartsDefinition(this.tableName, rr, tableNameOrigin);
                    if (this.memberAccessEntry != null) {
                        this.memberAccessEntry.setOrigin(new SQLQuerySymbolOrigin.ColumnRefFromReferencedContext(rr));
                    }
                    if (this.tupleRefEntry != null) {
                        this.tupleRefEntry.setOrigin(new SQLQuerySymbolOrigin.ExpandableRowsTupleRef(this.getSyntaxNode(), context, rr));
                    }
                    result = SQLQueryExprType.forReferencedRow(this.tableName, rr);
                } else {
                    this.tableName.parts.forEach(p -> p.getSymbol().setSymbolClass(SQLQuerySymbolClass.ERROR));
                    statistics.appendError(this.tableName.syntaxNode, "Table or subquery " + this.tableName.getNameString() + " not found");
                    result = SQLQueryExprType.UNKNOWN;
                }
            } else {
                SQLQuerySemanticUtils.performPartialResolution(context.getRowsSources(), statistics, this.tableName, tableNameOrigin, SQLQuerySymbolOrigin.DbObjectFilterMode.VALUE, SQLQuerySymbolClass.ERROR);
                statistics.appendError(this.getSyntaxNode(), "Invalid tuple reference");
                result = SQLQueryExprType.UNKNOWN;
            }
        } else {
            result = this.type;
        }
        return result;
    }

    @Override
    protected <R, T> R applyImpl(@NotNull SQLQueryNodeModelVisitor<T, R> visitor, @NotNull T arg) {
        return visitor.visitValueTupleRefExpr(this, arg);
    }

    public String toString() {
        String name = this.tableName.getNameString();
        String type = this.type == null ? "<NULL>" : this.type.toString();
        return "TupleReference[" + name + ":" + type + "]";
    }
}

