/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.swingx;

import java.awt.Component;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.text.JTextComponent;
import org.jdesktop.html.form.Input;
import org.jdesktop.http.Method;
import org.jdesktop.http.async.AsyncHttpRequest;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JXHtmlForm
extends JPanel {
    public static final String NAME = "JXHtmlForm-form-name-id";
    public static final String VALUE = "JXHtmlForm-form-value-id";
    private URI action;
    private Method method;

    private static void blar() throws URISyntaxException {
        JXHtmlForm form = new JXHtmlForm("http://vin.stronghold.com/VINResult.aspx", Method.GET);
    }

    public JXHtmlForm() {
        this.method = Method.GET;
    }

    public JXHtmlForm(String actionUri, Method method) throws URISyntaxException {
        this.setAction(new URI(actionUri));
        this.setMethod(method);
    }

    public void setAction(URI action) {
        URI old = this.getAction();
        this.action = action;
        this.firePropertyChange("action", old, this.getAction());
    }

    public URI getAction() {
        return this.action;
    }

    public void setMethod(Method m) {
        if (m == null) {
            throw new NullPointerException("Method must be GET or POST");
        }
        Method old = this.getMethod();
        this.method = m;
        this.firePropertyChange("method", (Object)old, (Object)this.getMethod());
    }

    public Method getMethod() {
        return this.method;
    }

    public List<Parameter> getParameters() {
        ArrayList<Parameter> params = new ArrayList<Parameter>();
        for (Component c : this.getComponents()) {
            String value;
            String name = c.getName();
            String string = value = c instanceof Input ? ((Input)((Object)c)).getValue() : null;
            if (name != null && value != null || !(c instanceof JComponent)) continue;
            JComponent comp = (JComponent)c;
            if (name == null) {
                name = (String)comp.getClientProperty(NAME);
            }
            if (name != null && value == null) {
                if (comp instanceof AbstractButton) {
                    boolean selected = ((AbstractButton)comp).isSelected();
                    if (selected) {
                        value = (String)comp.getClientProperty(VALUE);
                    }
                } else if (comp instanceof JPasswordField) {
                    value = new String(((JPasswordField)comp).getPassword());
                } else if (comp instanceof JTextComponent) {
                    value = ((JTextComponent)comp).getText();
                } else if (comp instanceof JList) {
                    Object sel = ((JList)comp).getSelectedValue();
                    if (sel != null) {
                        value = sel instanceof Option ? ((Option)sel).getValue() : sel.toString();
                    }
                } else if (comp instanceof JComboBox) {
                    Object sel = ((JComboBox)comp).getSelectedItem();
                    if (sel != null) {
                        value = sel instanceof Option ? ((Option)sel).getValue() : sel.toString();
                    }
                } else {
                    value = (String)comp.getClientProperty(VALUE);
                }
            }
            if (name == null || value == null) continue;
            params.add(new Parameter(name, value));
        }
        return params;
    }

    public void submit(AsyncHttpRequest req) throws Exception {
        URI uri = this.getAction();
        if (uri != null) {
            req.open(this.getMethod(), uri.toString());
            for (Parameter p : this.getParameters()) {
                req.setParameter(p.getName(), p.getValue());
            }
            req.send();
        }
    }

    public String submit() throws Exception {
        URI uri = this.getAction();
        if (uri != null) {
            AsyncHttpRequest req = new AsyncHttpRequest();
            req.open(this.getMethod(), uri.toString(), false);
            for (Parameter p : this.getParameters()) {
                req.setParameter(p.getName(), p.getValue());
            }
            req.send();
            return req.getResponseText();
        }
        return null;
    }

    public static final class Parameter {
        private String name;
        private String value;

        Parameter(String n, String v) {
            this.name = n;
            this.value = v;
        }

        public String getName() {
            return this.name;
        }

        public String getValue() {
            return this.value;
        }

        public String toParamString() {
            try {
                return URLEncoder.encode(this.name, "UTF-8") + "=" + URLEncoder.encode(this.value, "UTF-8");
            }
            catch (UnsupportedEncodingException ex) {
                ex.printStackTrace();
                return this.name + "=" + this.value;
            }
        }
    }

    public static class Option {
        private String value;
        private String display;

        public Option(String value, String display) {
            this.value = value;
            this.display = display;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return this.display;
        }
    }
}

