﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/core/utils/memory/stl/AWSVector.h>
#include <aws/redshift/Redshift_EXPORTS.h>
#include <aws/redshift/model/EndpointAuthorization.h>
#include <aws/redshift/model/ResponseMetadata.h>

#include <utility>

namespace Aws {
template <typename RESULT_TYPE>
class AmazonWebServiceResult;

namespace Utils {
namespace Xml {
class XmlDocument;
}  // namespace Xml
}  // namespace Utils
namespace Redshift {
namespace Model {
class DescribeEndpointAuthorizationResult {
 public:
  AWS_REDSHIFT_API DescribeEndpointAuthorizationResult() = default;
  AWS_REDSHIFT_API DescribeEndpointAuthorizationResult(const Aws::AmazonWebServiceResult<Aws::Utils::Xml::XmlDocument>& result);
  AWS_REDSHIFT_API DescribeEndpointAuthorizationResult& operator=(const Aws::AmazonWebServiceResult<Aws::Utils::Xml::XmlDocument>& result);

  ///@{
  /**
   * <p>The authorizations to an endpoint.</p>
   */
  inline const Aws::Vector<EndpointAuthorization>& GetEndpointAuthorizationList() const { return m_endpointAuthorizationList; }
  template <typename EndpointAuthorizationListT = Aws::Vector<EndpointAuthorization>>
  void SetEndpointAuthorizationList(EndpointAuthorizationListT&& value) {
    m_endpointAuthorizationListHasBeenSet = true;
    m_endpointAuthorizationList = std::forward<EndpointAuthorizationListT>(value);
  }
  template <typename EndpointAuthorizationListT = Aws::Vector<EndpointAuthorization>>
  DescribeEndpointAuthorizationResult& WithEndpointAuthorizationList(EndpointAuthorizationListT&& value) {
    SetEndpointAuthorizationList(std::forward<EndpointAuthorizationListT>(value));
    return *this;
  }
  template <typename EndpointAuthorizationListT = EndpointAuthorization>
  DescribeEndpointAuthorizationResult& AddEndpointAuthorizationList(EndpointAuthorizationListT&& value) {
    m_endpointAuthorizationListHasBeenSet = true;
    m_endpointAuthorizationList.emplace_back(std::forward<EndpointAuthorizationListT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>An optional pagination token provided by a previous
   * <code>DescribeEndpointAuthorization</code> request. If this parameter is
   * specified, the response includes only records beyond the marker, up to the value
   * specified by the <code>MaxRecords</code> parameter.</p>
   */
  inline const Aws::String& GetMarker() const { return m_marker; }
  template <typename MarkerT = Aws::String>
  void SetMarker(MarkerT&& value) {
    m_markerHasBeenSet = true;
    m_marker = std::forward<MarkerT>(value);
  }
  template <typename MarkerT = Aws::String>
  DescribeEndpointAuthorizationResult& WithMarker(MarkerT&& value) {
    SetMarker(std::forward<MarkerT>(value));
    return *this;
  }
  ///@}

  ///@{

  inline const ResponseMetadata& GetResponseMetadata() const { return m_responseMetadata; }
  template <typename ResponseMetadataT = ResponseMetadata>
  void SetResponseMetadata(ResponseMetadataT&& value) {
    m_responseMetadataHasBeenSet = true;
    m_responseMetadata = std::forward<ResponseMetadataT>(value);
  }
  template <typename ResponseMetadataT = ResponseMetadata>
  DescribeEndpointAuthorizationResult& WithResponseMetadata(ResponseMetadataT&& value) {
    SetResponseMetadata(std::forward<ResponseMetadataT>(value));
    return *this;
  }
  ///@}
 private:
  Aws::Vector<EndpointAuthorization> m_endpointAuthorizationList;
  bool m_endpointAuthorizationListHasBeenSet = false;

  Aws::String m_marker;
  bool m_markerHasBeenSet = false;

  ResponseMetadata m_responseMetadata;
  bool m_responseMetadataHasBeenSet = false;
};

}  // namespace Model
}  // namespace Redshift
}  // namespace Aws
