/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.plugin.devel.tasks.internal;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonPrimitive;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.util.Map;
import org.gradle.api.problems.ProblemDefinition;
import org.gradle.api.problems.internal.DefaultProblemDefinition;
import org.jspecify.annotations.Nullable;

public final class ProblemReportAdapterFactory
implements TypeAdapterFactory {
    public <T> @Nullable TypeAdapter<T> create(Gson gson, @Nullable TypeToken<T> type) {
        if (type == null) {
            return null;
        }
        Class rawType = type.getRawType();
        if (ProblemDefinition.class.equals((Object)rawType)) {
            return new SingleImplTypeAdapter(ProblemDefinition.class, DefaultProblemDefinition.class, gson.getAdapter(JsonElement.class), gson.getDelegateAdapter((TypeAdapterFactory)this, TypeToken.get(DefaultProblemDefinition.class))).nullSafe();
        }
        return null;
    }

    private static class SingleImplTypeAdapter<T, U>
    extends TypeAdapter<T> {
        private final Class<T> baseClass;
        private final Class<U> implClass;
        private final String label;
        private final TypeAdapter<JsonElement> jsonElementAdapter;
        private final TypeAdapter<U> implClassAdapter;

        private SingleImplTypeAdapter(Class<T> baseClass, Class<U> implClass, TypeAdapter<JsonElement> jsonElementAdapter, TypeAdapter<U> implClassAdapter) {
            this.baseClass = baseClass;
            this.implClass = implClass;
            this.label = baseClass.getSimpleName();
            this.jsonElementAdapter = jsonElementAdapter;
            this.implClassAdapter = implClassAdapter;
            if (!baseClass.isAssignableFrom(implClass)) {
                throw new JsonParseException(implClass + " is not a subclass of " + baseClass);
            }
        }

        public T read(JsonReader in) throws IOException {
            JsonElement jsonElement = (JsonElement)this.jsonElementAdapter.read(in);
            return (T)this.implClassAdapter.fromJsonTree(jsonElement);
        }

        public void write(JsonWriter out, T value) throws IOException {
            if (!this.implClass.isInstance(value)) {
                throw new JsonParseException("Unknown concrete type for " + this.baseClass + ". Expected: " + this.implClass + ", actual: " + value.getClass());
            }
            JsonObject jsonObject = this.implClassAdapter.toJsonTree(value).getAsJsonObject();
            JsonObject clone = new JsonObject();
            clone.add(this.label, (JsonElement)new JsonPrimitive(this.label));
            for (Map.Entry e : jsonObject.entrySet()) {
                clone.add((String)e.getKey(), (JsonElement)e.getValue());
            }
            this.jsonElementAdapter.write(out, (Object)clone);
        }
    }
}

