﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/kafka/Kafka_EXPORTS.h>
#include <aws/kafka/model/UserIdentityType.h>

#include <utility>

namespace Aws {
namespace Utils {
namespace Json {
class JsonValue;
class JsonView;
}  // namespace Json
}  // namespace Utils
namespace Kafka {
namespace Model {

/**
 *
          <p>Description of the requester that calls the API operation.</p>

 * <p><h3>See Also:</h3>   <a
 * href="http://docs.aws.amazon.com/goto/WebAPI/kafka-2018-11-14/UserIdentity">AWS
 * API Reference</a></p>
 */
class UserIdentity {
 public:
  AWS_KAFKA_API UserIdentity() = default;
  AWS_KAFKA_API UserIdentity(Aws::Utils::Json::JsonView jsonValue);
  AWS_KAFKA_API UserIdentity& operator=(Aws::Utils::Json::JsonView jsonValue);
  AWS_KAFKA_API Aws::Utils::Json::JsonValue Jsonize() const;

  ///@{
  /**
   *
          <p>The identity type of the requester that calls the API
   * operation.</p>

   */
  inline UserIdentityType GetType() const { return m_type; }
  inline bool TypeHasBeenSet() const { return m_typeHasBeenSet; }
  inline void SetType(UserIdentityType value) {
    m_typeHasBeenSet = true;
    m_type = value;
  }
  inline UserIdentity& WithType(UserIdentityType value) {
    SetType(value);
    return *this;
  }
  ///@}

  ///@{
  /**
   *
          <p>A unique identifier for the requester that calls the API
   * operation.</p>

   */
  inline const Aws::String& GetPrincipalId() const { return m_principalId; }
  inline bool PrincipalIdHasBeenSet() const { return m_principalIdHasBeenSet; }
  template <typename PrincipalIdT = Aws::String>
  void SetPrincipalId(PrincipalIdT&& value) {
    m_principalIdHasBeenSet = true;
    m_principalId = std::forward<PrincipalIdT>(value);
  }
  template <typename PrincipalIdT = Aws::String>
  UserIdentity& WithPrincipalId(PrincipalIdT&& value) {
    SetPrincipalId(std::forward<PrincipalIdT>(value));
    return *this;
  }
  ///@}
 private:
  UserIdentityType m_type{UserIdentityType::NOT_SET};

  Aws::String m_principalId;
  bool m_typeHasBeenSet = false;
  bool m_principalIdHasBeenSet = false;
};

}  // namespace Model
}  // namespace Kafka
}  // namespace Aws
