﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/apigatewayv2/ApiGatewayV2_EXPORTS.h>
#include <aws/apigatewayv2/model/VpcLinkStatus.h>
#include <aws/apigatewayv2/model/VpcLinkVersion.h>
#include <aws/core/utils/DateTime.h>
#include <aws/core/utils/memory/stl/AWSMap.h>
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/core/utils/memory/stl/AWSVector.h>

#include <utility>

namespace Aws {
template <typename RESULT_TYPE>
class AmazonWebServiceResult;

namespace Utils {
namespace Json {
class JsonValue;
}  // namespace Json
}  // namespace Utils
namespace ApiGatewayV2 {
namespace Model {
class CreateVpcLinkResult {
 public:
  AWS_APIGATEWAYV2_API CreateVpcLinkResult() = default;
  AWS_APIGATEWAYV2_API CreateVpcLinkResult(const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);
  AWS_APIGATEWAYV2_API CreateVpcLinkResult& operator=(const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);

  ///@{
  /**
   * <p>The timestamp when the VPC link was created.</p>
   */
  inline const Aws::Utils::DateTime& GetCreatedDate() const { return m_createdDate; }
  template <typename CreatedDateT = Aws::Utils::DateTime>
  void SetCreatedDate(CreatedDateT&& value) {
    m_createdDateHasBeenSet = true;
    m_createdDate = std::forward<CreatedDateT>(value);
  }
  template <typename CreatedDateT = Aws::Utils::DateTime>
  CreateVpcLinkResult& WithCreatedDate(CreatedDateT&& value) {
    SetCreatedDate(std::forward<CreatedDateT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The name of the VPC link.</p>
   */
  inline const Aws::String& GetName() const { return m_name; }
  template <typename NameT = Aws::String>
  void SetName(NameT&& value) {
    m_nameHasBeenSet = true;
    m_name = std::forward<NameT>(value);
  }
  template <typename NameT = Aws::String>
  CreateVpcLinkResult& WithName(NameT&& value) {
    SetName(std::forward<NameT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>A list of security group IDs for the VPC link.</p>
   */
  inline const Aws::Vector<Aws::String>& GetSecurityGroupIds() const { return m_securityGroupIds; }
  template <typename SecurityGroupIdsT = Aws::Vector<Aws::String>>
  void SetSecurityGroupIds(SecurityGroupIdsT&& value) {
    m_securityGroupIdsHasBeenSet = true;
    m_securityGroupIds = std::forward<SecurityGroupIdsT>(value);
  }
  template <typename SecurityGroupIdsT = Aws::Vector<Aws::String>>
  CreateVpcLinkResult& WithSecurityGroupIds(SecurityGroupIdsT&& value) {
    SetSecurityGroupIds(std::forward<SecurityGroupIdsT>(value));
    return *this;
  }
  template <typename SecurityGroupIdsT = Aws::String>
  CreateVpcLinkResult& AddSecurityGroupIds(SecurityGroupIdsT&& value) {
    m_securityGroupIdsHasBeenSet = true;
    m_securityGroupIds.emplace_back(std::forward<SecurityGroupIdsT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>A list of subnet IDs to include in the VPC link.</p>
   */
  inline const Aws::Vector<Aws::String>& GetSubnetIds() const { return m_subnetIds; }
  template <typename SubnetIdsT = Aws::Vector<Aws::String>>
  void SetSubnetIds(SubnetIdsT&& value) {
    m_subnetIdsHasBeenSet = true;
    m_subnetIds = std::forward<SubnetIdsT>(value);
  }
  template <typename SubnetIdsT = Aws::Vector<Aws::String>>
  CreateVpcLinkResult& WithSubnetIds(SubnetIdsT&& value) {
    SetSubnetIds(std::forward<SubnetIdsT>(value));
    return *this;
  }
  template <typename SubnetIdsT = Aws::String>
  CreateVpcLinkResult& AddSubnetIds(SubnetIdsT&& value) {
    m_subnetIdsHasBeenSet = true;
    m_subnetIds.emplace_back(std::forward<SubnetIdsT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>Tags for the VPC link.</p>
   */
  inline const Aws::Map<Aws::String, Aws::String>& GetTags() const { return m_tags; }
  template <typename TagsT = Aws::Map<Aws::String, Aws::String>>
  void SetTags(TagsT&& value) {
    m_tagsHasBeenSet = true;
    m_tags = std::forward<TagsT>(value);
  }
  template <typename TagsT = Aws::Map<Aws::String, Aws::String>>
  CreateVpcLinkResult& WithTags(TagsT&& value) {
    SetTags(std::forward<TagsT>(value));
    return *this;
  }
  template <typename TagsKeyT = Aws::String, typename TagsValueT = Aws::String>
  CreateVpcLinkResult& AddTags(TagsKeyT&& key, TagsValueT&& value) {
    m_tagsHasBeenSet = true;
    m_tags.emplace(std::forward<TagsKeyT>(key), std::forward<TagsValueT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The ID of the VPC link.</p>
   */
  inline const Aws::String& GetVpcLinkId() const { return m_vpcLinkId; }
  template <typename VpcLinkIdT = Aws::String>
  void SetVpcLinkId(VpcLinkIdT&& value) {
    m_vpcLinkIdHasBeenSet = true;
    m_vpcLinkId = std::forward<VpcLinkIdT>(value);
  }
  template <typename VpcLinkIdT = Aws::String>
  CreateVpcLinkResult& WithVpcLinkId(VpcLinkIdT&& value) {
    SetVpcLinkId(std::forward<VpcLinkIdT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The status of the VPC link.</p>
   */
  inline VpcLinkStatus GetVpcLinkStatus() const { return m_vpcLinkStatus; }
  inline void SetVpcLinkStatus(VpcLinkStatus value) {
    m_vpcLinkStatusHasBeenSet = true;
    m_vpcLinkStatus = value;
  }
  inline CreateVpcLinkResult& WithVpcLinkStatus(VpcLinkStatus value) {
    SetVpcLinkStatus(value);
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>A message summarizing the cause of the status of the VPC link.</p>
   */
  inline const Aws::String& GetVpcLinkStatusMessage() const { return m_vpcLinkStatusMessage; }
  template <typename VpcLinkStatusMessageT = Aws::String>
  void SetVpcLinkStatusMessage(VpcLinkStatusMessageT&& value) {
    m_vpcLinkStatusMessageHasBeenSet = true;
    m_vpcLinkStatusMessage = std::forward<VpcLinkStatusMessageT>(value);
  }
  template <typename VpcLinkStatusMessageT = Aws::String>
  CreateVpcLinkResult& WithVpcLinkStatusMessage(VpcLinkStatusMessageT&& value) {
    SetVpcLinkStatusMessage(std::forward<VpcLinkStatusMessageT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The version of the VPC link.</p>
   */
  inline VpcLinkVersion GetVpcLinkVersion() const { return m_vpcLinkVersion; }
  inline void SetVpcLinkVersion(VpcLinkVersion value) {
    m_vpcLinkVersionHasBeenSet = true;
    m_vpcLinkVersion = value;
  }
  inline CreateVpcLinkResult& WithVpcLinkVersion(VpcLinkVersion value) {
    SetVpcLinkVersion(value);
    return *this;
  }
  ///@}

  ///@{

  inline const Aws::String& GetRequestId() const { return m_requestId; }
  template <typename RequestIdT = Aws::String>
  void SetRequestId(RequestIdT&& value) {
    m_requestIdHasBeenSet = true;
    m_requestId = std::forward<RequestIdT>(value);
  }
  template <typename RequestIdT = Aws::String>
  CreateVpcLinkResult& WithRequestId(RequestIdT&& value) {
    SetRequestId(std::forward<RequestIdT>(value));
    return *this;
  }
  ///@}
 private:
  Aws::Utils::DateTime m_createdDate{};

  Aws::String m_name;

  Aws::Vector<Aws::String> m_securityGroupIds;

  Aws::Vector<Aws::String> m_subnetIds;

  Aws::Map<Aws::String, Aws::String> m_tags;

  Aws::String m_vpcLinkId;

  VpcLinkStatus m_vpcLinkStatus{VpcLinkStatus::NOT_SET};

  Aws::String m_vpcLinkStatusMessage;

  VpcLinkVersion m_vpcLinkVersion{VpcLinkVersion::NOT_SET};

  Aws::String m_requestId;
  bool m_createdDateHasBeenSet = false;
  bool m_nameHasBeenSet = false;
  bool m_securityGroupIdsHasBeenSet = false;
  bool m_subnetIdsHasBeenSet = false;
  bool m_tagsHasBeenSet = false;
  bool m_vpcLinkIdHasBeenSet = false;
  bool m_vpcLinkStatusHasBeenSet = false;
  bool m_vpcLinkStatusMessageHasBeenSet = false;
  bool m_vpcLinkVersionHasBeenSet = false;
  bool m_requestIdHasBeenSet = false;
};

}  // namespace Model
}  // namespace ApiGatewayV2
}  // namespace Aws
