/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.velocity;

import java.io.StringWriter;
import java.io.Writer;
import java.util.Map;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.app.Velocity;
import org.apache.velocity.context.Context;
import org.apache.wicket.Component;
import org.apache.wicket.WicketRuntimeException;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.markup.head.HeaderItem;
import org.apache.wicket.markup.head.IHeaderResponse;
import org.apache.wicket.markup.head.StringHeaderItem;
import org.apache.wicket.model.IModel;
import org.apache.wicket.util.lang.Args;
import org.apache.wicket.util.string.Strings;

public class VelocityContributor
extends Behavior {
    private static final long serialVersionUID = 1L;
    private String encoding = "ISO-8859-1";
    private final IModel<? extends Map<?, ?>> model;
    private final String templateName;

    public VelocityContributor(String templateName, IModel<? extends Map<?, ?>> model) {
        Args.notNull(model, (String)"model");
        this.templateName = templateName;
        this.model = model;
    }

    public void detach(Component c) {
        this.model.detach();
    }

    public String getEncoding() {
        return this.encoding;
    }

    public void renderHead(Component component, IHeaderResponse response) {
        CharSequence s = this.evaluate();
        if (null != s) {
            response.render((HeaderItem)StringHeaderItem.forString((CharSequence)s));
        }
    }

    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    protected boolean escapeHtml() {
        return false;
    }

    protected final CharSequence evaluate() {
        if (!Velocity.resourceExists((String)this.templateName)) {
            return null;
        }
        VelocityContext ctx = new VelocityContext((Map)this.model.getObject());
        StringWriter writer = new StringWriter();
        try {
            if (!Velocity.mergeTemplate((String)this.templateName, (String)this.encoding, (Context)ctx, (Writer)writer)) {
                return null;
            }
            CharSequence result = writer.getBuffer();
            if (this.escapeHtml()) {
                result = Strings.escapeMarkup((CharSequence)result.toString());
            }
            return result;
        }
        catch (Exception e) {
            throw new WicketRuntimeException("Error while executing velocity script: " + this.templateName, (Throwable)e);
        }
    }
}

