/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.protocol.ws.javax;

import jakarta.servlet.AsyncContext;
import jakarta.servlet.DispatcherType;
import jakarta.servlet.RequestDispatcher;
import jakarta.servlet.ServletConnection;
import jakarta.servlet.ServletContext;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletInputStream;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.Cookie;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.servlet.http.HttpSession;
import jakarta.servlet.http.HttpUpgradeHandler;
import jakarta.servlet.http.Part;
import jakarta.websocket.EndpointConfig;
import jakarta.websocket.Session;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.security.Principal;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import org.apache.wicket.util.string.StringValue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JavaxUpgradeHttpRequest
implements HttpServletRequest {
    public static final String SESSION = "session";
    public static final String HEADERS = "headers";
    public static final String CONTEXT_PATH = "contextPath";
    private static final Logger log = LoggerFactory.getLogger(JavaxUpgradeHttpRequest.class);
    private final HttpSession httpSession;
    private final String queryString;
    private final Principal userPrincipal;
    private final String requestUri;
    private final Map<String, String[]> parametersMap;
    private final Map<String, List<String>> headers;
    private final String contextPath;
    private final String requestId;

    public JavaxUpgradeHttpRequest(Session session, EndpointConfig endpointConfig) {
        Map userProperties = session.getUserProperties();
        if (userProperties == null || userProperties.isEmpty()) {
            userProperties = endpointConfig.getUserProperties();
        }
        this.httpSession = (HttpSession)userProperties.get(SESSION);
        this.headers = (Map)userProperties.get(HEADERS);
        this.queryString = session.getQueryString();
        this.userPrincipal = session.getUserPrincipal();
        URI requestURI = session.getRequestURI();
        this.requestUri = requestURI != null ? ((Object)requestURI).toString() : "";
        this.contextPath = (String)userProperties.get(CONTEXT_PATH);
        this.parametersMap = new HashMap<String, String[]>();
        Map parameters = session.getRequestParameterMap();
        if (parameters != null) {
            for (Map.Entry entry : parameters.entrySet()) {
                String name = (String)entry.getKey();
                List value = (List)entry.getValue();
                this.parametersMap.put(name, value.toArray(new String[0]));
            }
        }
        this.requestId = UUID.randomUUID().toString();
    }

    public String getAuthType() {
        return null;
    }

    public Cookie[] getCookies() {
        return new Cookie[0];
    }

    public long getDateHeader(String name) {
        String headerValue = this.getHeader(name);
        return StringValue.valueOf((String)headerValue).toLong();
    }

    public String getHeader(String name) {
        List<String> headerValues;
        String value = null;
        if (this.headers != null && (headerValues = this.headers.get(name)) != null && !headerValues.isEmpty()) {
            value = headerValues.get(0);
        }
        return value;
    }

    public Enumeration<String> getHeaders(String name) {
        List<String> headerValues;
        Enumeration<String> values = null;
        if (this.headers != null && (headerValues = this.headers.get(name)) != null && !headerValues.isEmpty()) {
            final Iterator<String> iterator = headerValues.iterator();
            values = new Enumeration<String>(){

                @Override
                public boolean hasMoreElements() {
                    return iterator.hasNext();
                }

                @Override
                public String nextElement() {
                    return (String)iterator.next();
                }
            };
        }
        return values;
    }

    public Enumeration<String> getHeaderNames() {
        Set<String> headerNames;
        Enumeration<String> names = null;
        if (this.headers != null && !(headerNames = this.headers.keySet()).isEmpty()) {
            final Iterator<String> iterator = headerNames.iterator();
            names = new Enumeration<String>(){

                @Override
                public boolean hasMoreElements() {
                    return iterator.hasNext();
                }

                @Override
                public String nextElement() {
                    return (String)iterator.next();
                }
            };
        }
        return names;
    }

    public int getIntHeader(String name) {
        String headerValue = this.getHeader(name);
        return StringValue.valueOf((String)headerValue).toInt();
    }

    public String getMethod() {
        return null;
    }

    public String getPathInfo() {
        return null;
    }

    public String getPathTranslated() {
        return null;
    }

    public String getContextPath() {
        return this.contextPath;
    }

    public String getQueryString() {
        return this.queryString;
    }

    public String getRemoteUser() {
        return null;
    }

    public boolean isUserInRole(String role) {
        return false;
    }

    public Principal getUserPrincipal() {
        return this.userPrincipal;
    }

    public String getRequestedSessionId() {
        return null;
    }

    public String getRequestURI() {
        return this.requestUri;
    }

    public StringBuffer getRequestURL() {
        return new StringBuffer(this.requestUri);
    }

    public String getServletPath() {
        return null;
    }

    public HttpSession getSession(boolean create) {
        return this.httpSession;
    }

    public HttpSession getSession() {
        return this.httpSession;
    }

    public String changeSessionId() {
        return null;
    }

    public boolean isRequestedSessionIdValid() {
        return true;
    }

    public boolean isRequestedSessionIdFromCookie() {
        return true;
    }

    public boolean isRequestedSessionIdFromURL() {
        return false;
    }

    public boolean authenticate(HttpServletResponse response) throws IOException, ServletException {
        return false;
    }

    public void login(String username, String password) throws ServletException {
    }

    public void logout() throws ServletException {
    }

    public Collection<Part> getParts() throws IOException, ServletException {
        return null;
    }

    public Part getPart(String name) throws IOException, ServletException {
        return null;
    }

    public <T extends HttpUpgradeHandler> T upgrade(Class<T> tClass) throws IOException, ServletException {
        return null;
    }

    public Object getAttribute(String name) {
        return null;
    }

    public Enumeration<String> getAttributeNames() {
        return new Enumeration<String>(){

            @Override
            public boolean hasMoreElements() {
                return false;
            }

            @Override
            public String nextElement() {
                return null;
            }
        };
    }

    public String getCharacterEncoding() {
        return null;
    }

    public void setCharacterEncoding(String env) throws UnsupportedEncodingException {
    }

    public int getContentLength() {
        return 0;
    }

    public long getContentLengthLong() {
        return 0L;
    }

    public String getContentType() {
        return null;
    }

    public ServletInputStream getInputStream() throws IOException {
        return null;
    }

    public String getParameter(String name) {
        String[] values = this.parametersMap.get(name);
        return values != null ? values[0] : null;
    }

    public Enumeration<String> getParameterNames() {
        final Iterator<String> iterator = this.parametersMap.keySet().iterator();
        return new Enumeration<String>(){

            @Override
            public boolean hasMoreElements() {
                return iterator.hasNext();
            }

            @Override
            public String nextElement() {
                return (String)iterator.next();
            }
        };
    }

    public String[] getParameterValues(String name) {
        return this.parametersMap.get(name);
    }

    public Map<String, String[]> getParameterMap() {
        return this.parametersMap;
    }

    public String getProtocol() {
        return null;
    }

    public String getScheme() {
        return null;
    }

    public String getServerName() {
        return null;
    }

    public int getServerPort() {
        return 0;
    }

    public BufferedReader getReader() throws IOException {
        return null;
    }

    public String getRemoteAddr() {
        return null;
    }

    public String getRemoteHost() {
        return null;
    }

    public void setAttribute(String name, Object o) {
    }

    public void removeAttribute(String name) {
    }

    public Locale getLocale() {
        return null;
    }

    public Enumeration<Locale> getLocales() {
        return null;
    }

    public boolean isSecure() {
        return false;
    }

    public RequestDispatcher getRequestDispatcher(String path) {
        return null;
    }

    public int getRemotePort() {
        return 0;
    }

    public String getLocalName() {
        return null;
    }

    public String getLocalAddr() {
        return null;
    }

    public int getLocalPort() {
        return 0;
    }

    public ServletContext getServletContext() {
        return null;
    }

    public AsyncContext startAsync() throws IllegalStateException {
        return null;
    }

    public AsyncContext startAsync(ServletRequest servletRequest, ServletResponse servletResponse) throws IllegalStateException {
        return null;
    }

    public boolean isAsyncStarted() {
        return false;
    }

    public boolean isAsyncSupported() {
        return false;
    }

    public AsyncContext getAsyncContext() {
        return null;
    }

    public DispatcherType getDispatcherType() {
        return null;
    }

    public String getRequestId() {
        return this.requestId;
    }

    public String getProtocolRequestId() {
        return null;
    }

    public ServletConnection getServletConnection() {
        return null;
    }
}

