/*
 * Decompiled with CFR 0.152.
 */
package aQute.lib.exceptions;

import aQute.lib.exceptions.Exceptions;
import java.util.function.Consumer;

@FunctionalInterface
public interface ConsumerWithException<T> {
    public void accept(T var1) throws Exception;

    default public Consumer<T> orElseThrow() {
        return t -> {
            try {
                this.accept(t);
            }
            catch (Exception e) {
                throw Exceptions.duck(e);
            }
        };
    }

    default public Consumer<T> ignoreException() {
        return t -> {
            try {
                this.accept(t);
            }
            catch (Exception exception) {
                // empty catch block
            }
        };
    }

    public static <T> Consumer<T> asConsumer(ConsumerWithException<T> unchecked) {
        return unchecked.orElseThrow();
    }

    public static <T> Consumer<T> asConsumerIgnoreException(ConsumerWithException<T> unchecked) {
        return unchecked.ignoreException();
    }
}

