/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.impl;

import java.util.Map;
import java.util.concurrent.CompletableFuture;
import org.apache.camel.AsyncCallback;
import org.apache.camel.AsyncProcessor;
import org.apache.camel.AsyncProducerCallback;
import org.apache.camel.CamelContext;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.ExchangePattern;
import org.apache.camel.FailedToCreateProducerException;
import org.apache.camel.Processor;
import org.apache.camel.Producer;
import org.apache.camel.ProducerCallback;
import org.apache.camel.ServicePoolAware;
import org.apache.camel.impl.AsyncCallbackToCompletableFutureAdapter;
import org.apache.camel.impl.DefaultEndpointUtilizationStatistics;
import org.apache.camel.impl.EventNotifierCallback;
import org.apache.camel.processor.CamelInternalProcessor;
import org.apache.camel.processor.SharedCamelInternalProcessor;
import org.apache.camel.spi.EndpointUtilizationStatistics;
import org.apache.camel.spi.ServicePool;
import org.apache.camel.support.ServiceSupport;
import org.apache.camel.util.AsyncProcessorConverterHelper;
import org.apache.camel.util.CamelContextHelper;
import org.apache.camel.util.EventHelper;
import org.apache.camel.util.LRUCache;
import org.apache.camel.util.LRUCacheFactory;
import org.apache.camel.util.ServiceHelper;
import org.apache.camel.util.StopWatch;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProducerCache
extends ServiceSupport {
    private static final Logger LOG = LoggerFactory.getLogger(ProducerCache.class);
    private final CamelContext camelContext;
    private final ServicePool<Endpoint, Producer> pool;
    private final Map<String, Producer> producers;
    private final Object source;
    private final SharedCamelInternalProcessor internalProcessor;
    private EndpointUtilizationStatistics statistics;
    private boolean eventNotifierEnabled = true;
    private boolean extendedStatistics;
    private int maxCacheSize;
    private boolean stopServicePool;

    public ProducerCache(Object source, CamelContext camelContext) {
        this(source, camelContext, CamelContextHelper.getMaximumCachePoolSize(camelContext));
    }

    public ProducerCache(Object source, CamelContext camelContext, int cacheSize) {
        this(source, camelContext, null, ProducerCache.createLRUCache(cacheSize));
    }

    public ProducerCache(Object source, CamelContext camelContext, Map<String, Producer> cache) {
        this(source, camelContext, null, cache);
    }

    public ProducerCache(Object source, CamelContext camelContext, ServicePool<Endpoint, Producer> producerServicePool, Map<String, Producer> cache) {
        this.source = source;
        this.camelContext = camelContext;
        if (producerServicePool == null) {
            this.pool = camelContext.getProducerServicePool();
            this.stopServicePool = false;
        } else {
            this.pool = producerServicePool;
            this.stopServicePool = true;
        }
        this.producers = cache;
        if (this.producers instanceof LRUCache) {
            this.maxCacheSize = ((LRUCache)this.producers).getMaxCacheSize();
        }
        this.extendedStatistics = camelContext.getManagementStrategy().getManagementAgent() != null ? camelContext.getManagementStrategy().getManagementAgent().getStatisticsLevel().isExtended() : false;
        this.internalProcessor = new SharedCamelInternalProcessor(new CamelInternalProcessor.UnitOfWorkProcessorAdvice(null));
    }

    public boolean isEventNotifierEnabled() {
        return this.eventNotifierEnabled;
    }

    public void setEventNotifierEnabled(boolean eventNotifierEnabled) {
        this.eventNotifierEnabled = eventNotifierEnabled;
    }

    public boolean isExtendedStatistics() {
        return this.extendedStatistics;
    }

    public void setExtendedStatistics(boolean extendedStatistics) {
        this.extendedStatistics = extendedStatistics;
    }

    protected static Map<String, Producer> createLRUCache(int cacheSize) {
        return LRUCacheFactory.newLRUCache(cacheSize);
    }

    public CamelContext getCamelContext() {
        return this.camelContext;
    }

    public Object getSource() {
        return this.source;
    }

    public Producer acquireProducer(Endpoint endpoint) {
        return this.doGetProducer(endpoint, true);
    }

    public void releaseProducer(Endpoint endpoint, Producer producer) throws Exception {
        if (producer instanceof ServicePoolAware) {
            this.pool.release(endpoint, producer);
        } else if (!producer.isSingleton()) {
            ServiceHelper.stopAndShutdownService(producer);
        }
    }

    public void startProducer(Endpoint endpoint) throws Exception {
        Producer producer = this.acquireProducer(endpoint);
        this.releaseProducer(endpoint, producer);
    }

    public void send(Endpoint endpoint, Exchange exchange) {
        this.sendExchange(endpoint, null, null, null, exchange);
    }

    public Exchange send(Endpoint endpoint, Processor processor) {
        return this.sendExchange(endpoint, null, processor, null, null);
    }

    public Exchange send(Endpoint endpoint, ExchangePattern pattern, Processor processor) {
        return this.sendExchange(endpoint, pattern, processor, null, null);
    }

    public Exchange send(Endpoint endpoint, ExchangePattern pattern, Processor processor, Processor resultProcessor) {
        return this.sendExchange(endpoint, pattern, processor, resultProcessor, null);
    }

    public CompletableFuture<Exchange> asyncSend(Endpoint endpoint, ExchangePattern pattern, Processor processor, Processor resultProcessor, CompletableFuture<Exchange> future) {
        return this.asyncSendExchange(endpoint, pattern, processor, resultProcessor, null, future);
    }

    public CompletableFuture<Exchange> asyncSendExchange(Endpoint endpoint, ExchangePattern pattern, Processor processor, Processor resultProcessor, Exchange exchange, CompletableFuture<Exchange> future) {
        AsyncCallbackToCompletableFutureAdapter<Exchange> futureAdapter = new AsyncCallbackToCompletableFutureAdapter<Exchange>(future, exchange);
        this.doInAsyncProducer(endpoint, exchange, pattern, futureAdapter, (producer, asyncProducer, innerExchange, exchangePattern, producerCallback) -> {
            if (innerExchange == null) {
                innerExchange = pattern != null ? producer.getEndpoint().createExchange(pattern) : producer.getEndpoint().createExchange();
                futureAdapter.setResult(innerExchange);
            }
            if (processor != null) {
                AsyncProcessor asyncProcessor = AsyncProcessorConverterHelper.convert(processor);
                try {
                    Exchange finalExchange = innerExchange;
                    asyncProcessor.process(innerExchange, doneSync -> this.asyncDispatchExchange(endpoint, producer, resultProcessor, finalExchange, producerCallback));
                    return false;
                }
                catch (Throwable e) {
                    innerExchange.setException(e);
                    producerCallback.done(true);
                    return true;
                }
            }
            return this.asyncDispatchExchange(endpoint, producer, resultProcessor, innerExchange, producerCallback);
        });
        return futureAdapter.getFuture();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T doInProducer(Endpoint endpoint, Exchange exchange, ExchangePattern pattern, ProducerCallback<T> callback) {
        T answer = null;
        Producer producer = this.doGetProducer(endpoint, true);
        if (producer == null) {
            if (this.isStopped()) {
                LOG.warn("Ignoring exchange sent after processor is stopped: {}", (Object)exchange);
                return null;
            }
            throw new IllegalStateException("No producer, this processor has not been started: " + this);
        }
        try {
            answer = callback.doInProducer(producer, exchange, pattern);
        }
        catch (Throwable e) {
            if (exchange != null) {
                exchange.setException(e);
            }
        }
        finally {
            if (producer instanceof ServicePoolAware) {
                this.pool.release(endpoint, producer);
            } else if (!producer.isSingleton()) {
                try {
                    ServiceHelper.stopAndShutdownService(producer);
                }
                catch (Exception e) {
                    LOG.warn("Error stopping/shutting down producer: {}", (Object)producer, (Object)e);
                }
            }
        }
        return answer;
    }

    public boolean doInAsyncProducer(Endpoint endpoint, Exchange exchange, ExchangePattern pattern, AsyncCallback callback, AsyncProducerCallback producerCallback) {
        Producer target;
        try {
            target = this.doGetProducer(endpoint, true);
            if (target == null) {
                if (this.isStopped()) {
                    LOG.warn("Ignoring exchange sent after processor is stopped: {}", (Object)exchange);
                    callback.done(true);
                    return true;
                }
                exchange.setException(new IllegalStateException("No producer, this processor has not been started: " + this));
                callback.done(true);
                return true;
            }
        }
        catch (Throwable e) {
            exchange.setException(e);
            callback.done(true);
            return true;
        }
        Producer producer = target;
        try {
            boolean sending;
            StopWatch sw = null;
            if (this.eventNotifierEnabled && exchange != null && (sending = EventHelper.notifyExchangeSending(exchange.getContext(), exchange, endpoint))) {
                sw = new StopWatch();
            }
            StopWatch watch = sw;
            AsyncProcessor asyncProcessor = AsyncProcessorConverterHelper.convert(producer);
            return producerCallback.doInAsyncProducer(producer, asyncProcessor, exchange, pattern, (boolean doneSync) -> {
                try {
                    if (this.eventNotifierEnabled && watch != null) {
                        long timeTaken = watch.taken();
                        EventHelper.notifyExchangeSent(exchange.getContext(), exchange, endpoint, timeTaken);
                    }
                    if (producer instanceof ServicePoolAware) {
                        this.pool.release(endpoint, producer);
                    } else if (!producer.isSingleton()) {
                        try {
                            ServiceHelper.stopAndShutdownService(producer);
                        }
                        catch (Exception e) {
                            LOG.warn("Error stopping/shutting down producer: {}", (Object)producer, (Object)e);
                        }
                    }
                }
                finally {
                    callback.done(doneSync);
                }
            });
        }
        catch (Throwable e) {
            if (exchange != null) {
                exchange.setException(e);
            }
            callback.done(true);
            return true;
        }
    }

    protected boolean asyncDispatchExchange(Endpoint endpoint, Producer producer, Processor resultProcessor, Exchange exchange, AsyncCallback callback) {
        LOG.debug(">>>> {} {}", (Object)endpoint, (Object)exchange);
        exchange.setProperty("CamelToEndpoint", endpoint.getEndpointUri());
        try {
            if (this.eventNotifierEnabled) {
                callback = new EventNotifierCallback(callback, exchange, endpoint);
            }
            AsyncProcessor target = this.prepareProducer(producer);
            return this.internalProcessor.process(exchange, callback, target, resultProcessor);
        }
        catch (Throwable e) {
            exchange.setException(e);
            callback.done(true);
            return true;
        }
    }

    protected Exchange sendExchange(final Endpoint endpoint, ExchangePattern pattern, final Processor processor, final Processor resultProcessor, Exchange exchange) {
        return this.doInProducer(endpoint, exchange, pattern, new ProducerCallback<Exchange>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Exchange doInProducer(Producer producer, Exchange exchange, ExchangePattern pattern) {
                if (exchange == null) {
                    Exchange exchange2 = exchange = pattern != null ? producer.getEndpoint().createExchange(pattern) : producer.getEndpoint().createExchange();
                }
                if (processor != null) {
                    try {
                        processor.process(exchange);
                    }
                    catch (Throwable e) {
                        exchange.setException(e);
                        return exchange;
                    }
                }
                LOG.debug(">>>> {} {}", (Object)endpoint, (Object)exchange);
                exchange.setProperty("CamelToEndpoint", endpoint.getEndpointUri());
                StopWatch watch = null;
                try {
                    boolean sending;
                    if (ProducerCache.this.eventNotifierEnabled && (sending = EventHelper.notifyExchangeSending(exchange.getContext(), exchange, endpoint))) {
                        watch = new StopWatch();
                    }
                    AsyncProcessor target = ProducerCache.this.prepareProducer(producer);
                    ProducerCache.this.internalProcessor.process(exchange, target, resultProcessor);
                }
                catch (Throwable e) {
                    exchange.setException(e);
                }
                finally {
                    if (ProducerCache.this.eventNotifierEnabled && watch != null) {
                        long timeTaken = watch.taken();
                        EventHelper.notifyExchangeSent(exchange.getContext(), exchange, endpoint, timeTaken);
                    }
                }
                return exchange;
            }
        });
    }

    protected AsyncProcessor prepareProducer(Producer producer) {
        return AsyncProcessorConverterHelper.convert(producer);
    }

    protected synchronized Producer doGetProducer(Endpoint endpoint, boolean pooled) {
        String key = endpoint.getEndpointUri();
        Producer answer = this.producers.get(key);
        if (pooled && answer == null) {
            answer = this.pool.acquire(endpoint);
        }
        if (answer == null) {
            try {
                boolean add;
                answer = endpoint.createProducer();
                boolean bl = add = answer.isSingleton() || answer instanceof ServicePoolAware;
                if (add) {
                    this.getCamelContext().addService(answer, false);
                } else {
                    ServiceHelper.startService(answer);
                }
            }
            catch (Throwable e) {
                throw new FailedToCreateProducerException(endpoint, e);
            }
            if (pooled && answer instanceof ServicePoolAware) {
                LOG.debug("Adding to producer service pool with key: {} for producer: {}", (Object)endpoint, (Object)answer);
                answer = this.pool.addAndAcquire(endpoint, answer);
            } else if (answer.isSingleton()) {
                LOG.debug("Adding to producer cache with key: {} for producer: {}", (Object)endpoint, (Object)answer);
                this.producers.put(key, answer);
            }
        }
        if (answer != null && this.extendedStatistics) {
            this.statistics.onHit(key);
        }
        return answer;
    }

    @Override
    protected void doStart() throws Exception {
        if (this.extendedStatistics) {
            int max = this.maxCacheSize == 0 ? CamelContextHelper.getMaximumCachePoolSize(this.camelContext) : this.maxCacheSize;
            this.statistics = new DefaultEndpointUtilizationStatistics(max);
        }
        ServiceHelper.startServices(this.producers.values());
        ServiceHelper.startServices(this.statistics, this.pool);
    }

    @Override
    protected void doStop() throws Exception {
        ServiceHelper.stopAndShutdownService(this.statistics);
        if (this.stopServicePool) {
            ServiceHelper.stopAndShutdownService(this.pool);
        }
        try {
            ServiceHelper.stopAndShutdownServices(this.producers.values());
        }
        finally {
            for (Producer producer : this.producers.values()) {
                this.getCamelContext().removeService(producer);
            }
        }
        this.producers.clear();
        if (this.statistics != null) {
            this.statistics.clear();
        }
    }

    public int size() {
        int size = this.producers.size();
        LOG.trace("size = {}", (Object)(size += this.pool.size()));
        return size;
    }

    public int getCapacity() {
        int capacity = -1;
        if (this.producers instanceof LRUCache) {
            LRUCache cache = (LRUCache)this.producers;
            capacity = cache.getMaxCacheSize();
        }
        return capacity;
    }

    public long getHits() {
        long hits = -1L;
        if (this.producers instanceof LRUCache) {
            LRUCache cache = (LRUCache)this.producers;
            hits = cache.getHits();
        }
        return hits;
    }

    public long getMisses() {
        long misses = -1L;
        if (this.producers instanceof LRUCache) {
            LRUCache cache = (LRUCache)this.producers;
            misses = cache.getMisses();
        }
        return misses;
    }

    public long getEvicted() {
        long evicted = -1L;
        if (this.producers instanceof LRUCache) {
            LRUCache cache = (LRUCache)this.producers;
            evicted = cache.getEvicted();
        }
        return evicted;
    }

    public void resetCacheStatistics() {
        if (this.producers instanceof LRUCache) {
            LRUCache cache = (LRUCache)this.producers;
            cache.resetStatistics();
        }
        if (this.statistics != null) {
            this.statistics.clear();
        }
    }

    public synchronized void purge() {
        this.producers.clear();
        this.pool.purge();
        if (this.statistics != null) {
            this.statistics.clear();
        }
    }

    public void cleanUp() {
        if (this.producers instanceof LRUCache) {
            LRUCache cache = (LRUCache)this.producers;
            cache.cleanUp();
        }
    }

    public EndpointUtilizationStatistics getEndpointUtilizationStatistics() {
        return this.statistics;
    }

    public String toString() {
        return "ProducerCache for source: " + this.source + ", capacity: " + this.getCapacity();
    }
}

