/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.cp.internal.datastructures.countdownlatch;

import com.hazelcast.client.impl.protocol.ClientMessage;
import com.hazelcast.client.impl.protocol.codec.CPCountDownLatchAwaitCodec;
import com.hazelcast.client.impl.protocol.codec.CPCountDownLatchCountDownCodec;
import com.hazelcast.client.impl.protocol.codec.CPCountDownLatchGetCountCodec;
import com.hazelcast.client.impl.protocol.codec.CPCountDownLatchGetRoundCodec;
import com.hazelcast.client.impl.protocol.codec.CPCountDownLatchTrySetCountCodec;
import com.hazelcast.client.impl.protocol.codec.CPGroupDestroyCPObjectCodec;
import com.hazelcast.client.spi.ClientContext;
import com.hazelcast.client.spi.ClientProxy;
import com.hazelcast.client.spi.impl.ClientInvocation;
import com.hazelcast.core.ICountDownLatch;
import com.hazelcast.core.OperationTimeoutException;
import com.hazelcast.cp.CPGroupId;
import com.hazelcast.cp.internal.RaftGroupId;
import com.hazelcast.util.EmptyStatement;
import com.hazelcast.util.Preconditions;
import com.hazelcast.util.UuidUtil;
import java.util.UUID;
import java.util.concurrent.TimeUnit;

public class RaftCountDownLatchProxy
extends ClientProxy
implements ICountDownLatch {
    private final RaftGroupId groupId;
    private final String objectName;

    public RaftCountDownLatchProxy(ClientContext context, RaftGroupId groupId, String proxyName, String objectName) {
        super("hz:raft:countDownLatchService", proxyName, context);
        this.groupId = groupId;
        this.objectName = objectName;
    }

    @Override
    public boolean await(long timeout, TimeUnit unit) {
        Preconditions.checkNotNull(unit);
        long timeoutMillis = Math.max(0L, unit.toMillis(timeout));
        ClientMessage request = CPCountDownLatchAwaitCodec.encodeRequest(this.groupId, this.objectName, UuidUtil.newUnsecureUUID(), timeoutMillis);
        ClientMessage response = (ClientMessage)new ClientInvocation(this.getClient(), request, this.name).invoke().join();
        return CPCountDownLatchAwaitCodec.decodeResponse((ClientMessage)response).response;
    }

    @Override
    public void countDown() {
        int round = this.getRound();
        UUID invocationUid = UuidUtil.newUnsecureUUID();
        while (true) {
            try {
                this.countDown(round, invocationUid);
                return;
            }
            catch (OperationTimeoutException e) {
                EmptyStatement.ignore(e);
                continue;
            }
            break;
        }
    }

    private int getRound() {
        ClientMessage request = CPCountDownLatchGetRoundCodec.encodeRequest(this.groupId, this.objectName);
        ClientMessage response = (ClientMessage)new ClientInvocation(this.getClient(), request, this.name).invoke().join();
        return CPCountDownLatchGetRoundCodec.decodeResponse((ClientMessage)response).response;
    }

    private void countDown(int round, UUID invocationUid) {
        ClientMessage request = CPCountDownLatchCountDownCodec.encodeRequest(this.groupId, this.objectName, invocationUid, round);
        new ClientInvocation(this.getClient(), request, this.name).invoke().join();
    }

    @Override
    public int getCount() {
        ClientMessage request = CPCountDownLatchGetCountCodec.encodeRequest(this.groupId, this.objectName);
        ClientMessage response = (ClientMessage)new ClientInvocation(this.getClient(), request, this.name).invoke().join();
        return CPCountDownLatchGetCountCodec.decodeResponse((ClientMessage)response).response;
    }

    @Override
    public boolean trySetCount(int count) {
        ClientMessage request = CPCountDownLatchTrySetCountCodec.encodeRequest(this.groupId, this.objectName, count);
        ClientMessage response = (ClientMessage)new ClientInvocation(this.getClient(), request, this.name).invoke().join();
        return CPCountDownLatchTrySetCountCodec.decodeResponse((ClientMessage)response).response;
    }

    @Override
    public String getPartitionKey() {
        throw new UnsupportedOperationException();
    }

    public CPGroupId getGroupId() {
        return this.groupId;
    }

    @Override
    public void onDestroy() {
        ClientMessage request = CPGroupDestroyCPObjectCodec.encodeRequest(this.groupId, this.getServiceName(), this.objectName);
        new ClientInvocation(this.getClient(), request, this.name).invoke().join();
    }
}

