/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.pax.web.extender.war.internal.extender;

import java.util.concurrent.atomic.AtomicBoolean;
import org.ops4j.pax.web.extender.war.internal.extender.Extension;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class SimpleExtension
implements Extension {
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final Bundle bundle;
    private final BundleContext bundleContext;
    private final AtomicBoolean destroyed = new AtomicBoolean(false);

    public SimpleExtension(Bundle bundle) {
        this.bundle = bundle;
        this.bundleContext = bundle.getBundleContext();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isDestroyed() {
        Object object = this.getLock();
        synchronized (object) {
            return this.destroyed.get();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void start() {
        Object object = this.getLock();
        synchronized (object) {
            if (this.destroyed.get()) {
                return;
            }
            if (this.bundle.getState() != 32) {
                return;
            }
            if (this.bundle.getBundleContext() != this.bundleContext) {
                return;
            }
            try {
                this.doStart();
            }
            catch (Throwable e) {
                this.logger.warn("Error starting extension for bundle " + this.bundle, e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void destroy() {
        Object object = this.getLock();
        synchronized (object) {
            this.destroyed.set(true);
        }
        try {
            this.doDestroy();
        }
        catch (Exception e) {
            this.logger.warn("Error stopping extension for bundle " + this.bundle, (Throwable)e);
        }
    }

    protected Object getLock() {
        return this;
    }

    protected abstract void doStart() throws Exception;

    protected abstract void doDestroy() throws Exception;
}

