/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.features;

import java.util.regex.Pattern;
import org.apache.felix.utils.manifest.Clause;
import org.apache.felix.utils.manifest.Parser;
import org.apache.felix.utils.version.VersionCleaner;
import org.apache.felix.utils.version.VersionRange;
import org.apache.karaf.features.LocationPattern;
import org.osgi.framework.Version;

public class FeaturePattern {
    public static final String RANGE = "range";
    private String originalId;
    private String nameString;
    private Pattern namePattern;
    private String versionString;
    private Version version;
    private VersionRange versionRange;

    public FeaturePattern(String featureId) throws IllegalArgumentException {
        if (featureId == null) {
            throw new IllegalArgumentException("Feature ID to match should not be null");
        }
        this.nameString = this.originalId = featureId;
        if (this.originalId.indexOf("/") > 0) {
            this.nameString = this.originalId.substring(0, this.originalId.indexOf("/"));
            this.versionString = this.originalId.substring(this.originalId.indexOf("/") + 1);
        } else if (this.originalId.contains(";")) {
            Clause[] c = Parser.parseClauses(new String[]{this.originalId});
            this.nameString = c[0].getName();
            this.versionString = c[0].getAttribute(RANGE);
        }
        this.namePattern = LocationPattern.toRegExp(this.nameString);
        if (this.versionString != null && this.versionString.length() >= 1) {
            try {
                char first = this.versionString.charAt(0);
                if (first == '[' || first == '(') {
                    this.versionRange = new VersionRange(this.versionString, true, false);
                }
                this.version = new Version(VersionCleaner.clean(this.versionString));
            }
            catch (IllegalArgumentException e) {
                throw new IllegalArgumentException("Can't parse version \"" + this.versionString + "\" as OSGi version object.", e);
            }
        } else {
            this.versionRange = new VersionRange(Version.emptyVersion);
        }
    }

    public String getOriginalFeatureId() {
        return this.originalId;
    }

    public String getName() {
        return this.nameString;
    }

    public String getVersion() {
        return this.versionString;
    }

    public boolean matches(String featureName, String featureVersion) {
        if (featureName == null) {
            return false;
        }
        boolean match = this.namePattern.matcher(featureName).matches();
        if (!match) {
            return false;
        }
        if (featureVersion == null) {
            featureVersion = "0";
        }
        Version otherVersion = new Version(VersionCleaner.clean(featureVersion));
        if (this.versionRange != null) {
            match = this.versionRange.contains(otherVersion);
        } else if (this.version != null) {
            match = this.version.equals((Object)otherVersion);
        }
        return match;
    }

    public String toString() {
        return this.originalId;
    }
}

