/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.cellar.shell.producer;

import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.karaf.cellar.core.Node;
import org.apache.karaf.cellar.core.command.Command;
import org.apache.karaf.cellar.core.control.ProducerSwitchCommand;
import org.apache.karaf.cellar.core.control.ProducerSwitchResult;
import org.apache.karaf.cellar.core.control.SwitchStatus;
import org.apache.karaf.cellar.shell.ClusterCommandSupport;
import org.apache.karaf.shell.support.table.ShellTable;

public abstract class ProducerSupport
extends ClusterCommandSupport {
    protected Object doExecute(List<String> nodeIdsOrAliases, SwitchStatus status) throws Exception {
        ProducerSwitchCommand command = new ProducerSwitchCommand(this.clusterManager.generateId());
        command.setTimeout(this.timeout * 1000L);
        Set<Node> recipientList = new HashSet<Node>();
        if (nodeIdsOrAliases != null && !nodeIdsOrAliases.isEmpty()) {
            for (String nodeIdOrAlias : nodeIdsOrAliases) {
                Node node = this.clusterManager.findNodeByIdOrAlias(nodeIdOrAlias);
                if (node == null) {
                    System.err.println("Cluster node " + nodeIdOrAlias + " doesn't exist");
                    continue;
                }
                recipientList.add(node);
            }
        } else if (status == null) {
            recipientList = this.clusterManager.listNodes();
        } else {
            recipientList.add(this.clusterManager.getNode());
        }
        if (recipientList.size() < 1) {
            return null;
        }
        command.setDestination(recipientList);
        command.setStatus(status);
        Map results = this.executionContext.execute((Command)command);
        if (results == null || results.isEmpty()) {
            System.out.println("No result received within given timeout");
        } else {
            ShellTable table = new ShellTable();
            table.column(" ");
            table.column("Node");
            table.column("Status");
            for (Node node : results.keySet()) {
                String nodeName;
                String local = "";
                if (node.equals(this.clusterManager.getNode())) {
                    local = "x";
                }
                ProducerSwitchResult result = (ProducerSwitchResult)results.get(node);
                String statusString = "OFF";
                if (result.getStatus().booleanValue()) {
                    statusString = "ON";
                }
                if ((nodeName = node.getAlias()) == null) {
                    nodeName = node.getId();
                }
                table.addRow().addContent(new Object[]{local, nodeName, statusString});
            }
            table.print(System.out);
        }
        return null;
    }
}

