/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.cas.impl;

import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.lang.invoke.MutableCallSite;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import java.util.WeakHashMap;
import java.util.stream.Collectors;
import org.apache.uima.UIMAFramework;
import org.apache.uima.UIMARuntimeException;
import org.apache.uima.cas.CASRuntimeException;
import org.apache.uima.cas.Feature;
import org.apache.uima.cas.Type;
import org.apache.uima.cas.TypeNameSpace;
import org.apache.uima.cas.TypeSystem;
import org.apache.uima.cas.admin.CASAdminException;
import org.apache.uima.cas.admin.TypeSystemMgr;
import org.apache.uima.cas.impl.CASImpl;
import org.apache.uima.cas.impl.CasTypeSystemMapper;
import org.apache.uima.cas.impl.FSClassRegistry;
import org.apache.uima.cas.impl.FeatureImpl;
import org.apache.uima.cas.impl.FeatureImpl_jcas_only;
import org.apache.uima.cas.impl.FsGenerator3;
import org.apache.uima.cas.impl.LowLevelException;
import org.apache.uima.cas.impl.LowLevelTypeSystem;
import org.apache.uima.cas.impl.SlotKinds;
import org.apache.uima.cas.impl.TypeImpl;
import org.apache.uima.cas.impl.TypeImpl_annot;
import org.apache.uima.cas.impl.TypeImpl_annotBase;
import org.apache.uima.cas.impl.TypeImpl_array;
import org.apache.uima.cas.impl.TypeImpl_list;
import org.apache.uima.cas.impl.TypeImpl_primitive;
import org.apache.uima.cas.impl.TypeImpl_string;
import org.apache.uima.cas.impl.TypeImpl_stringSubtype;
import org.apache.uima.cas.impl.TypeNameSpaceImpl;
import org.apache.uima.cas.impl.TypeSystemUtils;
import org.apache.uima.internal.util.Misc;
import org.apache.uima.jcas.JCasRegistry;
import org.apache.uima.jcas.cas.AnnotationBase;
import org.apache.uima.jcas.cas.BooleanArray;
import org.apache.uima.jcas.cas.ByteArray;
import org.apache.uima.jcas.cas.DoubleArray;
import org.apache.uima.jcas.cas.EmptyFSList;
import org.apache.uima.jcas.cas.EmptyFloatList;
import org.apache.uima.jcas.cas.EmptyIntegerList;
import org.apache.uima.jcas.cas.EmptyStringList;
import org.apache.uima.jcas.cas.FSArray;
import org.apache.uima.jcas.cas.FSList;
import org.apache.uima.jcas.cas.FloatArray;
import org.apache.uima.jcas.cas.FloatList;
import org.apache.uima.jcas.cas.IntegerArray;
import org.apache.uima.jcas.cas.IntegerList;
import org.apache.uima.jcas.cas.LongArray;
import org.apache.uima.jcas.cas.NonEmptyFSList;
import org.apache.uima.jcas.cas.NonEmptyFloatList;
import org.apache.uima.jcas.cas.NonEmptyIntegerList;
import org.apache.uima.jcas.cas.NonEmptyStringList;
import org.apache.uima.jcas.cas.ShortArray;
import org.apache.uima.jcas.cas.Sofa;
import org.apache.uima.jcas.cas.StringArray;
import org.apache.uima.jcas.cas.StringList;
import org.apache.uima.jcas.cas.TOP;
import org.apache.uima.jcas.tcas.Annotation;
import org.apache.uima.util.Logger;
import org.apache.uima.util.impl.Constants;

public class TypeSystemImpl
implements TypeSystem,
TypeSystemMgr,
LowLevelTypeSystem {
    private static final boolean IS_TRACE_JCAS_EXPAND = false;
    private final boolean debug = false;
    public static final String DISABLE_TYPESYSTEM_CONSOLIDATION = "uima.disable_typesystem_consolidation";
    public static final String ENABLE_STRICT_TYPE_SOURCE_CHECK = "uima.enable_strict_type_source_check";
    public static final boolean IS_DISABLE_TYPESYSTEM_CONSOLIDATION = Misc.getNoValueSystemProperty("uima.disable_typesystem_consolidation");
    public static final boolean IS_ENABLE_STRICT_TYPE_SOURCE_CHECK = Misc.getNoValueSystemProperty("uima.enable_strict_type_source_check");
    private static final MethodHandle MHC_MINUS_1 = MethodHandles.constant(Integer.TYPE, -1);
    static final int UNKNOWN_TYPE_CODE = 0;
    private static final int LEAST_TYPE_CODE = 1;
    private static final int LEAST_FEATURE_CODE = 1;
    static final String ARRAY_TYPE_SUFFIX = "[]";
    private static final boolean HEAP_STORED_ARRAY = true;
    private static final int INIT_SIZE_ARRAYS_BUILT_IN_TYPES = 64;
    private static final Map<String, String> builtInArrayComponentName2ArrayTypeName = new HashMap<String, String>(9);
    private static final Map<String, SlotKinds.SlotKind> slotKindsForNonArrays;
    private static final Map<TypeSystemImpl, WeakReference<TypeSystemImpl>> committedTypeSystems;
    private final Map<String, TypeImpl> arrayName2ComponentType = new HashMap<String, TypeImpl>(9);
    final TypeImpl topType;
    public final TypeImpl intType;
    public final TypeImpl stringType;
    public final TypeImpl floatType;
    final TypeImpl arrayBaseType;
    final TypeImpl_array intArrayType;
    final TypeImpl_array floatArrayType;
    final TypeImpl_array stringArrayType;
    final TypeImpl_array fsArrayType;
    final TypeImpl_array topArrayType;
    public final TypeImpl sofaType;
    public final TypeImpl annotType;
    public final TypeImpl annotBaseType;
    public final TypeImpl docType;
    public final TypeImpl byteType;
    final TypeImpl_array byteArrayType;
    public final TypeImpl booleanType;
    final TypeImpl_array booleanArrayType;
    public final TypeImpl shortType;
    final TypeImpl_array shortArrayType;
    public final TypeImpl longType;
    final TypeImpl_array longArrayType;
    public final TypeImpl doubleType;
    final TypeImpl_array doubleArrayType;
    final TypeImpl listBaseType;
    public final TypeImpl_list intListType;
    public final TypeImpl_list floatListType;
    public final TypeImpl_list stringListType;
    public final TypeImpl_list fsListType;
    public final TypeImpl_list intEListType;
    public final TypeImpl_list floatEListType;
    public final TypeImpl_list stringEListType;
    public final TypeImpl_list fsEListType;
    public final TypeImpl_list intNeListType;
    public final TypeImpl_list floatNeListType;
    public final TypeImpl_list stringNeListType;
    public final TypeImpl_list fsNeListType;
    final Map<String, TypeImpl> typeName2TypeImpl = new HashMap<String, TypeImpl>(64);
    private Map<Type, Type> arrayComponentTypeToArrayType = new IdentityHashMap<Type, Type>();
    final List<TypeImpl> types = new ArrayList<TypeImpl>(64);
    private final List<TypeImpl> jcasRegisteredTypes;
    final List<FeatureImpl> features;
    private boolean locked;
    volatile boolean areBuiltInTypesSetup;
    FeatureImpl startFeat;
    FeatureImpl endFeat;
    FeatureImpl langFeat;
    FeatureImpl sofaNum;
    FeatureImpl sofaId;
    FeatureImpl sofaMime;
    FeatureImpl sofaArray;
    FeatureImpl sofaString;
    FeatureImpl sofaUri;
    FeatureImpl annotBaseSofaFeat;
    private final Map<ClassLoader, FsGenerator3[]> generatorsByClassLoader;
    private final Map<ClassLoader, FsGenerator3[]> generators4pearsByClassLoader;
    private int nextI;
    private int nextR;
    private Map<String, FSClassRegistry.JCasClassInfo> type2jcci;
    private MethodHandles.Lookup lookup;
    private ClassLoader cl_for_commit;
    private boolean skip_loading_user_jcas;
    public final Map<TypeSystemImpl, CasTypeSystemMapper> typeSystemMappers;
    public static final TypeSystemImpl staticTsi;

    public TypeSystemImpl() {
        this.types.add(null);
        this.jcasRegisteredTypes = new ArrayList<TypeImpl>(64);
        this.features = new ArrayList<FeatureImpl>(64);
        this.features.add(null);
        this.locked = false;
        this.areBuiltInTypesSetup = false;
        this.generatorsByClassLoader = new IdentityHashMap<ClassLoader, FsGenerator3[]>();
        this.generators4pearsByClassLoader = new IdentityHashMap<ClassLoader, FsGenerator3[]>();
        this.skip_loading_user_jcas = false;
        this.typeSystemMappers = new WeakHashMap<TypeSystemImpl, CasTypeSystemMapper>();
        this.topType = new TypeImpl("uima.cas.TOP", this, null, TOP.class);
        this.intType = new TypeImpl_primitive("uima.cas.Integer", this, this.topType, Integer.TYPE);
        this.floatType = new TypeImpl_primitive("uima.cas.Float", this, this.topType, Float.TYPE);
        this.stringType = new TypeImpl_string("uima.cas.String", this, this.topType, String.class);
        this.arrayBaseType = new TypeImpl("uima.cas.ArrayBase", this, this.topType);
        this.topArrayType = this.fsArrayType = this.addArrayType(this.topType, SlotKinds.SlotKind.Slot_HeapRef, true, FSArray.class);
        this.floatArrayType = this.addArrayType(this.floatType, SlotKinds.SlotKind.Slot_Float, true, FloatArray.class);
        this.intArrayType = this.addArrayType(this.intType, SlotKinds.SlotKind.Slot_Int, true, IntegerArray.class);
        this.stringArrayType = this.addArrayType(this.stringType, SlotKinds.SlotKind.Slot_StrRef, true, StringArray.class);
        this.listBaseType = new TypeImpl("uima.cas.ListBase", this, this.topType);
        this.fsListType = new TypeImpl_list("uima.cas.FSList", this.topType, this, this.listBaseType, FSList.class);
        this.fsEListType = new TypeImpl_list("uima.cas.EmptyFSList", this.topType, this, this.fsListType, EmptyFSList.class);
        this.fsNeListType = new TypeImpl_list("uima.cas.NonEmptyFSList", this.topType, this, this.fsListType, NonEmptyFSList.class);
        this.addFeature("tail", this.fsNeListType, this.fsListType, true);
        this.addFeature("head", this.fsNeListType, this.topType, true);
        this.floatListType = new TypeImpl_list("uima.cas.FloatList", this.floatType, this, this.listBaseType, FloatList.class);
        this.floatEListType = new TypeImpl_list("uima.cas.EmptyFloatList", this.floatType, this, this.floatListType, EmptyFloatList.class);
        this.floatNeListType = new TypeImpl_list("uima.cas.NonEmptyFloatList", this.floatType, this, this.floatListType, NonEmptyFloatList.class);
        this.addFeature("tail", this.floatNeListType, this.floatListType, true);
        this.addFeature("head", this.floatNeListType, this.floatType, false);
        this.intListType = new TypeImpl_list("uima.cas.IntegerList", this.intType, this, this.listBaseType, IntegerList.class);
        this.intEListType = new TypeImpl_list("uima.cas.EmptyIntegerList", this.intType, this, this.intListType, EmptyIntegerList.class);
        this.intNeListType = new TypeImpl_list("uima.cas.NonEmptyIntegerList", this.intType, this, this.intListType, NonEmptyIntegerList.class);
        this.addFeature("tail", this.intNeListType, this.intListType, true);
        this.addFeature("head", this.intNeListType, this.intType, false);
        this.stringListType = new TypeImpl_list("uima.cas.StringList", this.stringType, this, this.listBaseType, StringList.class);
        this.stringEListType = new TypeImpl_list("uima.cas.EmptyStringList", this.stringType, this, this.stringListType, EmptyStringList.class);
        this.stringNeListType = new TypeImpl_list("uima.cas.NonEmptyStringList", this.stringType, this, this.stringListType, NonEmptyStringList.class);
        this.addFeature("tail", this.stringNeListType, this.stringListType, true);
        this.addFeature("head", this.stringNeListType, this.stringType, false);
        this.booleanType = new TypeImpl_primitive("uima.cas.Boolean", this, this.topType, Boolean.TYPE);
        this.byteType = new TypeImpl_primitive("uima.cas.Byte", this, this.topType, Byte.TYPE);
        this.shortType = new TypeImpl_primitive("uima.cas.Short", this, this.topType, Short.TYPE);
        this.longType = new TypeImpl_primitive("uima.cas.Long", this, this.topType, Long.TYPE);
        this.doubleType = new TypeImpl_primitive("uima.cas.Double", this, this.topType, Double.TYPE);
        this.booleanArrayType = this.addArrayType(this.booleanType, SlotKinds.SlotKind.Slot_BooleanRef, false, BooleanArray.class);
        this.byteArrayType = this.addArrayType(this.byteType, SlotKinds.SlotKind.Slot_ByteRef, false, ByteArray.class);
        this.shortArrayType = this.addArrayType(this.shortType, SlotKinds.SlotKind.Slot_ShortRef, false, ShortArray.class);
        this.longArrayType = this.addArrayType(this.longType, SlotKinds.SlotKind.Slot_LongRef, false, LongArray.class);
        this.doubleArrayType = this.addArrayType(this.doubleType, SlotKinds.SlotKind.Slot_DoubleRef, false, DoubleArray.class);
        this.sofaType = new TypeImpl("uima.cas.Sofa", this, this.topType, Sofa.class);
        this.sofaNum = (FeatureImpl)this.addFeature("sofaNum", this.sofaType, this.intType, false);
        this.sofaId = (FeatureImpl)this.addFeature("sofaID", this.sofaType, this.stringType, false);
        this.sofaMime = (FeatureImpl)this.addFeature("mimeType", this.sofaType, this.stringType, false);
        this.sofaArray = (FeatureImpl)this.addFeature("sofaArray", this.sofaType, this.topType, true);
        this.sofaString = (FeatureImpl)this.addFeature("sofaString", this.sofaType, this.stringType, false);
        this.sofaUri = (FeatureImpl)this.addFeature("sofaURI", this.sofaType, this.stringType, false);
        this.annotBaseType = new TypeImpl_annotBase("uima.cas.AnnotationBase", this, this.topType, AnnotationBase.class);
        this.annotBaseSofaFeat = (FeatureImpl)this.addFeature("sofa", this.annotBaseType, this.sofaType, false);
        this.annotType = new TypeImpl_annot("uima.tcas.Annotation", this, this.annotBaseType, Annotation.class);
        this.startFeat = (FeatureImpl)this.addFeature("begin", this.annotType, this.intType, false);
        this.endFeat = (FeatureImpl)this.addFeature("end", this.annotType, this.intType, false);
        this.docType = new TypeImpl_annot("uima.tcas.DocumentAnnotation", this, this.annotType, Annotation.class);
        this.langFeat = (FeatureImpl)this.addFeature("language", this.docType, this.stringType, false);
        this.arrayName2ComponentType.put("uima.cas.FSArray", this.topType);
        this.arrayName2ComponentType.put("uima.cas.BooleanArray", this.booleanType);
        this.arrayName2ComponentType.put("uima.cas.ByteArray", this.byteType);
        this.arrayName2ComponentType.put("uima.cas.ShortArray", this.shortType);
        this.arrayName2ComponentType.put("uima.cas.IntegerArray", this.intType);
        this.arrayName2ComponentType.put("uima.cas.FloatArray", this.floatType);
        this.arrayName2ComponentType.put("uima.cas.LongArray", this.longType);
        this.arrayName2ComponentType.put("uima.cas.DoubleArray", this.doubleType);
        this.arrayName2ComponentType.put("uima.cas.StringArray", this.stringType);
        TypeSystemImpl.setTypeFinal(this.intType);
        TypeSystemImpl.setTypeFinal(this.floatType);
        TypeSystemImpl.setTypeFinal(this.stringType);
        this.topType.setFeatureFinal();
        TypeSystemImpl.setTypeFinal(this.arrayBaseType);
        TypeSystemImpl.setTypeFinal(this.fsArrayType);
        TypeSystemImpl.setTypeFinal(this.intArrayType);
        TypeSystemImpl.setTypeFinal(this.floatArrayType);
        TypeSystemImpl.setTypeFinal(this.stringArrayType);
        TypeSystemImpl.setTypeFinal(this.sofaType);
        TypeSystemImpl.setTypeFinal(this.byteType);
        TypeSystemImpl.setTypeFinal(this.booleanType);
        TypeSystemImpl.setTypeFinal(this.shortType);
        TypeSystemImpl.setTypeFinal(this.longType);
        TypeSystemImpl.setTypeFinal(this.doubleType);
        TypeSystemImpl.setTypeFinal(this.booleanArrayType);
        TypeSystemImpl.setTypeFinal(this.byteArrayType);
        TypeSystemImpl.setTypeFinal(this.shortArrayType);
        TypeSystemImpl.setTypeFinal(this.longArrayType);
        TypeSystemImpl.setTypeFinal(this.doubleArrayType);
        TypeSystemImpl.setTypeFinal(this.fsListType);
        TypeSystemImpl.setTypeFinal(this.floatListType);
        TypeSystemImpl.setTypeFinal(this.stringListType);
        TypeSystemImpl.setTypeFinal(this.intListType);
        TypeSystemImpl.setTypeFinal(this.fsEListType);
        TypeSystemImpl.setTypeFinal(this.floatEListType);
        TypeSystemImpl.setTypeFinal(this.stringEListType);
        TypeSystemImpl.setTypeFinal(this.intEListType);
        TypeSystemImpl.setTypeFinal(this.fsNeListType);
        TypeSystemImpl.setTypeFinal(this.floatNeListType);
        TypeSystemImpl.setTypeFinal(this.stringNeListType);
        TypeSystemImpl.setTypeFinal(this.intNeListType);
        this.topType.setBuiltIn();
        this.listBaseType.setBuiltIn();
        this.fsListType.setBuiltIn();
        this.fsEListType.setBuiltIn();
        this.fsNeListType.setBuiltIn();
        this.floatListType.setBuiltIn();
        this.floatEListType.setBuiltIn();
        this.floatNeListType.setBuiltIn();
        this.intListType.setBuiltIn();
        this.intEListType.setBuiltIn();
        this.intNeListType.setBuiltIn();
        this.stringListType.setBuiltIn();
        this.stringEListType.setBuiltIn();
        this.stringNeListType.setBuiltIn();
        this.annotType.setBuiltIn();
        this.annotBaseType.setBuiltIn();
        this.listBaseType.setFeatureFinal();
        this.fsListType.setFeatureFinal();
        this.fsEListType.setFeatureFinal();
        this.fsNeListType.setFeatureFinal();
        this.floatListType.setFeatureFinal();
        this.floatEListType.setFeatureFinal();
        this.floatNeListType.setFeatureFinal();
        this.intListType.setFeatureFinal();
        this.intEListType.setFeatureFinal();
        this.intNeListType.setFeatureFinal();
        this.stringListType.setFeatureFinal();
        this.stringEListType.setFeatureFinal();
        this.stringNeListType.setFeatureFinal();
        this.annotType.setFeatureFinal();
        this.annotBaseType.setFeatureFinal();
    }

    final int getSmallestType() {
        return 1;
    }

    final int getSmallestFeature() {
        return 1;
    }

    public final int getTypeArraySize() {
        return this.types.size();
    }

    public Vector<Feature> getIntroFeatures(Type type) {
        Vector<Feature> feats = new Vector<Feature>();
        List<Feature> appropFeats = type.getFeatures();
        int max = appropFeats.size();
        for (int i = 0; i < max; ++i) {
            Feature feat = appropFeats.get(i);
            if (feat.getDomain() != type) continue;
            feats.add(feat);
        }
        return feats;
    }

    @Override
    public Type getParent(Type t) {
        return ((TypeImpl)t).getSuperType();
    }

    public final int getLargestTypeCode() {
        return this.getNumberOfTypes();
    }

    public boolean isType(int typecode) {
        return typecode >= 1 && typecode <= this.getLargestTypeCode();
    }

    @Override
    public TypeImpl getType(String typeName) {
        return this.typeName2TypeImpl.get(typeName);
    }

    @Override
    public FeatureImpl getFeatureByFullName(String featureName) {
        int split = featureName.indexOf(58);
        return this.getFeature(featureName.substring(0, split), featureName.substring(split + 1));
    }

    private static final String getArrayTypeName(String typeName) {
        String arrayTypeName = builtInArrayComponentName2ArrayTypeName.get(typeName);
        return null == arrayTypeName ? typeName + ARRAY_TYPE_SUFFIX : arrayTypeName;
    }

    static final String getArrayComponentName(String arrayTypeName) {
        return arrayTypeName.substring(0, arrayTypeName.length() - 2);
    }

    static boolean isArrayTypeNameButNotBuiltIn(String typeName) {
        return typeName.endsWith(ARRAY_TYPE_SUFFIX);
    }

    void newTypeChecks(String typeName, Type superType) {
        if (typeName.endsWith(ARRAY_TYPE_SUFFIX)) {
            this.checkTypeSyntax(typeName.substring(0, typeName.length() - 2));
        } else {
            if (this.locked) {
                throw new CASAdminException("TYPE_SYSTEM_LOCKED", new Object[0]);
            }
            if (superType != null && superType.isInheritanceFinal()) {
                throw new CASAdminException("TYPE_IS_INH_FINAL", superType);
            }
            this.checkTypeSyntax(typeName);
        }
    }

    void newTypeCheckNoInheritanceFinalCheck(String typeName, Type superType) {
        if (this.locked) {
            throw new CASAdminException("TYPE_SYSTEM_LOCKED", new Object[0]);
        }
        this.checkTypeSyntax(typeName);
    }

    private void checkTypeSyntax(String typeName) throws CASAdminException {
        if (!TypeSystemUtils.isTypeName(typeName)) {
            throw new CASAdminException("BAD_TYPE_SYNTAX", typeName);
        }
    }

    @Override
    public TypeImpl addType(String typeName, Type superType) throws CASAdminException {
        this.newTypeChecks(typeName, superType);
        if (null != this.typeName2TypeImpl.get(typeName)) {
            return null;
        }
        TypeImpl supertypeimpl = (TypeImpl)superType;
        TypeImpl ti = supertypeimpl.isAnnotationType() ? new TypeImpl_annot(typeName, this, supertypeimpl, Annotation.class) : (supertypeimpl.isAnnotationBaseType() ? new TypeImpl_annotBase(typeName, this, supertypeimpl, AnnotationBase.class) : new TypeImpl(typeName, this, supertypeimpl));
        return ti;
    }

    public boolean isInInt(Type rangeType) {
        return rangeType == null ? false : rangeType.isPrimitive() && !this.subsumes(this.stringType, rangeType);
    }

    @Override
    public Feature addFeature(String featureName, Type domainType, Type rangeType) throws CASAdminException {
        return this.addFeature(featureName, domainType, rangeType, true);
    }

    @Override
    public Feature addFeature(String shortFeatName, Type domainType, Type rangeType, boolean multipleReferencesAllowed) throws CASAdminException {
        if (this.locked) {
            throw new CASAdminException("TYPE_SYSTEM_LOCKED", new Object[0]);
        }
        FeatureImpl existingFeature = this.getFeature(domainType, shortFeatName);
        if (existingFeature != null) {
            ((TypeImpl)domainType).checkExistingFeatureCompatible(existingFeature, rangeType);
            TypeImpl highestDefiningType = existingFeature.getHighestDefiningType();
            if (highestDefiningType != domainType && this.subsumes(domainType, highestDefiningType)) {
                Misc.internalError();
            }
            return existingFeature;
        }
        if (domainType.isFeatureFinal()) {
            throw new CASAdminException("TYPE_IS_FEATURE_FINAL", domainType.getName());
        }
        if (!TypeSystemUtils.isIdentifier(shortFeatName)) {
            throw new CASAdminException("BAD_FEATURE_SYNTAX", shortFeatName);
        }
        return new FeatureImpl((TypeImpl)domainType, shortFeatName, (TypeImpl)rangeType, this, multipleReferencesAllowed, TypeSystemImpl.getSlotKindFromType(rangeType));
    }

    static SlotKinds.SlotKind getSlotKindFromType(Type rangeType) {
        SlotKinds.SlotKind slotKind = rangeType.isStringOrStringSubtype() ? SlotKinds.SlotKind.Slot_StrRef : slotKindsForNonArrays.get(rangeType.getName());
        return null == slotKind ? SlotKinds.SlotKind.Slot_HeapRef : slotKind;
    }

    @Override
    public Iterator<Type> getTypeIterator() {
        Iterator<Type> it = Collections.unmodifiableList(this.types).iterator();
        it.next();
        return it;
    }

    @Override
    public TypeImpl getTopType() {
        return this.topType;
    }

    public TypeImpl getTopTypeImpl() {
        return this.topType;
    }

    @Override
    public List<Type> getProperlySubsumedTypes(Type type) {
        return ((TypeImpl)type).getAllSubtypes().collect(Collectors.toList());
    }

    @Override
    public Vector<Type> getDirectlySubsumedTypes(Type type) {
        return new Vector<Type>(this.getDirectSubtypes(type));
    }

    @Override
    public List<Type> getDirectSubtypes(Type type) {
        TypeImpl ti = (TypeImpl)type;
        return Collections.unmodifiableList(ti.getDirectSubtypes());
    }

    public boolean directlySubsumes(TypeImpl t1, TypeImpl t2) {
        return t1.getDirectSubtypes().contains(t2);
    }

    @Override
    public boolean subsumes(Type superType, Type subType) {
        if (superType == subType) {
            return true;
        }
        if (this.isCommitted()) {
            return ((TypeImpl)superType).subsumes((TypeImpl)subType);
        }
        if (superType.isArray()) {
            return ((TypeImpl_array)superType).subsumes((TypeImpl)subType);
        }
        if (subType == this.fsArrayType) {
            return superType == this.topType || superType == this.arrayBaseType;
        }
        if (subType.isArray()) {
            return superType == this.topType || superType == this.arrayBaseType;
        }
        return ((TypeImpl)subType).hasSupertype((TypeImpl)superType);
    }

    public int getNumberOfTypes() {
        return this.types.size() - 1;
    }

    public int getNumberOfFeatures() {
        return this.features.size() - 1;
    }

    public int unify(int t1, int t2) {
        if (this.subsumes(t1, t2)) {
            return t2;
        }
        if (this.subsumes(t2, t1)) {
            return t1;
        }
        return -1;
    }

    public boolean subsumes(int superType, int type) {
        return this.ll_subsumes(superType, type);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(String.format("Type System <%,d>:%n", System.identityHashCode(this)));
        this.topType.prettyPrintWithSubTypes(sb, 2);
        return sb.toString();
    }

    @Override
    public TypeSystemImpl commit() {
        return this.commit(this.getClass().getClassLoader());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TypeSystemImpl commit(ClassLoader cl) {
        TypeSystemImpl typeSystemImpl = this;
        synchronized (typeSystemImpl) {
            if (this.locked) {
                this.getGeneratorsForClassLoader(cl, false);
                return this;
            }
            TypeSystemImpl maybeConsolidatedTypesystem = IS_DISABLE_TYPESYSTEM_CONSOLIDATION ? this.finalizeCommit(cl) : (TypeSystemImpl)committedTypeSystems.computeIfAbsent(this, _key -> new WeakReference<TypeSystemImpl>(this.finalizeCommit(cl))).get();
            maybeConsolidatedTypesystem.getGeneratorsForClassLoader(cl, false);
            return maybeConsolidatedTypesystem;
        }
    }

    private TypeSystemImpl finalizeCommit(ClassLoader cl) {
        this.topType.computeDepthFirstCode(1);
        this.computeFeatureOffsets(this.topType, 0);
        this.type2jcci = FSClassRegistry.get_className_to_jcci(cl, false);
        this.lookup = FSClassRegistry.getLookup(cl);
        this.cl_for_commit = cl;
        this.computeAdjustedFeatureOffsets(this.topType);
        this.locked = true;
        return this;
    }

    private void computeAdjustedFeatureOffsets(TypeImpl ti) {
        FSClassRegistry.JCasClassInfo jcci;
        ArrayList<FeatureImpl> tempIntFis = new ArrayList<FeatureImpl>();
        ArrayList<FeatureImpl> tempRefFis = new ArrayList<FeatureImpl>();
        ArrayList<FeatureImpl> tempNsr = new ArrayList<FeatureImpl>();
        if (ti != this.topType) {
            ti.initAdjOffset2FeatureMaps(tempIntFis, tempRefFis, tempNsr);
            this.nextI = ti.getSuperType().nbrOfUsedIntDataSlots;
            this.nextR = ti.getSuperType().nbrOfUsedRefDataSlots;
        } else {
            this.nextI = 0;
            this.nextR = 0;
        }
        if (!this.skip_loading_user_jcas && (jcci = this.getOrCreateJcci(ti)) != null) {
            this.addJCasOffsetsWithSupers(jcci.jcasClass, tempIntFis, tempRefFis, tempNsr);
        }
        for (FeatureImpl fi : ti.getMergedStaticFeaturesIntroducedByThisType()) {
            if (fi.getAdjustedOffset() != -1) continue;
            this.setFeatureAdjustedOffset(fi, tempIntFis, tempRefFis, tempNsr);
        }
        ti.nbrOfUsedIntDataSlots = this.nextI;
        ti.nbrOfUsedRefDataSlots = this.nextR;
        ti.setStaticMergedIntFeaturesList(tempIntFis.size() == 0 ? Constants.EMPTY_FEATURE_ARRAY : tempIntFis.toArray(new FeatureImpl[tempIntFis.size()]));
        ti.setStaticMergedRefFeaturesList(tempRefFis.size() == 0 ? Constants.EMPTY_FEATURE_ARRAY : tempRefFis.toArray(new FeatureImpl[tempRefFis.size()]));
        ti.setStaticMergedNonSofaFsRefs(tempNsr.size() == 0 ? Constants.EMPTY_FEATURE_ARRAY : tempNsr.toArray(new FeatureImpl[tempNsr.size()]));
        for (TypeImpl sub : ti.getDirectSubtypes()) {
            this.computeAdjustedFeatureOffsets(sub);
        }
    }

    private void addJCasOffsetsWithSupers(Class<?> clazz, List<FeatureImpl> tempIntFis, List<FeatureImpl> tempRefFis, List<FeatureImpl> tempNsrFis) {
        Class<?> superClass = clazz.getSuperclass();
        if (superClass == Object.class) {
            return;
        }
        String superClassName = superClass.getName();
        String uimaSuperTypeName = Misc.javaClassName2UimaTypeName(superClassName);
        if (this.getType(uimaSuperTypeName) != null) {
            String className = clazz.getName();
            String uimaTypeName = Misc.javaClassName2UimaTypeName(className);
            TypeImpl ti = this.getType(uimaTypeName);
            if (ti != null) {
                this.maybeAddJCasOffsets(ti, tempIntFis, tempRefFis, tempNsrFis);
            }
            return;
        }
        this.addJCasOffsetsWithSupers(superClass, tempIntFis, tempRefFis, tempNsrFis);
    }

    private void maybeAddJCasOffsets(TypeImpl ti, List<FeatureImpl> tempIntFis, List<FeatureImpl> tempRefFis, List<FeatureImpl> tempNsrFis) {
        FSClassRegistry.JCasClassInfo jcci = this.getOrCreateJcci(ti);
        if (null != jcci) {
            this.addJCasOffsets(jcci, tempIntFis, tempRefFis, tempNsrFis);
        }
    }

    private void addJCasOffsets(FSClassRegistry.JCasClassInfo jcci, List<FeatureImpl> tempIntFis, List<FeatureImpl> tempRefFis, List<FeatureImpl> tempNsrFis) {
        Object added = null;
        for (FSClassRegistry.JCasClassFeatureInfo jcci_feat : jcci.features) {
            TypeImpl rangeType = this.getType(jcci_feat.uimaRangeName);
            TypeImpl ti = jcci.getUimaType(this);
            FeatureImpl fi = null;
            if (ti != null) {
                fi = ti.getFeatureByBaseName(jcci_feat.shortName);
            }
            if (fi == null) {
                fi = new FeatureImpl_jcas_only(jcci_feat.shortName, rangeType);
            }
            if (fi.getAdjustedOffset() != -1) continue;
            this.setFeatureAdjustedOffset(fi, tempIntFis, tempRefFis, tempNsrFis);
        }
    }

    void setFeatureAdjustedOffset(FeatureImpl fi, List<FeatureImpl> tempIntFis, List<FeatureImpl> tempRefFis, List<FeatureImpl> tempNsr) {
        int n;
        boolean isInt = fi.isInInt;
        fi.setAdjustedOffset(isInt ? this.nextI : this.nextR);
        if (isInt) {
            int n2 = this.nextI;
            n = n2;
            this.nextI = n2 + 1;
        } else {
            int n3 = this.nextR;
            n = n3;
            this.nextR = n3 + 1;
        }
        this.setOffset2Feat(tempIntFis, tempRefFis, tempNsr, fi, n);
        if (fi.isLongOrDouble) {
            ++this.nextI;
        }
    }

    void setOffset2Feat(List<FeatureImpl> tempIntFis, List<FeatureImpl> tempRefFis, List<FeatureImpl> tempNsr, FeatureImpl fi, int next) {
        boolean is_jcas_only = fi instanceof FeatureImpl_jcas_only;
        if (fi.isInInt) {
            tempIntFis.add(is_jcas_only ? null : fi);
            if (fi.getRangeImpl().isLongOrDouble) {
                tempIntFis.add(null);
            }
        } else {
            tempRefFis.add(is_jcas_only ? null : fi);
            TypeImpl range = fi.getRangeImpl();
            if (!is_jcas_only && range.isRefType && range != this.sofaType) {
                tempNsr.add(fi);
            }
        }
    }

    private FSClassRegistry.JCasClassInfo getOrCreateJcci(TypeImpl ti) {
        return FSClassRegistry.getOrCreateJCasClassInfo(ti, this.cl_for_commit, this.type2jcci, this.lookup);
    }

    FSClassRegistry.JCasClassInfo getJcci(String typeName) {
        return this.type2jcci.get(typeName);
    }

    private void computeFeatureOffsets(TypeImpl ti, int next) {
        for (FeatureImpl fi : ti.getMergedStaticFeaturesIntroducedByThisType()) {
            fi.setOffset(next++);
        }
        ti.highestOffset = next - 1;
        for (TypeImpl sub : ti.getDirectSubtypes()) {
            this.computeFeatureOffsets(sub, next);
        }
    }

    @Override
    public boolean isCommitted() {
        return this.locked;
    }

    public boolean isAnnotationBaseOrSubtype(int typecode) {
        return this.isAnnotationBaseOrSubtype(this.ll_getTypeForCode(typecode));
    }

    public boolean isAnnotationBaseOrSubtype(Type type) {
        return ((TypeImpl)type).isAnnotationBaseType();
    }

    public boolean isAnnotationOrSubtype(Type type) {
        return ((TypeImpl)type).isAnnotationType();
    }

    @Deprecated
    public Feature getFeature(String featureName) {
        return this.getFeatureByFullName(featureName);
    }

    @Override
    public void setFeatureFinal(Type type) {
        ((TypeImpl)type).setFeatureFinal();
    }

    @Override
    public void setInheritanceFinal(Type type) {
        ((TypeImpl)type).setInheritanceFinal();
    }

    @Override
    public TypeNameSpace getTypeNameSpace(String name) {
        if (!TypeSystemUtils.isTypeNameSpaceName(name)) {
            return null;
        }
        return new TypeNameSpaceImpl(name, this);
    }

    @Override
    public Type getArrayType(Type componentType) {
        TypeImpl ti = (TypeImpl)this.arrayComponentTypeToArrayType.get(componentType);
        if (null == ti) {
            ti = this.addArrayType(componentType, TypeSystemImpl.getSlotKindFromType(componentType), true, FSArray.class);
        }
        return ti;
    }

    @Override
    public Type addStringSubtype(String typeName, String[] stringList) throws CASAdminException {
        HashSet<String> allowedValues = new HashSet<String>(Arrays.asList(stringList));
        TypeImpl supertype = this.stringType;
        this.checkTypeSyntax(typeName);
        TypeImpl existingTi = this.getType(typeName);
        if (existingTi != null) {
            if (!(existingTi instanceof TypeImpl_stringSubtype)) {
                throw new CASAdminException("STRING_SUBTYPE_REDEFINE_NAME_CONFLICT", typeName, existingTi.toString());
            }
            Set<String> existingAllowedValues = ((TypeImpl_stringSubtype)existingTi).getAllowedValues();
            if (!existingAllowedValues.equals(allowedValues)) {
                return existingTi;
            }
            throw new CASAdminException("STRING_SUBTYPE_CONFLICTING_ALLOWED_VALUES", typeName, Misc.addElementsToStringBuilder(new StringBuilder(), existingAllowedValues).toString(), Misc.addElementsToStringBuilder(new StringBuilder(), allowedValues).toString());
        }
        TypeImpl_stringSubtype type = new TypeImpl_stringSubtype(typeName, this, supertype, allowedValues);
        type.setFeatureFinal();
        type.setInheritanceFinal();
        return type;
    }

    TypeImpl_array addArrayType(Type componentType, SlotKinds.SlotKind slotKind, boolean isHeapStoredArray, Class<?> javaClass) {
        if (this.isCommitted()) {
            throw new CASRuntimeException("ADD_ARRAY_TYPE_AFTER_TS_COMMITTED", componentType.getName() + ARRAY_TYPE_SUFFIX);
        }
        String arrayTypeName = TypeSystemImpl.getArrayTypeName(componentType.getName());
        TypeImpl supertype = this.computeArrayParentFromComponentType(componentType);
        TypeImpl_array ti = new TypeImpl_array(arrayTypeName, (TypeImpl)componentType, this, supertype, slotKind, isHeapStoredArray, javaClass);
        this.arrayComponentTypeToArrayType.put(componentType, ti);
        return ti;
    }

    private static void setTypeFinal(Type type) {
        TypeImpl t = (TypeImpl)type;
        t.setFeatureFinal();
        t.setInheritanceFinal();
        t.setBuiltIn();
    }

    private FeatureImpl getFeature(String typeName, String featureShortName) {
        TypeImpl type = this.getType(typeName);
        if (null == type) {
            return null;
        }
        return this.getFeature(this.getType(typeName), featureShortName);
    }

    private FeatureImpl getFeature(Type type, String featureShortName) {
        return ((TypeImpl)type).getFeatureByBaseName(featureShortName);
    }

    public int getFeatureOffset(TypeImpl ti, String featureShortName) {
        FeatureImpl fi = ti.getFeatureByBaseName(featureShortName);
        return fi.getOffset();
    }

    synchronized CasTypeSystemMapper getTypeSystemMapper(TypeSystemImpl tgtTs) {
        CasTypeSystemMapper ctsm = this.getTypeSystemMapperInner(tgtTs);
        if (null == ctsm || ctsm.isEqual()) {
            return null;
        }
        return ctsm;
    }

    synchronized CasTypeSystemMapper getTypeSystemMapperInner(TypeSystemImpl tgtTs) {
        if (null == tgtTs || this == tgtTs) {
            return null;
        }
        CasTypeSystemMapper m = this.typeSystemMappers.computeIfAbsent(tgtTs, key -> new CasTypeSystemMapper(this, tgtTs));
        return m;
    }

    @Override
    public int ll_getParentType(int typeCode) {
        if (typeCode == 1) {
            return 0;
        }
        return this.types.get(typeCode).getSuperType().getCode();
    }

    @Override
    public int[] ll_getAppropriateFeatures(int typecode) {
        if (!this.isType(typecode)) {
            return null;
        }
        return this.types.get(typecode).getFeaturesAsStream().mapToInt(FeatureImpl::getCode).toArray();
    }

    @Override
    public boolean ll_subsumes(int superType, int type) {
        return this.subsumes(this.types.get(superType), this.types.get(type));
    }

    @Override
    public int ll_getCodeForTypeName(String typeName) {
        if (typeName == null) {
            throw new NullPointerException();
        }
        TypeImpl ti = this.getType(typeName);
        return ti == null ? 0 : ti.getCode();
    }

    @Override
    public int ll_getCodeForType(Type type) {
        return ((TypeImpl)type).getCode();
    }

    @Override
    public int ll_getCodeForFeatureName(String featureName) {
        if (featureName == null) {
            throw new NullPointerException();
        }
        FeatureImpl fi = this.getFeatureByFullName(featureName);
        if (fi != null) {
            return fi.getCode();
        }
        return 0;
    }

    @Override
    public int ll_getCodeForFeature(Feature feature) {
        return ((FeatureImpl)feature).getCode();
    }

    @Override
    public Type ll_getTypeForCode(int typeCode) {
        return this.getTypeForCode(typeCode);
    }

    public TypeImpl getTypeForCode(int typeCode) {
        if (this.isType(typeCode)) {
            return this.types.get(typeCode);
        }
        return null;
    }

    public TypeImpl getTypeForCode_checked(int typeCode) {
        TypeImpl r = this.getTypeForCode(typeCode);
        if (r == null) {
            throw new LowLevelException("INVALID_TYPECODE", typeCode);
        }
        return r;
    }

    public boolean isApprop(int typecode, int featcode) {
        return ((TypeImpl)this.ll_getTypeForCode(typecode)).isAppropriateFeature(this.ll_getFeatureForCode(featcode));
    }

    int getFeatureOffset(int feat) {
        throw new UIMARuntimeException("NOT_SUPPORTED_NO_HEAP_IN_UIMA_V3", new Object[0]);
    }

    private final int getLargestFeatureCode() {
        return this.features.size();
    }

    final boolean isFeature(int featureCode) {
        return featureCode > 0 && featureCode <= this.getLargestFeatureCode();
    }

    @Override
    public Feature ll_getFeatureForCode(int featureCode) {
        if (this.isFeature(featureCode)) {
            return this.features.get(featureCode);
        }
        return null;
    }

    FeatureImpl getFeatureForCode(int featureCode) {
        return this.features.get(featureCode);
    }

    FeatureImpl getFeatureForCode_checked(int featureCode) {
        FeatureImpl f = this.getFeatureForCode(featureCode);
        if (null == f) {
            throw new LowLevelException("INVALID_FEATURE_CODE", featureCode);
        }
        return f;
    }

    @Override
    public int ll_getDomainType(int featureCode) {
        return this.intro(featureCode);
    }

    @Override
    public int ll_getRangeType(int featureCode) {
        return this.range(featureCode);
    }

    @Override
    public LowLevelTypeSystem getLowLevelTypeSystem() {
        return this;
    }

    @Override
    public boolean ll_isStringSubtype(int typecode) {
        return this.types.get(typecode).isStringSubtype();
    }

    boolean classifyAsRefType(String name, TypeImpl superType) {
        switch (name) {
            case "uima.cas.Boolean": 
            case "uima.cas.Byte": 
            case "uima.cas.Short": 
            case "uima.cas.Integer": 
            case "uima.cas.Long": 
            case "uima.cas.Float": 
            case "uima.cas.Double": 
            case "uima.cas.String": {
                return false;
            }
        }
        return superType == null || !superType.getName().equals("uima.cas.String");
    }

    public boolean isRefType(TypeImpl type) {
        return type.isRefType;
    }

    @Override
    public boolean ll_isRefType(int typeCode) {
        return this.isRefType(this.getTypeForCode(typeCode));
    }

    @Override
    public final int ll_getTypeClass(int typeCode) {
        if (typeCode == 23) {
            return 9;
        }
        if (typeCode == 24) {
            return 10;
        }
        if (typeCode == 25) {
            return 11;
        }
        if (typeCode == 2) {
            return 1;
        }
        if (typeCode == 3) {
            return 2;
        }
        if (typeCode == 26) {
            return 12;
        }
        if (typeCode == 27) {
            return 13;
        }
        if (this.ll_subsumes(4, typeCode)) {
            return 3;
        }
        if (typeCode == 28) {
            return 14;
        }
        if (typeCode == 29) {
            return 15;
        }
        if (typeCode == 30) {
            return 16;
        }
        if (typeCode == 8) {
            return 4;
        }
        if (typeCode == 7) {
            return 5;
        }
        if (typeCode == 31) {
            return 17;
        }
        if (typeCode == 32) {
            return 18;
        }
        if (typeCode == 9) {
            return 6;
        }
        if (this.ll_isArrayType(typeCode)) {
            return 7;
        }
        return 8;
    }

    @Override
    public int ll_getArrayType(int componentTypeCode) {
        if (!this.ll_isValidTypeCode(componentTypeCode)) {
            return 0;
        }
        return ((TypeImpl)this.getArrayType(this.types.get(componentTypeCode))).getCode();
    }

    @Override
    public boolean ll_isValidTypeCode(int typeCode) {
        return this.isType(typeCode);
    }

    @Override
    public boolean ll_isArrayType(int typeCode) {
        if (!this.ll_isValidTypeCode(typeCode)) {
            return false;
        }
        return this.types.get(typeCode).isArray();
    }

    @Override
    public int ll_getComponentType(int arrayTypeCode) {
        TypeImpl type = this.types.get(arrayTypeCode);
        if (type.isArray()) {
            return ((TypeImpl_array)type).getComponentType().getCode();
        }
        return 0;
    }

    @Override
    public boolean ll_isPrimitiveType(int typeCode) {
        return !this.ll_isRefType(typeCode);
    }

    @Override
    public String[] ll_getStringSet(int typeCode) {
        TypeImpl ti = this.types.get(typeCode);
        if (!ti.isStringSubtype()) {
            return null;
        }
        Set<String> allowedValues = ((TypeImpl_stringSubtype)ti).getAllowedValues();
        return (String[])allowedValues.stream().toArray(String[]::new);
    }

    @Override
    public Iterator<Feature> getFeatures() {
        List<FeatureImpl> lf = Collections.unmodifiableList(this.features);
        Iterator<Feature> it = lf.iterator();
        it.next();
        return it;
    }

    public int intro(int feat) {
        return ((TypeImpl)this.features.get(feat).getDomain()).getCode();
    }

    public int range(int feat) {
        return ((TypeImpl)this.features.get(feat).getRange()).getCode();
    }

    private TypeImpl computeArrayParentFromComponentType(Type componentType) {
        if (componentType.isPrimitive() || componentType == this.topType) {
            return this.arrayBaseType;
        }
        return this.fsArrayType;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TypeImpl getJCasRegisteredType(int i) {
        TypeImpl ti;
        TypeImpl typeImpl = ti = i >= this.jcasRegisteredTypes.size() ? null : this.jcasRegisteredTypes.get(i);
        if (ti != null) {
            return ti;
        }
        List<TypeImpl> list = this.jcasRegisteredTypes;
        synchronized (list) {
            ti = i >= this.jcasRegisteredTypes.size() ? null : this.jcasRegisteredTypes.get(i);
        }
        if (null == ti) {
            this.throwMissingUIMAtype(i);
        }
        return ti;
    }

    private void throwMissingUIMAtype(int typeindex) {
        Class<? extends TOP> cls = JCasRegistry.getClassForIndex(typeindex);
        if (cls != null) {
            String className = cls.getName();
            System.err.format("Missing UIMA type, JCas Class name: %s, index: %d, jcasRegisteredTypes size: %d%n", className, typeindex, this.jcasRegisteredTypes.size());
            this.dumpTypeSystem();
            throw new CASRuntimeException("JCAS_TYPE_NOT_IN_CAS_REGISTRY", className);
        }
        throw new CASRuntimeException("JCAS_UNKNOWN_TYPE_NOT_IN_CAS", new Object[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dumpTypeSystem() {
        StringBuilder sb = new StringBuilder();
        sb.append("TypeSystem committed?: ").append(this.isCommitted()).append('\n');
        sb.append("jcasRegisteredTypes:\n");
        List<TypeImpl> list = this.jcasRegisteredTypes;
        synchronized (list) {
            for (int i = 0; i < this.jcasRegisteredTypes.size(); ++i) {
                TypeImpl ti = this.jcasRegisteredTypes.get(i);
                sb.append(String.format("%4d: ", i));
                sb.append(ti == null ? "null" : ti.getName());
                if (i % 5 != 0) continue;
                sb.append('\n');
            }
        }
        System.err.println(sb);
        sb.setLength(0);
        sb.append("Dumping all type names\n");
        List<TypeImpl> allTypes = this.getAllTypes();
        int sz = allTypes.size();
        int i = 0;
        while (i < sz) {
            sb.append(String.format("%4d: %-20s ", i, allTypes.get(i++).getName()));
            if (i == sz) break;
            if (i % 5 != 0) continue;
            sb.append('\n');
        }
        System.err.println(sb);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setJCasRegisteredType(int typeIndexID, TypeImpl ti) {
        List<TypeImpl> list = this.jcasRegisteredTypes;
        synchronized (list) {
            TypeImpl existing = Misc.getWithExpand(this.jcasRegisteredTypes, typeIndexID);
            if (existing != null) {
                if (ti != existing) {
                    if (ti == null) {
                        Misc.internalError();
                    }
                    if (!existing.subsumes(ti)) {
                        Misc.internalError();
                    }
                }
            } else {
                this.jcasRegisteredTypes.set(typeIndexID, ti);
            }
        }
    }

    public static final int getTypeClass(TypeImpl ti) {
        switch (ti.getCode()) {
            case 2: {
                return 1;
            }
            case 3: {
                return 2;
            }
            case 4: {
                return 3;
            }
            case 8: {
                return 4;
            }
            case 7: {
                return 5;
            }
            case 9: {
                return 6;
            }
            case 6: {
                return 7;
            }
            case 23: {
                return 9;
            }
            case 24: {
                return 10;
            }
            case 25: {
                return 11;
            }
            case 26: {
                return 12;
            }
            case 27: {
                return 13;
            }
            case 28: {
                return 14;
            }
            case 29: {
                return 15;
            }
            case 30: {
                return 16;
            }
            case 31: {
                return 17;
            }
            case 32: {
                return 18;
            }
        }
        if (ti.isStringOrStringSubtype()) {
            return 3;
        }
        if (ti.isArray()) {
            return 7;
        }
        return 8;
    }

    public List<TypeImpl> getAllTypes() {
        return this.types.subList(1, this.types.size());
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.types == null ? 0 : this.types.hashCode());
        return result;
    }

    public static void compareTs(TypeSystem t1, TypeSystem t2) {
        TypeSystemImpl ts1 = (TypeSystemImpl)t1;
        TypeSystemImpl ts2 = (TypeSystemImpl)t2;
        if (ts1.types.size() != ts2.types.size()) {
            System.out.format("ts1 size: %,d ts2 size: %d%n", ts1.types.size(), ts2.types.size());
        }
        for (int i = 1; i < ts1.types.size(); ++i) {
            if (ts1.types.get(i).hashCode() == ts2.types.get(i).hashCode()) continue;
            System.out.format("ts1 type: %s%n%nts2 type: %s%n", ts1.types.get(i), ts2.types.get(i));
        }
        System.out.println("done");
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        TypeSystemImpl other = (TypeSystemImpl)obj;
        return !(this.types == null ? other.types != null : !this.types.equals(other.types));
    }

    public TypeImpl refreshType(Type t) {
        return this.getType(t.getName());
    }

    public FeatureImpl refreshFeature(Feature f) {
        return this.getFeatureByFullName(f.getName());
    }

    public static synchronized int getAdjustedFeatureOffset(String featName) {
        Logger logger = UIMAFramework.getLogger(TypeSystemImpl.class);
        logger.warn(() -> logger.rb_ue("JCAS_ALPHA_LEVEL_NOT_SUPPORTED", new Object[0]));
        return -1;
    }

    static int getAdjustedFeatureOffset(TypeImpl type, String featName) {
        FeatureImpl fi = type.getFeatureByBaseName(featName);
        return fi == null ? -1 : fi.getAdjustedOffset();
    }

    void fixupFSArrayTypes(TypeImpl featRange, TOP arrayFs) {
        if (CASImpl.IS_DISABLE_SUBTYPE_FSARRAY_CREATION) {
            return;
        }
        if (arrayFs != null && featRange.isTypedFsArray()) {
            TypeImpl array_type = arrayFs._getTypeImpl();
            if (array_type.isTypedFsArray()) {
                return;
            }
            arrayFs._setTypeImpl(featRange);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FsGenerator3[] getGeneratorsForClassLoader(ClassLoader cl, boolean isPear) {
        Map<ClassLoader, FsGenerator3[]> gByC;
        Map<ClassLoader, FsGenerator3[]> map = gByC = isPear ? this.generators4pearsByClassLoader : this.generatorsByClassLoader;
        synchronized (map) {
            FsGenerator3[] g = gByC.get(cl);
            if (g == null && !this.skip_loading_user_jcas) {
                g = FSClassRegistry.getGeneratorsForClassLoader(cl, isPear, this);
                gByC.put(cl, g);
            }
            return g;
        }
    }

    public static final MutableCallSite createCallSite(Class<? extends TOP> clazz, String featName) {
        MutableCallSite callSite = new MutableCallSite(MethodType.methodType(Integer.TYPE));
        callSite.setTarget(MHC_MINUS_1);
        return callSite;
    }

    public static final MutableCallSite createCallSiteForBuiltIn(Class<? extends TOP> clazz, String featName) {
        TypeImpl type;
        if (staticTsi == null) {
            return TypeSystemImpl.createCallSite(clazz, featName);
        }
        try {
            int typeId = clazz.getField("typeIndexID").getInt(null);
            TypeImpl typeImpl = type = typeId >= TypeSystemImpl.staticTsi.jcasRegisteredTypes.size() ? null : TypeSystemImpl.staticTsi.jcasRegisteredTypes.get(typeId);
            if (type == null) {
                return TypeSystemImpl.createCallSite(clazz, featName);
            }
        }
        catch (Exception e) {
            throw new UIMARuntimeException((Throwable)e, "INTERNAL_ERROR", e);
        }
        MutableCallSite callSite = new MutableCallSite(MethodType.methodType(Integer.TYPE));
        int adjustedOffset = type.getAdjOffset(featName);
        callSite.setTarget(FSClassRegistry.getConstantIntMethodHandle(adjustedOffset));
        return callSite;
    }

    @Override
    public Iterator<Type> iterator() {
        return this.getTypeIterator();
    }

    public void set_skip_loading_user_jcas(boolean v) {
        this.skip_loading_user_jcas = v;
    }

    static {
        builtInArrayComponentName2ArrayTypeName.put("uima.cas.TOP", "uima.cas.FSArray");
        builtInArrayComponentName2ArrayTypeName.put("uima.cas.Boolean", "uima.cas.BooleanArray");
        builtInArrayComponentName2ArrayTypeName.put("uima.cas.Byte", "uima.cas.ByteArray");
        builtInArrayComponentName2ArrayTypeName.put("uima.cas.Short", "uima.cas.ShortArray");
        builtInArrayComponentName2ArrayTypeName.put("uima.cas.Integer", "uima.cas.IntegerArray");
        builtInArrayComponentName2ArrayTypeName.put("uima.cas.Float", "uima.cas.FloatArray");
        builtInArrayComponentName2ArrayTypeName.put("uima.cas.Long", "uima.cas.LongArray");
        builtInArrayComponentName2ArrayTypeName.put("uima.cas.Double", "uima.cas.DoubleArray");
        builtInArrayComponentName2ArrayTypeName.put("uima.cas.String", "uima.cas.StringArray");
        slotKindsForNonArrays = new HashMap<String, SlotKinds.SlotKind>(9);
        slotKindsForNonArrays.put("uima.cas.String", SlotKinds.SlotKind.Slot_StrRef);
        slotKindsForNonArrays.put("uima.cas.Integer", SlotKinds.SlotKind.Slot_Int);
        slotKindsForNonArrays.put("uima.cas.Boolean", SlotKinds.SlotKind.Slot_Boolean);
        slotKindsForNonArrays.put("uima.cas.Byte", SlotKinds.SlotKind.Slot_Byte);
        slotKindsForNonArrays.put("uima.cas.Short", SlotKinds.SlotKind.Slot_Short);
        slotKindsForNonArrays.put("uima.cas.Float", SlotKinds.SlotKind.Slot_Float);
        slotKindsForNonArrays.put("uima.cas.Long", SlotKinds.SlotKind.Slot_LongRef);
        slotKindsForNonArrays.put("uima.cas.Double", SlotKinds.SlotKind.Slot_DoubleRef);
        committedTypeSystems = Collections.synchronizedMap(new WeakHashMap());
        staticTsi = new TypeSystemImpl();
        TypeSystemImpl tsi = staticTsi.commit();
        if (tsi != staticTsi) {
            Misc.internalError();
        }
    }
}

