/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.collection.impl;

import java.io.IOException;
import org.apache.uima.UIMARuntimeException;
import org.apache.uima.cas.CAS;
import org.apache.uima.cas.impl.OutOfTypeSystemData;
import org.apache.uima.cas.impl.XCASDeserializer;
import org.apache.uima.cas.impl.XCASSerializer;
import org.apache.uima.cas_data.CasData;
import org.apache.uima.cas_data.impl.CasDataImpl;
import org.apache.uima.cas_data.impl.CasDataToXCas;
import org.apache.uima.cas_data.impl.XCasToCasDataSaxHandler;
import org.apache.uima.collection.CollectionException;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;

public class CasConverter {
    private String mDocumentTextTypeName = "uima.cpm.DocumentText";
    private String mDocumentTextFeatureName = "value";

    public String getDocumentTextTypeName() {
        return this.mDocumentTextTypeName;
    }

    public void setDocumentTextTypeName(String aDocumentTextTypeName) {
        this.mDocumentTextTypeName = aDocumentTextTypeName;
    }

    public String getDocumentTextFeatureName() {
        return this.mDocumentTextFeatureName;
    }

    public void setDocumentTextFeatureName(String aDocumentTextFeatureName) {
        this.mDocumentTextFeatureName = aDocumentTextFeatureName;
    }

    public void casDataToCasContainer(CasData aData, CAS aContainer, boolean aLenient) throws CollectionException {
        aContainer.reset();
        CasDataToXCas generator = new CasDataToXCas();
        generator.setDocumentTextTypeName(this.getDocumentTextTypeName());
        generator.setDocumentTextFeatureName(this.getDocumentTextFeatureName());
        XCASDeserializer xcasDeser = new XCASDeserializer(aContainer.getTypeSystem());
        xcasDeser.setDocumentTypeName(this.getDocumentTextTypeName());
        OutOfTypeSystemData ootsd = null;
        if (aLenient) {
            ootsd = new OutOfTypeSystemData();
        }
        generator.setContentHandler((ContentHandler)xcasDeser.getXCASHandler(aContainer, ootsd));
        try {
            generator.generateXCas(aData);
        }
        catch (Exception e) {
            throw new CollectionException((Throwable)e);
        }
    }

    public CasData casContainerToCasData(CAS aContainer) {
        CasDataImpl result = new CasDataImpl();
        XCasToCasDataSaxHandler handler = new XCasToCasDataSaxHandler((CasData)result);
        XCASSerializer xcasSer = new XCASSerializer(aContainer.getTypeSystem());
        xcasSer.setDocumentTypeName(this.getDocumentTextTypeName());
        xcasSer.setDocumentTextFeature(this.getDocumentTextFeatureName());
        try {
            xcasSer.serialize(aContainer, (ContentHandler)handler);
        }
        catch (IOException e) {
            throw new UIMARuntimeException((Throwable)e);
        }
        catch (SAXException e) {
            throw new UIMARuntimeException((Throwable)e);
        }
        return result;
    }
}

