/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.ruta.ide.core;

import org.apache.uima.ruta.extensions.IRutaActionExtension;
import org.apache.uima.ruta.extensions.IRutaBlockExtension;
import org.apache.uima.ruta.extensions.IRutaBooleanFunctionExtension;
import org.apache.uima.ruta.extensions.IRutaConditionExtension;
import org.apache.uima.ruta.extensions.IRutaNumberFunctionExtension;
import org.apache.uima.ruta.extensions.IRutaStringFunctionExtension;
import org.apache.uima.ruta.extensions.IRutaTypeFunctionExtension;
import org.apache.uima.ruta.ide.core.IRutaKeywords;
import org.apache.uima.ruta.ide.core.RutaExtensionManager;
import org.apache.uima.ruta.ide.core.RutaKeywords;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;
import org.eclipse.dltk.core.DLTKCore;

public final class RutaKeywordsManager {
    private static final String EXTENSION_POINT = "org.apache.uima.ruta.ide.rutakeywords";
    private static final String CLASS = "class";
    private static String[][] all = new String[11][];
    private static boolean initialized = false;

    private static synchronized void initialize() {
        IRutaBlockExtension[] blockExtensions;
        IRutaTypeFunctionExtension[] typeFunctionExtensions;
        IRutaStringFunctionExtension[] stringFunctionExtensions;
        IRutaNumberFunctionExtension[] numberFunctionExtensions;
        IRutaBooleanFunctionExtension[] booleanFunctionExtensions;
        IRutaConditionExtension[] conditionExtensions;
        IRutaActionExtension[] actionExtensions;
        int i;
        if (initialized) {
            return;
        }
        IConfigurationElement[] cfg = Platform.getExtensionRegistry().getConfigurationElementsFor(EXTENSION_POINT);
        for (i = 0; i < 11; ++i) {
            RutaKeywordsManager.all[i] = new String[0];
        }
        for (i = 0; i < cfg.length; ++i) {
            if (!cfg[i].getName().equals("keywords")) continue;
            try {
                IRutaKeywords keywords = (IRutaKeywords)cfg[i].createExecutableExtension(CLASS);
                if (keywords == null) continue;
                for (int q = 0; q < 11; ++q) {
                    String[] kw2 = keywords.getKeywords(q);
                    RutaKeywordsManager.all[q] = RutaKeywords.append(all[q], kw2);
                }
                continue;
            }
            catch (CoreException e) {
                if (!DLTKCore.DEBUG) continue;
                e.printStackTrace();
            }
        }
        for (IRutaActionExtension each : actionExtensions = RutaExtensionManager.getDefault().getRutaActionExtensions()) {
            String[] knownExtensions = each.getKnownExtensions();
            RutaKeywordsManager.all[5] = RutaKeywords.append(all[5], knownExtensions);
        }
        for (IRutaConditionExtension each : conditionExtensions = RutaExtensionManager.getDefault().getRutaConditionExtensions()) {
            String[] knownExtensions = each.getKnownExtensions();
            RutaKeywordsManager.all[4] = RutaKeywords.append(all[4], knownExtensions);
        }
        for (IRutaBooleanFunctionExtension each : booleanFunctionExtensions = RutaExtensionManager.getDefault().getRutaBooleanFunctionExtensions()) {
            String[] knownExtensions = each.getKnownExtensions();
            RutaKeywordsManager.all[6] = RutaKeywords.append(all[6], knownExtensions);
        }
        for (IRutaNumberFunctionExtension each : numberFunctionExtensions = RutaExtensionManager.getDefault().getRutaNumberFunctionExtensions()) {
            String[] knownExtensions = each.getKnownExtensions();
            RutaKeywordsManager.all[7] = RutaKeywords.append(all[7], knownExtensions);
        }
        for (IRutaStringFunctionExtension each : stringFunctionExtensions = RutaExtensionManager.getDefault().getRutaStringFunctionExtensions()) {
            String[] knownExtensions = each.getKnownExtensions();
            RutaKeywordsManager.all[8] = RutaKeywords.append(all[8], knownExtensions);
        }
        for (IRutaTypeFunctionExtension each : typeFunctionExtensions = RutaExtensionManager.getDefault().getRutaTypeFunctionExtensions()) {
            String[] knownExtensions = each.getKnownExtensions();
            RutaKeywordsManager.all[9] = RutaKeywords.append(all[9], knownExtensions);
        }
        for (IRutaBlockExtension each : blockExtensions = RutaExtensionManager.getDefault().getRutaBlockExtensions()) {
            String[] knownExtensions = each.getKnownExtensions();
            RutaKeywordsManager.all[1] = RutaKeywords.append(all[1], knownExtensions);
        }
        initialized = true;
    }

    public static String[] getKeywords() {
        RutaKeywordsManager.initialize();
        return all[0];
    }

    public static String[] getKeywords(int type) {
        RutaKeywordsManager.initialize();
        if (type >= 0 && type < all.length) {
            return all[type];
        }
        return new String[0];
    }
}

