/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fulcrum.jetty.impl;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.apache.avalon.framework.activity.Initializable;
import org.apache.avalon.framework.activity.Startable;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.avalon.framework.configuration.Reconfigurable;
import org.apache.avalon.framework.context.Context;
import org.apache.avalon.framework.context.ContextException;
import org.apache.avalon.framework.context.Contextualizable;
import org.apache.avalon.framework.logger.AbstractLogEnabled;
import org.apache.avalon.framework.logger.LogEnabled;
import org.apache.fulcrum.jetty.JettyService;
import org.mortbay.jetty.Server;
import org.mortbay.xml.XmlConfiguration;

public class JettyServiceImpl
extends AbstractLogEnabled
implements LogEnabled,
Startable,
Contextualizable,
Initializable,
Reconfigurable,
JettyService {
    private Server server;
    private String[] configurationLocations;
    private File serviceApplicationDir;

    public void contextualize(Context context) throws ContextException {
        this.serviceApplicationDir = (File)context.get((Object)"context-root");
    }

    public void configure(Configuration configuration) throws ConfigurationException {
        Configuration[] configurationsList = configuration.getChild("configurations").getChildren("configuration");
        this.configurationLocations = new String[configurationsList.length];
        for (int i = 0; i < this.configurationLocations.length; ++i) {
            this.configurationLocations[i] = configurationsList[i].getValue();
        }
        if (this.configurationLocations.length == 0) {
            String msg = "No configuration files for the Jetty are defined";
            throw new ConfigurationException(msg);
        }
        Configuration[] propertiesConfiguration = configuration.getChild("properties", true).getChildren("property");
        for (int i = 0; i < propertiesConfiguration.length; ++i) {
            String key = propertiesConfiguration[i].getAttribute("name");
            String value = propertiesConfiguration[i].getValue();
            this.getLogger().info("Setting the system property '" + key + "'==>'" + value + "'");
            System.setProperty(key, value);
        }
    }

    public void initialize() throws Exception {
        Server currServer = new Server();
        for (int i = 0; i < this.configurationLocations.length; ++i) {
            String currConfigurationLocation = this.configurationLocations[i];
            this.getLogger().info("Loading the Jetty serviceConfiguration file : " + currConfigurationLocation);
            InputStream is = this.locate(this.serviceApplicationDir, currConfigurationLocation);
            XmlConfiguration configuration = new XmlConfiguration(is);
            configuration.configure((Object)currServer);
            is.close();
        }
        this.server = currServer;
    }

    public void start() throws Exception {
        this.getServer().start();
    }

    public void stop() throws Exception {
        this.getServer().stop();
    }

    public void reconfigure(Configuration configuration) throws ConfigurationException {
        if (configuration != null) {
            this.configure(configuration);
        }
        try {
            this.initialize();
        }
        catch (Exception e) {
            String msg = "Initializing the new server failed";
            throw new ConfigurationException(msg, (Throwable)e);
        }
    }

    public Server getServer() {
        return this.server;
    }

    private InputStream locate(File applicationDir, String location) throws IOException {
        if (location == null || location.length() == 0) {
            throw new IllegalArgumentException("location is null or empty");
        }
        File file = null;
        InputStream is = null;
        if (!location.startsWith("/")) {
            file = new File(applicationDir, location);
            this.getLogger().debug("Looking for " + location + " in the application directory");
            if (file.exists()) {
                is = new FileInputStream(file);
                this.getLogger().debug("Found " + location + " as " + file.getAbsolutePath());
            }
        }
        if (is == null && location.startsWith("/")) {
            file = new File(location);
            this.getLogger().debug("Looking for " + location + " as absolute file location");
            if (file.isAbsolute() && file.exists()) {
                is = new FileInputStream(file);
                this.getLogger().debug("Found " + location + " as " + file.getAbsolutePath());
            }
        }
        if (is == null && location.startsWith("/")) {
            this.getLogger().debug("Looking for " + location + " using the class loader");
            is = this.getClass().getResourceAsStream(location);
            if (is != null) {
                this.getLogger().debug("Successfully located " + location);
            }
        }
        if (is == null) {
            this.getLogger().warn("Unable to find any resource with the name '" + location + "'");
        }
        return is;
    }
}

