/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.validation;

import java.beans.PropertyEditor;
import java.lang.annotation.Annotation;
import java.lang.invoke.CallSite;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.function.Predicate;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.BeanInstantiationException;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.ConfigurablePropertyAccessor;
import org.springframework.beans.MutablePropertyValues;
import org.springframework.beans.PropertyAccessException;
import org.springframework.beans.PropertyAccessorUtils;
import org.springframework.beans.PropertyBatchUpdateException;
import org.springframework.beans.PropertyEditorRegistrar;
import org.springframework.beans.PropertyEditorRegistry;
import org.springframework.beans.PropertyValue;
import org.springframework.beans.PropertyValues;
import org.springframework.beans.SimpleTypeConverter;
import org.springframework.beans.TypeConverter;
import org.springframework.beans.TypeMismatchException;
import org.springframework.core.CollectionFactory;
import org.springframework.core.KotlinDetector;
import org.springframework.core.MethodParameter;
import org.springframework.core.ResolvableType;
import org.springframework.core.convert.ConversionService;
import org.springframework.core.convert.TypeDescriptor;
import org.springframework.format.Formatter;
import org.springframework.format.support.FormatterPropertyEditorAdapter;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.ObjectUtils;
import org.springframework.util.PatternMatchUtils;
import org.springframework.util.StringUtils;
import org.springframework.validation.AbstractPropertyBindingResult;
import org.springframework.validation.BeanPropertyBindingResult;
import org.springframework.validation.BindException;
import org.springframework.validation.BindingErrorProcessor;
import org.springframework.validation.BindingResult;
import org.springframework.validation.DefaultBindingErrorProcessor;
import org.springframework.validation.DirectFieldBindingResult;
import org.springframework.validation.MessageCodesResolver;
import org.springframework.validation.ObjectError;
import org.springframework.validation.SmartValidator;
import org.springframework.validation.Validator;
import org.springframework.validation.annotation.ValidationAnnotationUtils;

public class DataBinder
implements PropertyEditorRegistry,
TypeConverter {
    public static final String DEFAULT_OBJECT_NAME = "target";
    public static final int DEFAULT_AUTO_GROW_COLLECTION_LIMIT = 256;
    protected static final Log logger = LogFactory.getLog(DataBinder.class);
    private static final int NO_INDEX = -1;
    @Nullable
    private Object target;
    @Nullable
    ResolvableType targetType;
    private final String objectName;
    @Nullable
    private AbstractPropertyBindingResult bindingResult;
    private boolean directFieldAccess = false;
    @Nullable
    private ExtendedTypeConverter typeConverter;
    private boolean declarativeBinding = false;
    private boolean ignoreUnknownFields = true;
    private boolean ignoreInvalidFields = false;
    private boolean autoGrowNestedPaths = true;
    private int autoGrowCollectionLimit = 256;
    @Nullable
    private String[] allowedFields;
    @Nullable
    private String[] disallowedFields;
    @Nullable
    private String[] requiredFields;
    @Nullable
    private NameResolver nameResolver;
    @Nullable
    private ConversionService conversionService;
    @Nullable
    private MessageCodesResolver messageCodesResolver;
    private BindingErrorProcessor bindingErrorProcessor = new DefaultBindingErrorProcessor();
    private final List<Validator> validators = new ArrayList<Validator>();
    @Nullable
    private Predicate<Validator> excludedValidators;

    public DataBinder(@Nullable Object target) {
        this(target, DEFAULT_OBJECT_NAME);
    }

    public DataBinder(@Nullable Object target, String objectName) {
        this.target = ObjectUtils.unwrapOptional((Object)target);
        this.objectName = objectName;
    }

    @Nullable
    public Object getTarget() {
        return this.target;
    }

    public String getObjectName() {
        return this.objectName;
    }

    public void setTargetType(ResolvableType targetType) {
        Assert.state((this.target == null ? 1 : 0) != 0, (String)"targetType is used to for target creation but target is already set");
        this.targetType = targetType;
    }

    @Nullable
    public ResolvableType getTargetType() {
        return this.targetType;
    }

    public void setAutoGrowNestedPaths(boolean autoGrowNestedPaths) {
        Assert.state((this.bindingResult == null ? 1 : 0) != 0, (String)"DataBinder is already initialized - call setAutoGrowNestedPaths before other configuration methods");
        this.autoGrowNestedPaths = autoGrowNestedPaths;
    }

    public boolean isAutoGrowNestedPaths() {
        return this.autoGrowNestedPaths;
    }

    public void setAutoGrowCollectionLimit(int autoGrowCollectionLimit) {
        Assert.state((this.bindingResult == null ? 1 : 0) != 0, (String)"DataBinder is already initialized - call setAutoGrowCollectionLimit before other configuration methods");
        this.autoGrowCollectionLimit = autoGrowCollectionLimit;
    }

    public int getAutoGrowCollectionLimit() {
        return this.autoGrowCollectionLimit;
    }

    public void initBeanPropertyAccess() {
        Assert.state((this.bindingResult == null ? 1 : 0) != 0, (String)"DataBinder is already initialized - call initBeanPropertyAccess before other configuration methods");
        this.directFieldAccess = false;
    }

    protected AbstractPropertyBindingResult createBeanPropertyBindingResult() {
        BeanPropertyBindingResult result = new BeanPropertyBindingResult(this.getTarget(), this.getObjectName(), this.isAutoGrowNestedPaths(), this.getAutoGrowCollectionLimit());
        if (this.conversionService != null) {
            result.initConversion(this.conversionService);
        }
        if (this.messageCodesResolver != null) {
            result.setMessageCodesResolver(this.messageCodesResolver);
        }
        return result;
    }

    public void initDirectFieldAccess() {
        Assert.state((this.bindingResult == null ? 1 : 0) != 0, (String)"DataBinder is already initialized - call initDirectFieldAccess before other configuration methods");
        this.directFieldAccess = true;
    }

    protected AbstractPropertyBindingResult createDirectFieldBindingResult() {
        DirectFieldBindingResult result = new DirectFieldBindingResult(this.getTarget(), this.getObjectName(), this.isAutoGrowNestedPaths());
        if (this.conversionService != null) {
            result.initConversion(this.conversionService);
        }
        if (this.messageCodesResolver != null) {
            result.setMessageCodesResolver(this.messageCodesResolver);
        }
        return result;
    }

    protected AbstractPropertyBindingResult getInternalBindingResult() {
        if (this.bindingResult == null) {
            this.bindingResult = this.directFieldAccess ? this.createDirectFieldBindingResult() : this.createBeanPropertyBindingResult();
        }
        return this.bindingResult;
    }

    protected ConfigurablePropertyAccessor getPropertyAccessor() {
        return this.getInternalBindingResult().getPropertyAccessor();
    }

    protected SimpleTypeConverter getSimpleTypeConverter() {
        if (this.typeConverter == null) {
            this.typeConverter = new ExtendedTypeConverter();
            if (this.conversionService != null) {
                this.typeConverter.setConversionService(this.conversionService);
            }
        }
        return this.typeConverter;
    }

    protected PropertyEditorRegistry getPropertyEditorRegistry() {
        if (this.getTarget() != null) {
            return this.getInternalBindingResult().getPropertyAccessor();
        }
        return this.getSimpleTypeConverter();
    }

    protected TypeConverter getTypeConverter() {
        if (this.getTarget() != null) {
            return this.getInternalBindingResult().getPropertyAccessor();
        }
        return this.getSimpleTypeConverter();
    }

    public BindingResult getBindingResult() {
        return this.getInternalBindingResult();
    }

    public void setDeclarativeBinding(boolean declarativeBinding) {
        this.declarativeBinding = declarativeBinding;
    }

    public boolean isDeclarativeBinding() {
        return this.declarativeBinding;
    }

    public void setIgnoreUnknownFields(boolean ignoreUnknownFields) {
        this.ignoreUnknownFields = ignoreUnknownFields;
    }

    public boolean isIgnoreUnknownFields() {
        return this.ignoreUnknownFields;
    }

    public void setIgnoreInvalidFields(boolean ignoreInvalidFields) {
        this.ignoreInvalidFields = ignoreInvalidFields;
    }

    public boolean isIgnoreInvalidFields() {
        return this.ignoreInvalidFields;
    }

    public void setAllowedFields(String ... allowedFields) {
        this.allowedFields = PropertyAccessorUtils.canonicalPropertyNames((String[])allowedFields);
    }

    @Nullable
    public String[] getAllowedFields() {
        return this.allowedFields;
    }

    public void setDisallowedFields(String ... disallowedFields) {
        if (disallowedFields == null) {
            this.disallowedFields = null;
        } else {
            String[] fieldPatterns = new String[disallowedFields.length];
            for (int i = 0; i < fieldPatterns.length; ++i) {
                fieldPatterns[i] = PropertyAccessorUtils.canonicalPropertyName((String)disallowedFields[i]);
            }
            this.disallowedFields = fieldPatterns;
        }
    }

    @Nullable
    public String[] getDisallowedFields() {
        return this.disallowedFields;
    }

    public void setRequiredFields(String ... requiredFields) {
        this.requiredFields = PropertyAccessorUtils.canonicalPropertyNames((String[])requiredFields);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("DataBinder requires binding of required fields [" + StringUtils.arrayToCommaDelimitedString((Object[])requiredFields) + "]"));
        }
    }

    @Nullable
    public String[] getRequiredFields() {
        return this.requiredFields;
    }

    public void setNameResolver(NameResolver nameResolver) {
        this.nameResolver = nameResolver;
    }

    @Nullable
    public NameResolver getNameResolver() {
        return this.nameResolver;
    }

    public void setMessageCodesResolver(@Nullable MessageCodesResolver messageCodesResolver) {
        Assert.state((this.messageCodesResolver == null ? 1 : 0) != 0, (String)"DataBinder is already initialized with MessageCodesResolver");
        this.messageCodesResolver = messageCodesResolver;
        if (this.bindingResult != null && messageCodesResolver != null) {
            this.bindingResult.setMessageCodesResolver(messageCodesResolver);
        }
    }

    public void setBindingErrorProcessor(BindingErrorProcessor bindingErrorProcessor) {
        Assert.notNull((Object)bindingErrorProcessor, (String)"BindingErrorProcessor must not be null");
        this.bindingErrorProcessor = bindingErrorProcessor;
    }

    public BindingErrorProcessor getBindingErrorProcessor() {
        return this.bindingErrorProcessor;
    }

    public void setValidator(@Nullable Validator validator) {
        this.assertValidators(validator);
        this.validators.clear();
        if (validator != null) {
            this.validators.add(validator);
        }
    }

    private void assertValidators(Validator ... validators) {
        Object target = this.getTarget();
        for (Validator validator : validators) {
            if (validator == null || target == null || validator.supports(target.getClass())) continue;
            throw new IllegalStateException("Invalid target for Validator [" + String.valueOf(validator) + "]: " + String.valueOf(target));
        }
    }

    public void setExcludedValidators(Predicate<Validator> predicate) {
        this.excludedValidators = predicate;
    }

    public void addValidators(Validator ... validators) {
        this.assertValidators(validators);
        this.validators.addAll(Arrays.asList(validators));
    }

    public void replaceValidators(Validator ... validators) {
        this.assertValidators(validators);
        this.validators.clear();
        this.validators.addAll(Arrays.asList(validators));
    }

    @Nullable
    public Validator getValidator() {
        return !this.validators.isEmpty() ? this.validators.get(0) : null;
    }

    public List<Validator> getValidators() {
        return Collections.unmodifiableList(this.validators);
    }

    public List<Validator> getValidatorsToApply() {
        return this.excludedValidators != null ? this.validators.stream().filter(validator -> !this.excludedValidators.test((Validator)validator)).toList() : Collections.unmodifiableList(this.validators);
    }

    public void setConversionService(@Nullable ConversionService conversionService) {
        Assert.state((this.conversionService == null ? 1 : 0) != 0, (String)"DataBinder is already initialized with ConversionService");
        this.conversionService = conversionService;
        if (this.bindingResult != null && conversionService != null) {
            this.bindingResult.initConversion(conversionService);
        }
    }

    @Nullable
    public ConversionService getConversionService() {
        return this.conversionService;
    }

    public void addCustomFormatter(Formatter<?> formatter) {
        FormatterPropertyEditorAdapter adapter = new FormatterPropertyEditorAdapter(formatter);
        this.getPropertyEditorRegistry().registerCustomEditor(adapter.getFieldType(), (PropertyEditor)adapter);
    }

    public void addCustomFormatter(Formatter<?> formatter, String ... fields) {
        FormatterPropertyEditorAdapter adapter = new FormatterPropertyEditorAdapter(formatter);
        Class<?> fieldType = adapter.getFieldType();
        if (ObjectUtils.isEmpty((Object[])fields)) {
            this.getPropertyEditorRegistry().registerCustomEditor(fieldType, (PropertyEditor)adapter);
        } else {
            for (String field : fields) {
                this.getPropertyEditorRegistry().registerCustomEditor(fieldType, field, (PropertyEditor)adapter);
            }
        }
    }

    public void addCustomFormatter(Formatter<?> formatter, Class<?> ... fieldTypes) {
        FormatterPropertyEditorAdapter adapter = new FormatterPropertyEditorAdapter(formatter);
        if (ObjectUtils.isEmpty((Object[])fieldTypes)) {
            this.getPropertyEditorRegistry().registerCustomEditor(adapter.getFieldType(), (PropertyEditor)adapter);
        } else {
            for (Class<?> fieldType : fieldTypes) {
                this.getPropertyEditorRegistry().registerCustomEditor(fieldType, (PropertyEditor)adapter);
            }
        }
    }

    public void registerCustomEditor(Class<?> requiredType, PropertyEditor propertyEditor) {
        this.getPropertyEditorRegistry().registerCustomEditor(requiredType, propertyEditor);
    }

    public void registerCustomEditor(@Nullable Class<?> requiredType, @Nullable String field, PropertyEditor propertyEditor) {
        this.getPropertyEditorRegistry().registerCustomEditor(requiredType, field, propertyEditor);
    }

    @Nullable
    public PropertyEditor findCustomEditor(@Nullable Class<?> requiredType, @Nullable String propertyPath) {
        return this.getPropertyEditorRegistry().findCustomEditor(requiredType, propertyPath);
    }

    @Nullable
    public <T> T convertIfNecessary(@Nullable Object value, @Nullable Class<T> requiredType) throws TypeMismatchException {
        return (T)this.getTypeConverter().convertIfNecessary(value, requiredType);
    }

    @Nullable
    public <T> T convertIfNecessary(@Nullable Object value, @Nullable Class<T> requiredType, @Nullable MethodParameter methodParam) throws TypeMismatchException {
        return (T)this.getTypeConverter().convertIfNecessary(value, requiredType, methodParam);
    }

    @Nullable
    public <T> T convertIfNecessary(@Nullable Object value, @Nullable Class<T> requiredType, @Nullable Field field) throws TypeMismatchException {
        return (T)this.getTypeConverter().convertIfNecessary(value, requiredType, field);
    }

    @Nullable
    public <T> T convertIfNecessary(@Nullable Object value, @Nullable Class<T> requiredType, @Nullable TypeDescriptor typeDescriptor) throws TypeMismatchException {
        return (T)this.getTypeConverter().convertIfNecessary(value, requiredType, typeDescriptor);
    }

    public void construct(ValueResolver valueResolver) {
        Assert.state((this.target == null ? 1 : 0) != 0, (String)"Target instance already available");
        Assert.state((this.targetType != null ? 1 : 0) != 0, (String)"Target type not set");
        this.target = this.createObject(this.targetType, "", valueResolver);
        if (!this.getBindingResult().hasErrors()) {
            this.bindingResult = null;
            if (this.typeConverter != null) {
                this.typeConverter.registerCustomEditors((PropertyEditorRegistry)this.getPropertyAccessor());
            }
        }
    }

    @Nullable
    private Object createObject(ResolvableType objectType, String nestedPath, ValueResolver valueResolver) {
        Class clazz = objectType.resolve();
        boolean isOptional = clazz == Optional.class;
        Class clazz2 = clazz = isOptional ? objectType.resolveGeneric(new int[]{0}) : clazz;
        if (clazz == null) {
            throw new IllegalStateException("Insufficient type information to create instance of " + String.valueOf(objectType));
        }
        Object result = null;
        Constructor ctor = BeanUtils.getResolvableConstructor((Class)clazz);
        if (ctor.getParameterCount() == 0) {
            result = BeanUtils.instantiateClass((Constructor)ctor, (Object[])new Object[0]);
        } else {
            int i;
            String[] paramNames = BeanUtils.getParameterNames((Constructor)ctor);
            Class<?>[] paramTypes = ctor.getParameterTypes();
            Object[] args = new Object[paramTypes.length];
            HashSet<CallSite> failedParamNames = new HashSet<CallSite>(4);
            for (i = 0; i < paramNames.length; ++i) {
                MethodParameter param = MethodParameter.forFieldAwareConstructor((Constructor)ctor, (int)i, (String)paramNames[i]);
                String lookupName = null;
                if (this.nameResolver != null) {
                    lookupName = this.nameResolver.resolveName(param);
                }
                if (lookupName == null) {
                    lookupName = paramNames[i];
                }
                String paramPath = nestedPath + lookupName;
                Class<?> paramType = paramTypes[i];
                ResolvableType resolvableType = ResolvableType.forMethodParameter((MethodParameter)param);
                Object value = valueResolver.resolveValue(paramPath, paramType);
                if (value == null) {
                    if (List.class.isAssignableFrom(paramType)) {
                        value = this.createList(paramPath, paramType, resolvableType, valueResolver);
                    } else if (Map.class.isAssignableFrom(paramType)) {
                        value = this.createMap(paramPath, paramType, resolvableType, valueResolver);
                    } else if (paramType.isArray()) {
                        value = this.createArray(paramPath, paramType, resolvableType, valueResolver);
                    }
                }
                if (value == null && this.shouldConstructArgument(param) && this.hasValuesFor(paramPath, valueResolver)) {
                    args[i] = this.createObject(resolvableType, paramPath + ".", valueResolver);
                    continue;
                }
                try {
                    if (value == null && (param.isOptional() || this.getBindingResult().hasErrors())) {
                        args[i] = param.getParameterType() == Optional.class ? Optional.empty() : null;
                        continue;
                    }
                    args[i] = this.convertIfNecessary(value, paramType, param);
                    continue;
                }
                catch (TypeMismatchException ex) {
                    args[i] = null;
                    failedParamNames.add((CallSite)((Object)paramPath));
                    this.handleTypeMismatchException(ex, paramPath, paramType, value);
                }
            }
            if (this.getBindingResult().hasErrors()) {
                MethodParameter param;
                Object paramPath2;
                for (i = 0; i < paramNames.length; ++i) {
                    paramPath2 = nestedPath + paramNames[i];
                    if (failedParamNames.contains(paramPath2)) continue;
                    value = args[i];
                    this.getBindingResult().recordFieldValue((String)paramPath2, paramTypes[i], value);
                    this.validateConstructorArgument(ctor.getDeclaringClass(), nestedPath, paramNames[i], value);
                }
                paramPath2 = objectType.getSource();
                if (!(paramPath2 instanceof MethodParameter) || !(param = (MethodParameter)paramPath2).isOptional()) {
                    try {
                        result = BeanUtils.instantiateClass((Constructor)ctor, (Object[])args);
                    }
                    catch (BeanInstantiationException paramPath2) {}
                }
            } else {
                try {
                    result = BeanUtils.instantiateClass((Constructor)ctor, (Object[])args);
                }
                catch (BeanInstantiationException ex) {
                    if (KotlinDetector.isKotlinType((Class)clazz) && (value = ex.getCause()) instanceof NullPointerException) {
                        NullPointerException cause = (NullPointerException)value;
                        ObjectError error = new ObjectError(ctor.getName(), cause.getMessage());
                        this.getBindingResult().addError(error);
                    }
                    throw ex;
                }
            }
        }
        return isOptional && !nestedPath.isEmpty() ? Optional.ofNullable(result) : result;
    }

    protected boolean shouldConstructArgument(MethodParameter param) {
        Class type = param.nestedIfOptional().getNestedParameterType();
        return !BeanUtils.isSimpleValueType((Class)type) && !type.getPackageName().startsWith("java.");
    }

    private boolean hasValuesFor(String paramPath, ValueResolver resolver) {
        for (String name : resolver.getNames()) {
            if (!name.startsWith(paramPath + ".")) continue;
            return true;
        }
        return false;
    }

    @Nullable
    private List<?> createList(String paramPath, Class<?> paramType, ResolvableType type, ValueResolver valueResolver) {
        ResolvableType elementType = type.getNested(2);
        SortedSet<Integer> indexes = DataBinder.getIndexes(paramPath, valueResolver);
        if (indexes == null) {
            return null;
        }
        int lastIndex = Math.max(indexes.last(), 0);
        int size = lastIndex < this.autoGrowCollectionLimit ? lastIndex + 1 : 0;
        List list = (List)CollectionFactory.createCollection(paramType, (int)size);
        for (int i = 0; i < size; ++i) {
            list.add(null);
        }
        Iterator iterator = indexes.iterator();
        while (iterator.hasNext()) {
            int index = (Integer)iterator.next();
            String indexedPath = paramPath + "[" + String.valueOf(index != -1 ? Integer.valueOf(index) : "") + "]";
            list.set(Math.max(index, 0), this.createIndexedValue(paramPath, paramType, elementType, indexedPath, valueResolver));
        }
        return list;
    }

    @Nullable
    private <V> Map<String, V> createMap(String paramPath, Class<?> paramType, ResolvableType type, ValueResolver valueResolver) {
        ResolvableType elementType = type.getNested(2);
        Map map = null;
        for (String name : valueResolver.getNames()) {
            String key;
            if (!name.startsWith(paramPath + "[")) continue;
            int startIdx = paramPath.length() + 1;
            int endIdx = name.indexOf(93, startIdx);
            boolean quoted = endIdx - startIdx > 2 && name.charAt(startIdx) == '\'' && name.charAt(endIdx - 1) == '\'';
            String string = key = quoted ? name.substring(startIdx + 1, endIdx - 1) : name.substring(startIdx, endIdx);
            if (map == null) {
                map = CollectionFactory.createMap(paramType, (int)16);
            }
            String indexedPath = name.substring(0, endIdx + 1);
            map.put(key, this.createIndexedValue(paramPath, paramType, elementType, indexedPath, valueResolver));
        }
        return map;
    }

    @Nullable
    private <V> V[] createArray(String paramPath, Class<?> paramType, ResolvableType type, ValueResolver valueResolver) {
        ResolvableType elementType = type.getNested(2);
        SortedSet<Integer> indexes = DataBinder.getIndexes(paramPath, valueResolver);
        if (indexes == null) {
            return null;
        }
        int lastIndex = Math.max(indexes.last(), 0);
        int size = lastIndex < this.autoGrowCollectionLimit ? lastIndex + 1 : 0;
        Object[] array = (Object[])Array.newInstance(elementType.resolve(), size);
        Iterator iterator = indexes.iterator();
        while (iterator.hasNext()) {
            int index = (Integer)iterator.next();
            String indexedPath = paramPath + "[" + String.valueOf(index != -1 ? Integer.valueOf(index) : "") + "]";
            array[Math.max((int)index, (int)0)] = this.createIndexedValue(paramPath, paramType, elementType, indexedPath, valueResolver);
        }
        return array;
    }

    @Nullable
    private static SortedSet<Integer> getIndexes(String paramPath, ValueResolver valueResolver) {
        TreeSet<Integer> indexes = null;
        for (String name : valueResolver.getNames()) {
            int index;
            if (!name.startsWith(paramPath + "[")) continue;
            if (paramPath.length() + 2 == name.length()) {
                if (!name.endsWith("[]")) continue;
                index = -1;
            } else {
                int endIndex = name.indexOf(93, paramPath.length() + 2);
                String indexValue = name.substring(paramPath.length() + 1, endIndex);
                index = Integer.parseInt(indexValue);
            }
            indexes = indexes != null ? indexes : new TreeSet<Integer>();
            indexes.add(index);
        }
        return indexes;
    }

    @Nullable
    private <V> V createIndexedValue(String paramPath, Class<?> containerType, ResolvableType elementType, String indexedPath, ValueResolver valueResolver) {
        Object value = null;
        Class elementClass = elementType.resolve(Object.class);
        if (List.class.isAssignableFrom(elementClass)) {
            value = this.createList(indexedPath, elementClass, elementType, valueResolver);
        } else if (Map.class.isAssignableFrom(elementClass)) {
            value = this.createMap(indexedPath, elementClass, elementType, valueResolver);
        } else if (elementClass.isArray()) {
            value = this.createArray(indexedPath, elementClass, elementType, valueResolver);
        } else {
            Object rawValue = valueResolver.resolveValue(indexedPath, elementClass);
            if (rawValue != null) {
                try {
                    value = this.convertIfNecessary(rawValue, elementClass);
                }
                catch (TypeMismatchException ex) {
                    this.handleTypeMismatchException(ex, paramPath, containerType, rawValue);
                }
            } else {
                value = this.createObject(elementType, indexedPath + ".", valueResolver);
            }
        }
        return (V)value;
    }

    private void handleTypeMismatchException(TypeMismatchException ex, String paramPath, Class<?> paramType, @Nullable Object value) {
        ex.initPropertyName(paramPath);
        this.getBindingResult().recordFieldValue(paramPath, paramType, value);
        this.getBindingErrorProcessor().processPropertyAccessException((PropertyAccessException)ex, this.getBindingResult());
    }

    private void validateConstructorArgument(Class<?> constructorClass, String nestedPath, String name, @Nullable Object value) {
        Annotation[] annotationArray;
        Object[] hints = null;
        if (this.targetType != null && (annotationArray = this.targetType.getSource()) instanceof MethodParameter) {
            Annotation ann;
            MethodParameter parameter = (MethodParameter)annotationArray;
            annotationArray = parameter.getParameterAnnotations();
            int n = annotationArray.length;
            for (int i = 0; i < n && (hints = ValidationAnnotationUtils.determineValidationHints(ann = annotationArray[i])) == null; ++i) {
            }
        }
        if (hints == null) {
            return;
        }
        for (Validator validator : this.getValidatorsToApply()) {
            boolean isNested;
            if (!(validator instanceof SmartValidator)) continue;
            SmartValidator smartValidator = (SmartValidator)validator;
            boolean bl = isNested = !nestedPath.isEmpty();
            if (isNested) {
                this.getBindingResult().pushNestedPath(nestedPath.substring(0, nestedPath.length() - 1));
            }
            try {
                smartValidator.validateValue(constructorClass, name, value, this.getBindingResult(), hints);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
            if (!isNested) continue;
            this.getBindingResult().popNestedPath();
        }
    }

    public void bind(PropertyValues pvs) {
        MutablePropertyValues mutablePropertyValues;
        if (this.shouldNotBindPropertyValues()) {
            return;
        }
        MutablePropertyValues mpvs = pvs instanceof MutablePropertyValues ? (mutablePropertyValues = (MutablePropertyValues)pvs) : new MutablePropertyValues(pvs);
        this.doBind(mpvs);
    }

    protected boolean shouldNotBindPropertyValues() {
        return this.isDeclarativeBinding() && ObjectUtils.isEmpty((Object[])this.allowedFields);
    }

    protected void doBind(MutablePropertyValues mpvs) {
        this.checkAllowedFields(mpvs);
        this.checkRequiredFields(mpvs);
        this.applyPropertyValues(mpvs);
    }

    protected void checkAllowedFields(MutablePropertyValues mpvs) {
        PropertyValue[] pvs;
        for (PropertyValue pv : pvs = mpvs.getPropertyValues()) {
            String field = PropertyAccessorUtils.canonicalPropertyName((String)pv.getName());
            if (this.isAllowed(field)) continue;
            mpvs.removePropertyValue(pv);
            this.getBindingResult().recordSuppressedField(field);
            if (!logger.isDebugEnabled()) continue;
            logger.debug((Object)("Field [" + field + "] has been removed from PropertyValues and will not be bound, because it has not been found in the list of allowed fields"));
        }
    }

    protected boolean isAllowed(String field) {
        Object[] allowed = this.getAllowedFields();
        Object[] disallowed = this.getDisallowedFields();
        if (!ObjectUtils.isEmpty((Object[])allowed) && !PatternMatchUtils.simpleMatch((String[])allowed, (String)field)) {
            return false;
        }
        if (!ObjectUtils.isEmpty((Object[])disallowed)) {
            return !PatternMatchUtils.simpleMatchIgnoreCase((String[])disallowed, (String)field);
        }
        return true;
    }

    protected void checkRequiredFields(MutablePropertyValues mpvs) {
        Object[] requiredFields = this.getRequiredFields();
        if (!ObjectUtils.isEmpty((Object[])requiredFields)) {
            PropertyValue[] pvs;
            HashMap<String, PropertyValue> propertyValues = new HashMap<String, PropertyValue>();
            for (PropertyValue propertyValue : pvs = mpvs.getPropertyValues()) {
                String canonicalName = PropertyAccessorUtils.canonicalPropertyName((String)propertyValue.getName());
                propertyValues.put(canonicalName, propertyValue);
            }
            for (Object object : requiredFields) {
                boolean empty;
                PropertyValue pv = (PropertyValue)propertyValues.get(object);
                boolean bl = empty = pv == null || pv.getValue() == null;
                if (!empty) {
                    Object object2 = pv.getValue();
                    if (object2 instanceof String) {
                        String text = (String)object2;
                        empty = !StringUtils.hasText((String)text);
                    } else {
                        object2 = pv.getValue();
                        if (object2 instanceof String[]) {
                            String[] values = (String[])object2;
                            boolean bl2 = empty = values.length == 0 || !StringUtils.hasText((String)values[0]);
                        }
                    }
                }
                if (!empty) continue;
                this.getBindingErrorProcessor().processMissingFieldError((String)object, this.getInternalBindingResult());
                if (pv == null) continue;
                mpvs.removePropertyValue(pv);
                propertyValues.remove(object);
            }
        }
    }

    protected void applyPropertyValues(MutablePropertyValues mpvs) {
        try {
            this.getPropertyAccessor().setPropertyValues((PropertyValues)mpvs, this.isIgnoreUnknownFields(), this.isIgnoreInvalidFields());
        }
        catch (PropertyBatchUpdateException ex) {
            for (PropertyAccessException pae : ex.getPropertyAccessExceptions()) {
                this.getBindingErrorProcessor().processPropertyAccessException(pae, this.getInternalBindingResult());
            }
        }
    }

    public void validate() {
        Object target = this.getTarget();
        Assert.state((target != null ? 1 : 0) != 0, (String)"No target to validate");
        BindingResult bindingResult = this.getBindingResult();
        for (Validator validator : this.getValidatorsToApply()) {
            validator.validate(target, bindingResult);
        }
    }

    public void validate(Object ... validationHints) {
        Object target = this.getTarget();
        Assert.state((target != null ? 1 : 0) != 0, (String)"No target to validate");
        BindingResult bindingResult = this.getBindingResult();
        for (Validator validator : this.getValidatorsToApply()) {
            if (!ObjectUtils.isEmpty((Object[])validationHints) && validator instanceof SmartValidator) {
                SmartValidator smartValidator = (SmartValidator)validator;
                smartValidator.validate(target, bindingResult, validationHints);
                continue;
            }
            if (validator == null) continue;
            validator.validate(target, bindingResult);
        }
    }

    public Map<?, ?> close() throws BindException {
        if (this.getBindingResult().hasErrors()) {
            throw new BindException(this.getBindingResult());
        }
        return this.getBindingResult().getModel();
    }

    private static class ExtendedTypeConverter
    extends SimpleTypeConverter
    implements PropertyEditorRegistrar {
        private ExtendedTypeConverter() {
        }

        public void registerCustomEditors(PropertyEditorRegistry registry) {
            this.copyCustomEditorsTo(registry, null);
        }
    }

    public static interface NameResolver {
        @Nullable
        public String resolveName(MethodParameter var1);
    }

    public static interface ValueResolver {
        @Nullable
        public Object resolveValue(String var1, Class<?> var2);

        public Set<String> getNames();
    }
}

