/*
 *  Licensed to the Apache Software Foundation (ASF) under one or more
 *  contributor license agreements.  See the NOTICE file distributed with
 *  this work for additional information regarding copyright ownership.
 *  The ASF licenses this file to You under the Apache License, Version 2.0
 *  (the "License"); you may not use this file except in compliance with
 *  the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 *
 */

import { GeneralUtils } from '../GeneralUtils';

export class DataExplorerBtns {
    public static refreshDataLakeMeasures() {
        return cy.dataCy('refresh-data-lake-measures');
    }

    public static saveDataViewButton() {
        return cy.dataCy('save-data-view-btn').click();
    }

    public static saveDashboard() {
        return cy.dataCy('save-data-view').click();
    }
    public static saveChartsToAssetBtn() {
        return cy
            .dataCy('add-to-Asset-data-view-btn', { timeout: 10000 })
            .should('exist')
            .click();
    }

    public static chartAssetCheckboxBtn() {
        return cy.dataCy('add-to-Asset-data-view-btn');
    }
    public static confirmAssetSelectionBtn() {
        return cy
            .dataCy('asset-dialog-confirm-delete', { timeout: 10000 })
            .click();
    }
    public static editDataViewButton(widgetName: string) {
        GeneralUtils.openMenuForRow(widgetName);
        return cy
            .dataCy('edit-data-view-' + widgetName.replaceAll(' ', ''))
            .click();
    }

    public static dashboardAssetCheckboxBtn() {
        return cy.dataCy('sp-show-dashboard-asset-checkbox');
    }

    public static closeDashboardCreate() {
        return cy.dataCy('close-data-view');
    }
}
