/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.maven.bundlesupport;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.hc.client5.http.impl.classic.CloseableHttpClient;
import org.apache.maven.model.Resource;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.apache.sling.maven.bundlesupport.AbstractBundleRequestMojo;

abstract class AbstractFsMountMojo
extends AbstractBundleRequestMojo {
    @Parameter(property="sling.file", defaultValue="${project.build.directory}/${project.build.finalName}.jar")
    private String bundleFileName;
    @Parameter(property="sling.filevault.jcr_root.file")
    private File fileVaultJcrRootFile;
    @Parameter(property="sling.filevault.filterxml.file")
    private File fileVaultFilterXmlFile;
    @Parameter(property="sling.fsmount.skip", defaultValue="false")
    private boolean skip;
    @Parameter(defaultValue="${project}", readonly=true)
    protected MavenProject project;

    AbstractFsMountMojo() {
    }

    public void execute() throws MojoExecutionException, MojoFailureException {
        if (this.skip) {
            this.getLog().info((CharSequence)"Skipping fsmount/fsunmount operation as instructed.");
            return;
        }
        URI consoleTargetUrl = this.getConsoleTargetURL();
        try (CloseableHttpClient httpClient = this.getHttpClient();){
            this.ensureBundlesInstalled(httpClient, consoleTargetUrl);
            File bundleFile = new File(this.bundleFileName);
            if (bundleFile.exists()) {
                this.configureSlingInitialContent(httpClient, consoleTargetUrl, bundleFile);
                return;
            }
            this.getLog().debug((CharSequence)("Bundle file at " + this.bundleFileName + " does not exist"));
            File jcrRootFile = this.fileVaultJcrRootFile != null ? this.fileVaultJcrRootFile : this.detectJcrRootFile();
            File filterXmlFile = this.fileVaultFilterXmlFile != null ? this.fileVaultFilterXmlFile : this.detectFilterXmlFile();
            if (jcrRootFile != null && filterXmlFile != null) {
                if (jcrRootFile.exists() && filterXmlFile.exists()) {
                    this.configureFileVaultXml(httpClient, consoleTargetUrl, jcrRootFile, filterXmlFile);
                    return;
                }
                this.getLog().warn((CharSequence)("jcr_root directory at " + jcrRootFile + " and/or filter.xml file at " + filterXmlFile + " does not exist"));
            } else {
                this.getLog().warn((CharSequence)"Could not auto-detect jcr_root directory and/or filter.xml file");
            }
        }
        catch (IOException e) {
            this.getLog().error((CharSequence)("Could not close underlying HTTP client" + e.getMessage()), (Throwable)e);
        }
        this.getLog().warn((CharSequence)"No Bundle with initial content or FileVault content package found - skipping.");
    }

    private File detectJcrRootFile() {
        List resources = this.project.getResources();
        if (resources != null) {
            for (Resource resource : resources) {
                File dir = new File(resource.getDirectory());
                if (dir.exists() && dir.isDirectory() && StringUtils.equals((CharSequence)dir.getName(), (CharSequence)"jcr_root")) {
                    return dir;
                }
                this.getLog().debug((CharSequence)("Maven project resource directory " + dir + " does not have name jcr_root and therefore cannot be FileVault package root"));
            }
        } else {
            this.getLog().debug((CharSequence)"This Maven project does not have any resources");
        }
        return null;
    }

    private File detectFilterXmlFile() {
        List resources = this.project.getResources();
        if (resources != null) {
            for (Resource resource : resources) {
                File filterXml;
                File dir = new File(resource.getDirectory());
                if (!dir.exists() || !dir.isDirectory() || !(StringUtils.equals((CharSequence)dir.getName(), (CharSequence)"META-INF") ? (filterXml = new File(dir, "vault/filter.xml")).exists() : (StringUtils.equals((CharSequence)dir.getName(), (CharSequence)"vault") ? (filterXml = new File(dir, "filter.xml")).exists() : StringUtils.equals((CharSequence)dir.getName(), (CharSequence)"jcr_root") && (filterXml = new File(dir.getParentFile(), "META-INF/vault/filter.xml")).exists()))) continue;
                return filterXml;
            }
        }
        return null;
    }

    protected abstract void configureSlingInitialContent(CloseableHttpClient var1, URI var2, File var3) throws MojoExecutionException;

    protected abstract void configureFileVaultXml(CloseableHttpClient var1, URI var2, File var3, File var4) throws MojoExecutionException;

    protected abstract void ensureBundlesInstalled(CloseableHttpClient var1, URI var2) throws MojoExecutionException;
}

