/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.validation.impl;

import java.util.function.Predicate;
import javax.annotation.Nonnull;
import org.apache.sling.api.resource.AbstractResourceVisitor;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceUtil;
import org.apache.sling.validation.ValidationResult;
import org.apache.sling.validation.impl.CompositeValidationResult;
import org.apache.sling.validation.impl.ValidationServiceImpl;
import org.apache.sling.validation.model.ValidationModel;

public class ValidationResourceVisitor
extends AbstractResourceVisitor {
    private final ValidationServiceImpl validationService;
    private final String rootResourcePath;
    private final boolean enforceValidation;
    private final boolean considerResourceSuperTypeModels;
    @Nonnull
    private final CompositeValidationResult result;
    private final Predicate<Resource> filter;

    public ValidationResourceVisitor(ValidationServiceImpl validationService, String rootResourcePath, boolean enforceValidation, Predicate<Resource> filter, boolean considerResourceSuperTypeModels) {
        this.validationService = validationService;
        this.rootResourcePath = rootResourcePath + "/";
        this.enforceValidation = enforceValidation;
        this.considerResourceSuperTypeModels = considerResourceSuperTypeModels;
        this.filter = filter;
        this.result = new CompositeValidationResult();
    }

    protected void visit(Resource resource) {
        if (this.isValidSubResource(resource)) {
            ValidationModel model = this.validationService.getValidationModel(resource, this.considerResourceSuperTypeModels);
            if (model == null) {
                if (this.enforceValidation) {
                    throw new IllegalArgumentException("No model for resource type " + resource.getResourceType() + " found.");
                }
                return;
            }
            String relativePath = resource.getPath().startsWith(this.rootResourcePath) ? resource.getPath().substring(this.rootResourcePath.length()) : "";
            ValidationResult localResult = this.validationService.validate(resource, model, relativePath);
            this.result.addValidationResult(localResult);
        }
    }

    private boolean isValidSubResource(@Nonnull Resource resource) {
        if (ResourceUtil.isNonExistingResource((Resource)resource)) {
            return false;
        }
        if (this.filter != null) {
            return this.filter.test(resource);
        }
        return true;
    }

    @Nonnull
    public CompositeValidationResult getResult() {
        return this.result;
    }
}

