/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.testing.mock.sling;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Dictionary;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.sling.adapter.Adaption;
import org.apache.sling.adapter.internal.AdaptionImpl;
import org.apache.sling.api.adapter.AdapterFactory;
import org.apache.sling.api.adapter.AdapterManager;
import org.apache.sling.commons.osgi.PropertiesUtil;
import org.jetbrains.annotations.NotNull;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(immediate=true, service={AdapterManager.class}, property={"service.description=Sling Adapter Manager", "service.vendor=The Apache Software Foundation"}, reference={@Reference(name="AdapterFactory", service=AdapterFactory.class, cardinality=ReferenceCardinality.MULTIPLE, policy=ReferencePolicy.DYNAMIC, bind="bindAdapterFactory", unbind="unbindAdapterFactory")})
public class MockAdapterManagerImpl
implements AdapterManager {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private volatile ComponentContext context;
    private final List<ServiceReference<AdapterFactory>> boundAdapterFactories = new LinkedList<ServiceReference<AdapterFactory>>();
    private final Map<String, AdapterFactoryDescriptorMap> descriptors = new HashMap<String, AdapterFactoryDescriptorMap>();
    private final ConcurrentMap<String, Map<String, List<AdapterFactoryDescriptor>>> factoryCache = new ConcurrentHashMap<String, Map<String, List<AdapterFactoryDescriptor>>>();

    public <AdapterType> AdapterType getAdapter(@NotNull Object adaptable, @NotNull Class<AdapterType> type) {
        Map<String, List<AdapterFactoryDescriptor>> factories = this.getAdapterFactories(adaptable.getClass());
        List<AdapterFactoryDescriptor> descList = factories.get(type.getName());
        if (descList != null && !descList.isEmpty()) {
            for (AdapterFactoryDescriptor desc : descList) {
                AdapterFactory factory = desc == null ? null : desc.getFactory();
                if (factory == null) continue;
                this.log.debug("Trying adapter factory {} to map {} to {}", new Object[]{factory, adaptable, type});
                Object adaptedObject = factory.getAdapter(adaptable, type);
                if (adaptedObject == null) continue;
                this.log.debug("Using adapter factory {} to map {} to {}", new Object[]{factory, adaptable, type});
                return (AdapterType)adaptedObject;
            }
        }
        this.log.debug("No adapter factory found to map {} to {}", adaptable, type);
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void activate(ComponentContext context) {
        ArrayList<ServiceReference<AdapterFactory>> refs;
        this.context = context;
        List<ServiceReference<AdapterFactory>> list = this.boundAdapterFactories;
        synchronized (list) {
            refs = new ArrayList<ServiceReference<AdapterFactory>>(this.boundAdapterFactories);
            this.boundAdapterFactories.clear();
        }
        for (ServiceReference serviceReference : refs) {
            this.registerAdapterFactory(context, (ServiceReference<AdapterFactory>)serviceReference);
        }
    }

    protected void deactivate(ComponentContext context) {
        this.context = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void bindAdapterFactory(ServiceReference<AdapterFactory> reference) {
        boolean create = true;
        if (this.context == null) {
            List<ServiceReference<AdapterFactory>> list = this.boundAdapterFactories;
            synchronized (list) {
                if (this.context == null) {
                    this.boundAdapterFactories.add(reference);
                    create = false;
                }
            }
        }
        if (create) {
            this.registerAdapterFactory(this.context, reference);
        }
    }

    protected void unbindAdapterFactory(ServiceReference<AdapterFactory> reference) {
        this.unregisterAdapterFactory(reference);
    }

    Map<String, AdapterFactoryDescriptorMap> getFactories() {
        return this.descriptors;
    }

    Map<String, Map<String, List<AdapterFactoryDescriptor>>> getFactoryCache() {
        return this.factoryCache;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void registerAdapterFactory(ComponentContext context, ServiceReference<AdapterFactory> reference) {
        Object[] adaptables = PropertiesUtil.toStringArray((Object)reference.getProperty("adaptables"));
        Object[] adapters = PropertiesUtil.toStringArray((Object)reference.getProperty("adapters"));
        if (adaptables == null || adaptables.length == 0 || adapters == null || adapters.length == 0) {
            return;
        }
        AdapterFactoryDescriptor factoryDesc = new AdapterFactoryDescriptor(context, reference, (String[])adapters);
        for (String string : adaptables) {
            AdapterFactoryDescriptorMap adfMap = null;
            AdapterFactoryDescriptorMap adapterFactoryDescriptorMap = this.descriptors;
            synchronized (adapterFactoryDescriptorMap) {
                adfMap = this.descriptors.get(string);
                if (adfMap == null) {
                    adfMap = new AdapterFactoryDescriptorMap();
                    this.descriptors.put(string, adfMap);
                }
            }
            adapterFactoryDescriptorMap = adfMap;
            synchronized (adapterFactoryDescriptorMap) {
                adfMap.put(reference, factoryDesc);
            }
        }
        this.factoryCache.clear();
        Hashtable<String, Object[]> props = new Hashtable<String, Object[]>();
        ((Dictionary)props).put("adaptables", adaptables);
        ((Dictionary)props).put("adapters", adapters);
        ServiceRegistration adaptionRegistration = this.context.getBundleContext().registerService(Adaption.class, (Object)AdaptionImpl.INSTANCE, props);
        if (this.log.isDebugEnabled()) {
            this.log.debug("Registered service {} with {} : {} and {} : {}", new Object[]{Adaption.class.getName(), "adaptables", Arrays.toString(adaptables), "adapters", Arrays.toString(adapters)});
        }
        factoryDesc.setAdaption((ServiceRegistration<Adaption>)adaptionRegistration);
    }

    static String getPackageName(String clazz) {
        int lastDot = clazz.lastIndexOf(46);
        return lastDot <= 0 ? "" : clazz.substring(0, lastDot);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void unregisterAdapterFactory(ServiceReference<AdapterFactory> reference) {
        List<ServiceReference<AdapterFactory>> list = this.boundAdapterFactories;
        synchronized (list) {
            this.boundAdapterFactories.remove(reference);
        }
        Object[] adaptables = PropertiesUtil.toStringArray((Object)reference.getProperty("adaptables"));
        Object[] adapters = PropertiesUtil.toStringArray((Object)reference.getProperty("adapters"));
        if (adaptables == null || adaptables.length == 0 || adapters == null || adapters.length == 0) {
            return;
        }
        boolean factoriesModified = false;
        AdapterFactoryDescriptorMap adfMap = null;
        AdapterFactoryDescriptor removedDescriptor = null;
        for (String string : adaptables) {
            AdapterFactoryDescriptorMap adapterFactoryDescriptorMap = this.descriptors;
            synchronized (adapterFactoryDescriptorMap) {
                adfMap = this.descriptors.get(string);
            }
            if (adfMap == null) continue;
            adapterFactoryDescriptorMap = adfMap;
            synchronized (adapterFactoryDescriptorMap) {
                AdapterFactoryDescriptor factoryDesc = (AdapterFactoryDescriptor)adfMap.remove(reference);
                if (factoryDesc != null) {
                    factoriesModified = true;
                    if (removedDescriptor != null && removedDescriptor != factoryDesc) {
                        this.log.error("When unregistering reference {} got duplicate service descriptors {} and {}. Unregistration of {} services may be incomplete.", new Object[]{reference, removedDescriptor, factoryDesc, Adaption.class.getName()});
                    }
                    removedDescriptor = factoryDesc;
                }
            }
        }
        if (factoriesModified) {
            this.factoryCache.clear();
        }
        if (removedDescriptor != null) {
            removedDescriptor.getAdaption().unregister();
            if (this.log.isDebugEnabled()) {
                this.log.debug("Unregistered service {} with {} : {} and {} : {}", new Object[]{Adaption.class.getName(), "adaptables", Arrays.toString(adaptables), "adapters", Arrays.toString(adapters)});
            }
        }
    }

    private Map<String, List<AdapterFactoryDescriptor>> getAdapterFactories(Class<?> clazz) {
        String className = clazz.getName();
        Map<String, List<AdapterFactoryDescriptor>> entry = (Map<String, List<AdapterFactoryDescriptor>>)this.factoryCache.get(className);
        if (entry == null) {
            entry = this.createAdapterFactoryMap(clazz);
            this.factoryCache.put(className, entry);
        }
        return entry;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    private Map<String, List<AdapterFactoryDescriptor>> createAdapterFactoryMap(Class<?> clazz) {
        Object object;
        HashMap<String, List<AdapterFactoryDescriptor>> afm = new HashMap<String, List<AdapterFactoryDescriptor>>();
        Class<?>[] afdMap = null;
        Map<String, AdapterFactoryDescriptorMap> map = this.descriptors;
        // MONITORENTER : map
        afdMap = this.descriptors.get(clazz.getName());
        // MONITOREXIT : map
        if (afdMap != null) {
            object = afdMap;
            // MONITORENTER : afdMap
            ArrayList afdSet = new ArrayList(afdMap.values());
            // MONITOREXIT : object
            for (AdapterFactoryDescriptor afd : afdSet) {
                String[] adapters;
                for (String adapter : adapters = afd.getAdapters()) {
                    ArrayList<AdapterFactoryDescriptor> factoryDescriptors = (ArrayList<AdapterFactoryDescriptor>)afm.get(adapter);
                    if (factoryDescriptors == null) {
                        factoryDescriptors = new ArrayList<AdapterFactoryDescriptor>();
                        afm.put(adapter, factoryDescriptors);
                    }
                    factoryDescriptors.add(afd);
                }
            }
        }
        Class<?>[] interfaces = clazz.getInterfaces();
        object = interfaces;
        int n = ((Class<?>[])object).length;
        int n2 = 0;
        while (true) {
            if (n2 >= n) {
                Class<?> superClazz = clazz.getSuperclass();
                if (superClazz == null) return afm;
                this.copyAdapterFactories(afm, superClazz);
                return afm;
            }
            Class<?> iFace = object[n2];
            this.copyAdapterFactories(afm, iFace);
            ++n2;
        }
    }

    private void copyAdapterFactories(Map<String, List<AdapterFactoryDescriptor>> dest, Class<?> clazz) {
        Map<String, List<AdapterFactoryDescriptor>> scMap = this.getAdapterFactories(clazz);
        for (Map.Entry<String, List<AdapterFactoryDescriptor>> entry : scMap.entrySet()) {
            List<AdapterFactoryDescriptor> factoryDescriptors = dest.get(entry.getKey());
            if (factoryDescriptors == null) {
                factoryDescriptors = new ArrayList<AdapterFactoryDescriptor>();
                dest.put(entry.getKey(), factoryDescriptors);
            }
            for (AdapterFactoryDescriptor descriptor : entry.getValue()) {
                factoryDescriptors.add(descriptor);
            }
        }
    }

    static class AdapterFactoryDescriptor {
        private volatile AdapterFactory factory;
        private final String[] adapters;
        private final ServiceReference<AdapterFactory> reference;
        private final ComponentContext context;
        private volatile ServiceRegistration<Adaption> adaption;

        public AdapterFactoryDescriptor(ComponentContext context, ServiceReference<AdapterFactory> reference, String[] adapters) {
            this.reference = reference;
            this.context = context;
            this.adapters = adapters;
        }

        public AdapterFactory getFactory() {
            if (this.factory == null) {
                this.factory = (AdapterFactory)this.context.locateService("AdapterFactory", this.reference);
            }
            return this.factory;
        }

        public String[] getAdapters() {
            return this.adapters;
        }

        public ServiceRegistration<Adaption> getAdaption() {
            return this.adaption;
        }

        public void setAdaption(ServiceRegistration<Adaption> adaption) {
            this.adaption = adaption;
        }
    }

    static class AdapterFactoryDescriptorMap
    extends TreeMap<ServiceReference<AdapterFactory>, AdapterFactoryDescriptor> {
        private static final long serialVersionUID = 2L;

        AdapterFactoryDescriptorMap() {
        }
    }
}

