/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.spi.security.user.action;

import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import javax.jcr.RepositoryException;
import javax.jcr.nodetype.ConstraintViolationException;
import org.apache.jackrabbit.api.security.user.User;
import org.apache.jackrabbit.oak.api.Root;
import org.apache.jackrabbit.oak.namepath.NamePathMapper;
import org.apache.jackrabbit.oak.spi.security.ConfigurationParameters;
import org.apache.jackrabbit.oak.spi.security.SecurityProvider;
import org.apache.jackrabbit.oak.spi.security.user.action.AbstractAuthorizableAction;
import org.apache.jackrabbit.oak.spi.security.user.util.PasswordUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PasswordValidationAction
extends AbstractAuthorizableAction {
    private static final Logger log = LoggerFactory.getLogger(PasswordValidationAction.class);
    public static final String CONSTRAINT = "constraint";
    private Pattern pattern;

    @Override
    public void init(SecurityProvider securityProvider, ConfigurationParameters config) {
        String constraint = config.getConfigValue(CONSTRAINT, null, String.class);
        if (constraint != null) {
            this.setConstraint(constraint);
        }
    }

    @Override
    public void onCreate(@NotNull User user, @Nullable String password, @NotNull Root root, @NotNull NamePathMapper namePathMapper) throws RepositoryException {
        this.validatePassword(password, false);
    }

    @Override
    public void onPasswordChange(@NotNull User user, @Nullable String newPassword, @NotNull Root root, @NotNull NamePathMapper namePathMapper) throws RepositoryException {
        this.validatePassword(newPassword, true);
    }

    private void setConstraint(@NotNull String constraint) {
        try {
            this.pattern = Pattern.compile(constraint);
        }
        catch (PatternSyntaxException e) {
            log.warn("Invalid password constraint: {}", (Object)e.getMessage());
        }
    }

    private void validatePassword(@Nullable String password, boolean forceMatch) throws RepositoryException {
        if (password != null && (forceMatch || PasswordUtil.isPlainTextPassword(password)) && this.pattern != null && !this.pattern.matcher(password).matches()) {
            throw new ConstraintViolationException("Password violates password constraint (" + this.pattern.pattern() + ").");
        }
    }
}

