/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.spi.security.user.action;

import javax.jcr.RepositoryException;
import javax.jcr.nodetype.ConstraintViolationException;
import org.apache.jackrabbit.api.security.user.User;
import org.apache.jackrabbit.oak.api.Root;
import org.apache.jackrabbit.oak.namepath.NamePathMapper;
import org.apache.jackrabbit.oak.plugins.tree.TreeUtil;
import org.apache.jackrabbit.oak.spi.security.user.action.AbstractAuthorizableAction;
import org.apache.jackrabbit.oak.spi.security.user.util.PasswordUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PasswordChangeAction
extends AbstractAuthorizableAction {
    @Override
    public void onPasswordChange(@NotNull User user, String newPassword, @NotNull Root root, @NotNull NamePathMapper namePathMapper) throws RepositoryException {
        if (newPassword == null) {
            throw new ConstraintViolationException("Expected a new password that is not null.");
        }
        String pwHash = this.getPasswordHash(root, user);
        if (PasswordUtil.isSame(pwHash, newPassword)) {
            throw new ConstraintViolationException("New password is identical to the old password.");
        }
    }

    @Nullable
    private String getPasswordHash(@NotNull Root root, @NotNull User user) throws RepositoryException {
        return TreeUtil.getString(root.getTree(user.getPath()), "rep:password");
    }
}

