/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.spi.commit;

import org.apache.jackrabbit.oak.api.CommitFailedException;
import org.apache.jackrabbit.oak.spi.commit.CommitHook;
import org.apache.jackrabbit.oak.spi.commit.CommitInfo;
import org.apache.jackrabbit.oak.spi.commit.Editor;
import org.apache.jackrabbit.oak.spi.commit.EditorDiff;
import org.apache.jackrabbit.oak.spi.commit.EditorProvider;
import org.apache.jackrabbit.oak.spi.state.NodeBuilder;
import org.apache.jackrabbit.oak.spi.state.NodeState;
import org.jetbrains.annotations.NotNull;
import sling-mock-oak.com.google.common.base.Preconditions;

public class EditorHook
implements CommitHook {
    private final EditorProvider provider;

    public EditorHook(@NotNull EditorProvider provider) {
        this.provider = Preconditions.checkNotNull(provider);
    }

    @Override
    @NotNull
    public NodeState processCommit(@NotNull NodeState before, @NotNull NodeState after, @NotNull CommitInfo info) throws CommitFailedException {
        Preconditions.checkNotNull(before);
        Preconditions.checkNotNull(after);
        Preconditions.checkNotNull(info);
        NodeBuilder builder = after.builder();
        Editor editor = this.provider.getRootEditor(before, after, builder, info);
        CommitFailedException exception = EditorDiff.process(editor, before, after);
        if (exception == null) {
            return builder.getNodeState();
        }
        throw exception;
    }

    public String toString() {
        return "EditorHook : (" + this.provider + ")";
    }
}

