/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.security.authorization.restriction;

import java.util.Set;
import org.apache.jackrabbit.oak.api.PropertyState;
import org.apache.jackrabbit.oak.api.Tree;
import org.apache.jackrabbit.oak.commons.PathUtils;
import org.apache.jackrabbit.oak.spi.security.authorization.restriction.RestrictionPattern;
import org.apache.jackrabbit.util.Text;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import sling-mock-oak.com.google.common.collect.ImmutableSet;

class PrefixPattern
implements RestrictionPattern {
    private final Set<String> prefixes;

    PrefixPattern(@NotNull Iterable<String> prefixes) {
        this.prefixes = ImmutableSet.copyOf(prefixes);
    }

    @Override
    public boolean matches(@NotNull Tree tree, @Nullable PropertyState property) {
        String name = property != null ? property.getName() : tree.getName();
        return this.matchesPrefix(name);
    }

    @Override
    public boolean matches(@NotNull String path) {
        return this.matchesPrefix(PathUtils.getName(path));
    }

    private boolean matchesPrefix(String name) {
        String prefix = Text.getNamespacePrefix(name);
        return this.prefixes.contains(prefix);
    }

    @Override
    public boolean matches() {
        return false;
    }

    public int hashCode() {
        return this.prefixes.hashCode();
    }

    public String toString() {
        return this.prefixes.toString();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof PrefixPattern) {
            PrefixPattern other = (PrefixPattern)obj;
            return this.prefixes.equals(other.prefixes);
        }
        return false;
    }
}

