/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core.query.lucene;

import java.io.IOException;
import org.apache.jackrabbit.core.HierarchyManager;
import org.apache.jackrabbit.core.id.NodeId;
import org.apache.jackrabbit.core.id.PropertyId;
import org.apache.jackrabbit.core.query.lucene.AbstractScoreDocComparator;
import org.apache.jackrabbit.core.query.lucene.FieldNames;
import org.apache.jackrabbit.core.query.lucene.FieldSelectors;
import org.apache.jackrabbit.core.query.lucene.NamespaceMappings;
import org.apache.jackrabbit.core.query.lucene.SharedFieldCache;
import org.apache.jackrabbit.core.query.lucene.Util;
import org.apache.jackrabbit.core.state.ItemStateManager;
import org.apache.jackrabbit.core.state.PropertyState;
import org.apache.jackrabbit.core.value.InternalValue;
import org.apache.jackrabbit.spi.Path;
import org.apache.jackrabbit.spi.PathFactory;
import org.apache.jackrabbit.spi.commons.conversion.IllegalNameException;
import org.apache.jackrabbit.spi.commons.name.PathBuilder;
import org.apache.jackrabbit.spi.commons.name.PathFactoryImpl;
import org.apache.lucene.document.Document;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.search.ScoreDoc;
import org.apache.lucene.search.ScoreDocComparator;
import org.apache.lucene.search.SortComparator;
import org.apache.lucene.search.SortComparatorSource;

public class SharedFieldSortComparator
extends SortComparator {
    private static final long serialVersionUID = 2609351820466200052L;
    private final String field;
    private final ItemStateManager ism;
    private final HierarchyManager hmgr;
    private final NamespaceMappings nsMappings;

    public SharedFieldSortComparator(String fieldname, ItemStateManager ism, HierarchyManager hmgr, NamespaceMappings nsMappings) {
        this.field = fieldname;
        this.ism = ism;
        this.hmgr = hmgr;
        this.nsMappings = nsMappings;
    }

    public ScoreDocComparator newComparator(IndexReader reader, String relPath) throws IOException {
        PathFactory factory = PathFactoryImpl.getInstance();
        Path p = factory.create(relPath);
        try {
            SimpleScoreDocComparator simple = new SimpleScoreDocComparator(reader, this.nsMappings.translatePath(p));
            if (p.getLength() == 1) {
                return simple;
            }
            return new CompoundScoreDocComparator(reader, new ScoreDocComparator[]{simple, new RelPathScoreDocComparator(reader, p)});
        }
        catch (IllegalNameException e) {
            throw Util.createIOException((Throwable)((Object)e));
        }
    }

    protected Comparable getComparable(String termtext) {
        throw new UnsupportedOperationException();
    }

    private final class CompoundScoreDocComparator
    extends AbstractScoreDocComparator {
        private final ScoreDocComparator[] comparators;

        public CompoundScoreDocComparator(IndexReader reader, ScoreDocComparator[] comparators) throws IOException {
            super(reader);
            this.comparators = comparators;
        }

        public Comparable sortValue(ScoreDoc i) {
            for (ScoreDocComparator comparator : this.comparators) {
                Comparable c = comparator.sortValue(i);
                if (c == null) continue;
                return c;
            }
            return null;
        }
    }

    private final class RelPathScoreDocComparator
    extends AbstractScoreDocComparator {
        private final Path relPath;

        public RelPathScoreDocComparator(IndexReader reader, Path relPath) throws IOException {
            super(reader);
            this.relPath = relPath;
        }

        public Comparable sortValue(ScoreDoc i) {
            try {
                int idx = this.readerIndex(i.doc);
                IndexReader reader = (IndexReader)this.readers.get(idx);
                Document doc = reader.document(i.doc - this.starts[idx], FieldSelectors.UUID);
                String uuid = doc.get(FieldNames.UUID);
                Path path = SharedFieldSortComparator.this.hmgr.getPath(new NodeId(uuid));
                PathBuilder builder = new PathBuilder(path);
                builder.addAll(this.relPath.getElements());
                PropertyId id = SharedFieldSortComparator.this.hmgr.resolvePropertyPath(builder.getPath());
                if (id == null) {
                    return null;
                }
                PropertyState state = (PropertyState)SharedFieldSortComparator.this.ism.getItemState(id);
                if (state == null) {
                    return null;
                }
                InternalValue[] values = state.getValues();
                if (values.length > 0) {
                    return Util.getComparable(values[0]);
                }
                return null;
            }
            catch (Exception e) {
                return null;
            }
        }
    }

    private final class SimpleScoreDocComparator
    extends AbstractScoreDocComparator {
        protected final SharedFieldCache.ValueIndex[] indexes;

        public SimpleScoreDocComparator(IndexReader reader, String propertyName) throws IOException {
            super(reader);
            this.indexes = new SharedFieldCache.ValueIndex[this.readers.size()];
            String namedValue = FieldNames.createNamedValue(propertyName, "");
            for (int i = 0; i < this.readers.size(); ++i) {
                IndexReader r = (IndexReader)this.readers.get(i);
                this.indexes[i] = SharedFieldCache.INSTANCE.getValueIndex(r, SharedFieldSortComparator.this.field, namedValue, (SortComparatorSource)SharedFieldSortComparator.this);
            }
        }

        public Comparable sortValue(ScoreDoc i) {
            int idx = this.readerIndex(i.doc);
            return this.indexes[idx].getValue(i.doc - this.starts[idx]);
        }
    }
}

