/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.sitemap.spi.generator;

import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.sitemap.SitemapException;
import org.apache.sling.sitemap.SitemapUtil;
import org.apache.sling.sitemap.builder.Sitemap;
import org.apache.sling.sitemap.spi.generator.SitemapGenerator;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.osgi.annotation.versioning.ConsumerType;

@ConsumerType
public abstract class ResourceTreeSitemapGenerator
implements SitemapGenerator {
    protected static final String PROPERTY_LAST_PATH = "lastPath";

    @Override
    public final void generate(@NotNull Resource sitemapRoot, @NotNull String name, @NotNull Sitemap sitemap, @NotNull SitemapGenerator.Context context) throws SitemapException {
        String lastPath = (String)((Object)context.getProperty(PROPERTY_LAST_PATH, String.class));
        for (Resource descendant : this.traverse(sitemapRoot, lastPath)::iterator) {
            this.addResource(name, sitemap, descendant);
            context.setProperty(PROPERTY_LAST_PATH, descendant.getPath());
        }
    }

    protected abstract void addResource(@NotNull String var1, @NotNull Sitemap var2, @NotNull Resource var3) throws SitemapException;

    protected boolean shouldInclude(@NotNull Resource resource) {
        return resource.getChild("jcr:content") != null;
    }

    protected boolean shouldFollow(@NotNull Resource resource) {
        return !"jcr:content".equals(resource.getName()) && !SitemapUtil.isSitemapRoot(resource);
    }

    private Stream<Resource> traverse(@NotNull Resource sitemapRoot, @Nullable String skipTo) {
        Stream<Resource> children = StreamSupport.stream(sitemapRoot.getChildren().spliterator(), false).filter(this::shouldFollow);
        if (skipTo != null) {
            AtomicBoolean found = new AtomicBoolean(false);
            return children.flatMap(child -> {
                if (found.get()) {
                    return this.traverse((Resource)child, null);
                }
                if (skipTo.equals(child.getPath())) {
                    found.set(true);
                    return this.traverse((Resource)child, null);
                }
                if (skipTo.startsWith(child.getPath() + '/')) {
                    found.set(true);
                    return this.traverse((Resource)child, skipTo);
                }
                return Stream.empty();
            });
        }
        return Stream.concat(this.shouldInclude(sitemapRoot) ? Stream.of(sitemapRoot) : Stream.empty(), children.flatMap(child -> this.traverse((Resource)child, null)));
    }
}

