/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.scripting.thymeleaf.internal;

import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.scripting.thymeleaf.TemplateModeProvider;
import org.apache.sling.scripting.thymeleaf.internal.PatternTemplateModeProviderConfiguration;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Modified;
import org.osgi.service.metatype.annotations.Designate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.thymeleaf.templatemode.TemplateMode;

@Component(immediate=true, property={"service.description=Pattern TemplateModeProvider for Sling Scripting Thymeleaf", "service.vendor=The Apache Software Foundation"})
@Designate(ocd=PatternTemplateModeProviderConfiguration.class)
public class PatternTemplateModeProvider
implements TemplateModeProvider {
    private Pattern htmlPattern;
    private Pattern xmlPattern;
    private Pattern textPattern;
    private Pattern javascriptPattern;
    private Pattern cssPattern;
    private Pattern rawPattern;
    private final Logger logger = LoggerFactory.getLogger(PatternTemplateModeProvider.class);

    @Activate
    private void activate(PatternTemplateModeProviderConfiguration configuration) {
        this.logger.debug("activating");
        this.configure(configuration);
    }

    @Modified
    private void modified(PatternTemplateModeProviderConfiguration configuration) {
        this.logger.debug("modifying");
        this.configure(configuration);
    }

    @Deactivate
    private void deactivate() {
        this.logger.debug("deactivating");
    }

    private void configure(PatternTemplateModeProviderConfiguration configuration) {
        this.htmlPattern = StringUtils.isNotBlank((CharSequence)configuration.htmlPattern()) ? Pattern.compile(configuration.htmlPattern()) : null;
        this.logger.debug("configured HTML pattern: {}", (Object)this.htmlPattern);
        this.xmlPattern = StringUtils.isNotBlank((CharSequence)configuration.xmlPattern()) ? Pattern.compile(configuration.xmlPattern()) : null;
        this.logger.debug("configured XML pattern: {}", (Object)this.xmlPattern);
        this.textPattern = StringUtils.isNotBlank((CharSequence)configuration.textPattern()) ? Pattern.compile(configuration.textPattern()) : null;
        this.logger.debug("configured TEXT pattern: {}", (Object)this.textPattern);
        this.javascriptPattern = StringUtils.isNotBlank((CharSequence)configuration.javascriptPattern()) ? Pattern.compile(configuration.javascriptPattern()) : null;
        this.logger.debug("configured JAVASCRIPT pattern: {}", (Object)this.javascriptPattern);
        this.cssPattern = StringUtils.isNotBlank((CharSequence)configuration.cssPattern()) ? Pattern.compile(configuration.cssPattern()) : null;
        this.logger.debug("configured CSS pattern: {}", (Object)this.cssPattern);
        this.rawPattern = StringUtils.isNotBlank((CharSequence)configuration.rawPattern()) ? Pattern.compile(configuration.rawPattern()) : null;
        this.logger.debug("configured RAW pattern: {}", (Object)this.rawPattern);
    }

    @Override
    public TemplateMode provideTemplateMode(Resource resource) {
        String path = resource.getPath();
        if (this.htmlPattern != null && this.htmlPattern.matcher(path).matches()) {
            return TemplateMode.HTML;
        }
        if (this.xmlPattern != null && this.xmlPattern.matcher(path).matches()) {
            return TemplateMode.XML;
        }
        if (this.textPattern != null && this.textPattern.matcher(path).matches()) {
            return TemplateMode.TEXT;
        }
        if (this.javascriptPattern != null && this.javascriptPattern.matcher(path).matches()) {
            return TemplateMode.JAVASCRIPT;
        }
        if (this.cssPattern != null && this.cssPattern.matcher(path).matches()) {
            return TemplateMode.CSS;
        }
        if (this.rawPattern != null && this.rawPattern.matcher(path).matches()) {
            return TemplateMode.RAW;
        }
        return null;
    }
}

