/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.scripting.groovy.internal;

import groovy.lang.Writable;
import groovy.text.Template;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.util.Map;
import javax.script.Bindings;
import javax.script.ScriptContext;
import javax.script.ScriptEngineFactory;
import javax.script.ScriptException;
import org.apache.sling.scripting.api.AbstractSlingScriptEngine;
import org.apache.sling.scripting.groovy.internal.GStringScriptEngineFactory;

public class GStringScriptEngine
extends AbstractSlingScriptEngine {
    private final GStringScriptEngineFactory scriptEngineFactory;

    GStringScriptEngine(GStringScriptEngineFactory gStringScriptEngineFactory) {
        super((ScriptEngineFactory)((Object)gStringScriptEngineFactory));
        this.scriptEngineFactory = gStringScriptEngineFactory;
    }

    public Object eval(Reader reader, ScriptContext scriptContext) throws ScriptException {
        Template template;
        try {
            template = this.scriptEngineFactory.getTemplateEngine().createTemplate(reader);
        }
        catch (IOException | ClassNotFoundException e) {
            throw new ScriptException("Unable to compile GString template: " + e.getMessage());
        }
        Bindings bindings = scriptContext.getBindings(100);
        Writer writer = scriptContext.getWriter();
        Writable result = template.make((Map)bindings);
        try {
            result.writeTo(writer);
        }
        catch (IOException e) {
            throw new ScriptException("Unable to write result of script execution: " + e.getMessage());
        }
        return null;
    }
}

