/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.rewriter.impl.components;

import java.io.StringWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.sax.SAXTransformerFactory;
import javax.xml.transform.sax.TransformerHandler;
import javax.xml.transform.stream.StreamResult;
import org.apache.sling.rewriter.Serializer;
import org.apache.sling.rewriter.SerializerFactory;
import org.apache.sling.rewriter.impl.components.TraxErrorHandler;
import org.apache.sling.rewriter.impl.components.TraxSerializer;
import org.osgi.service.component.ComponentContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.ext.LexicalHandler;
import org.xml.sax.helpers.AttributesImpl;

public abstract class AbstractTraxSerializerFactory
implements SerializerFactory {
    private final Logger logger = LoggerFactory.getLogger((String)this.getClass().getName());
    private SAXTransformerFactory tfactory;
    private boolean needsNamespacesAsAttributes;

    protected abstract String getOutputFormat();

    protected abstract String getDoctypePublic();

    protected abstract String getDoctypeSystem();

    @Override
    public Serializer createSerializer() {
        ContentHandler ch;
        TransformerHandler tHandler = null;
        try {
            tHandler = this.tfactory.newTransformerHandler();
        }
        catch (TransformerConfigurationException e) {
            this.logger.error("Unable to create new transformer handler.", (Throwable)e);
        }
        if (this.needsNamespacesAsAttributes) {
            NamespaceAsAttributes nsPipeline = new NamespaceAsAttributes(tHandler, this.logger);
            ch = nsPipeline;
        } else {
            ch = tHandler;
        }
        return new TraxSerializer(tHandler, ch, this.getOutputFormat(), this.getDoctypePublic(), this.getDoctypeSystem());
    }

    protected void activate(ComponentContext ctx) {
        this.tfactory = (SAXTransformerFactory)TransformerFactory.newInstance();
        this.tfactory.setErrorListener(new TraxErrorHandler(this.logger));
        try {
            this.needsNamespacesAsAttributes = this.needsNamespacesAsAttributes();
        }
        catch (Exception e) {
            this.logger.warn("Cannot know if transformer needs namespaces attributes - assuming NO.", (Throwable)e);
            this.needsNamespacesAsAttributes = false;
        }
    }

    protected void deactivat(ComponentContext ctx) {
        this.tfactory = null;
    }

    protected boolean needsNamespacesAsAttributes() throws Exception {
        StringWriter writer = new StringWriter();
        String uri = "namespaceuri";
        String prefix = "nsp";
        String check = "xmlns:nsp='namespaceuri'";
        TransformerHandler handler = this.tfactory.newTransformerHandler();
        handler.setResult(new StreamResult(writer));
        handler.startDocument();
        handler.startPrefixMapping("nsp", "namespaceuri");
        handler.startElement("namespaceuri", "element", "element", new AttributesImpl());
        handler.endElement("namespaceuri", "element", "element");
        handler.endPrefixMapping("nsp");
        handler.endDocument();
        String text = writer.toString();
        return text.replace('\"', '\'').indexOf("xmlns:nsp='namespaceuri'") == -1;
    }

    public static class NamespaceAsAttributes
    implements ContentHandler,
    LexicalHandler {
        private static final String XML_NAMESPACE_URI = "http://www.w3.org/XML/1998/namespace";
        private List<String> prefixList = new ArrayList<String>();
        private List<String> uriList = new ArrayList<String>();
        private Map<String, String> uriToPrefixMap = new HashMap<String, String>();
        private Map<String, String> prefixToUriMap = new HashMap<String, String>();
        private boolean hasMappings = false;
        protected final ContentHandler contentHandler;
        protected final LexicalHandler lexicalHandler;
        protected final Logger logger;

        public NamespaceAsAttributes(ContentHandler handler, Logger logger) {
            this.contentHandler = handler;
            this.lexicalHandler = (LexicalHandler)((Object)handler);
            this.logger = logger;
        }

        @Override
        public void setDocumentLocator(Locator locator) {
            this.contentHandler.setDocumentLocator(locator);
        }

        @Override
        public void characters(char[] c, int start, int len) throws SAXException {
            this.contentHandler.characters(c, start, len);
        }

        @Override
        public void ignorableWhitespace(char[] c, int start, int len) throws SAXException {
            this.contentHandler.ignorableWhitespace(c, start, len);
        }

        @Override
        public void processingInstruction(String target, String data) throws SAXException {
            this.contentHandler.processingInstruction(target, data);
        }

        @Override
        public void skippedEntity(String name) throws SAXException {
            this.contentHandler.skippedEntity(name);
        }

        @Override
        public void startDTD(String name, String publicId, String systemId) throws SAXException {
            this.lexicalHandler.startDTD(name, publicId, systemId);
        }

        @Override
        public void endDTD() throws SAXException {
            this.lexicalHandler.endDTD();
        }

        @Override
        public void startEntity(String name) throws SAXException {
            this.lexicalHandler.startEntity(name);
        }

        @Override
        public void endEntity(String name) throws SAXException {
            this.lexicalHandler.endEntity(name);
        }

        @Override
        public void startCDATA() throws SAXException {
            this.lexicalHandler.startCDATA();
        }

        @Override
        public void endCDATA() throws SAXException {
            this.lexicalHandler.endCDATA();
        }

        @Override
        public void comment(char[] ch, int start, int len) throws SAXException {
            this.lexicalHandler.comment(ch, start, len);
        }

        @Override
        public void startDocument() throws SAXException {
            this.uriToPrefixMap.clear();
            this.prefixToUriMap.clear();
            this.clearMappings();
            this.contentHandler.startDocument();
        }

        @Override
        public void startPrefixMapping(String prefix, String uri) throws SAXException {
            if (uri != null && !prefix.startsWith("xml")) {
                this.hasMappings = true;
                this.prefixList.add(prefix);
                this.uriList.add(uri);
                if (prefix.length() > 0) {
                    this.uriToPrefixMap.put(uri, prefix + ":");
                } else {
                    this.uriToPrefixMap.put(uri, prefix);
                }
                this.prefixToUriMap.put(prefix, uri);
            }
            this.contentHandler.startPrefixMapping(prefix, uri);
        }

        @Override
        public void startElement(String eltUri, String eltLocalName, String eltQName, Attributes attrs) throws SAXException {
            if (null != eltUri && eltUri.length() != 0 && this.uriToPrefixMap.containsKey(eltUri)) {
                eltQName = this.uriToPrefixMap.get(eltUri) + eltLocalName;
            }
            if (this.hasMappings) {
                AttributesImpl newAttrs = null;
                int mappingCount = this.prefixList.size();
                int attrCount = attrs.getLength();
                for (int mapping = 0; mapping < mappingCount; ++mapping) {
                    String uri = this.uriList.get(mapping);
                    String prefix = this.prefixList.get(mapping);
                    String qName = prefix.equals("") ? "xmlns" : "xmlns:" + prefix;
                    boolean found = false;
                    for (int attr = 0; attr < attrCount; ++attr) {
                        if (!qName.equals(attrs.getQName(attr))) continue;
                        if (!uri.equals(attrs.getValue(attr))) {
                            this.logger.error("URI in prefix mapping and attribute do not match : '" + uri + "' - '" + attrs.getURI(attr) + "'");
                            throw new SAXException("URI in prefix mapping and attribute do not match");
                        }
                        found = true;
                        break;
                    }
                    if (found) continue;
                    if (newAttrs == null) {
                        newAttrs = attrCount == 0 ? new AttributesImpl() : new AttributesImpl(attrs);
                    }
                    if (prefix.equals("")) {
                        newAttrs.addAttribute(XML_NAMESPACE_URI, "xmlns", "xmlns", "CDATA", uri);
                        continue;
                    }
                    newAttrs.addAttribute(XML_NAMESPACE_URI, prefix, qName, "CDATA", uri);
                }
                this.clearMappings();
                this.contentHandler.startElement(eltUri, eltLocalName, eltQName, newAttrs == null ? attrs : newAttrs);
            } else {
                this.contentHandler.startElement(eltUri, eltLocalName, eltQName, attrs);
            }
        }

        @Override
        public void endElement(String eltUri, String eltLocalName, String eltQName) throws SAXException {
            if (null != eltUri && eltUri.length() != 0 && this.uriToPrefixMap.containsKey(eltUri)) {
                eltQName = this.uriToPrefixMap.get(eltUri) + eltLocalName;
            }
            this.contentHandler.endElement(eltUri, eltLocalName, eltQName);
        }

        @Override
        public void endPrefixMapping(String prefix) throws SAXException {
            int pos;
            if (this.prefixToUriMap.containsKey(prefix)) {
                this.uriToPrefixMap.remove(this.prefixToUriMap.get(prefix));
                this.prefixToUriMap.remove(prefix);
            }
            if (this.hasMappings && (pos = this.prefixList.lastIndexOf(prefix)) != -1) {
                this.prefixList.remove(pos);
                this.uriList.remove(pos);
            }
            this.contentHandler.endPrefixMapping(prefix);
        }

        @Override
        public void endDocument() throws SAXException {
            this.uriToPrefixMap.clear();
            this.prefixToUriMap.clear();
            this.clearMappings();
            this.contentHandler.endDocument();
        }

        private void clearMappings() {
            this.hasMappings = false;
            this.prefixList.clear();
            this.uriList.clear();
        }
    }
}

